/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.it.unimi.dsi.fastutil.longs;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.apache.parquet.it.unimi.dsi.fastutil.HashCommon;
import org.apache.parquet.it.unimi.dsi.fastutil.longs.AbstractLongCollection;
import org.apache.parquet.it.unimi.dsi.fastutil.longs.AbstractLongListIterator;
import org.apache.parquet.it.unimi.dsi.fastutil.longs.LongCollection;
import org.apache.parquet.it.unimi.dsi.fastutil.longs.LongList;
import org.apache.parquet.it.unimi.dsi.fastutil.longs.LongListIterator;
import org.apache.parquet.it.unimi.dsi.fastutil.longs.LongStack;

public abstract class AbstractLongList
extends AbstractLongCollection
implements LongList,
LongStack {
    protected AbstractLongList() {
    }

    protected void ensureIndex(int index2) {
        if (index2 < 0) {
            throw new IndexOutOfBoundsException("Index (" + index2 + ") is negative");
        }
        if (index2 > this.size()) {
            throw new IndexOutOfBoundsException("Index (" + index2 + ") is greater than list size (" + this.size() + ")");
        }
    }

    protected void ensureRestrictedIndex(int index2) {
        if (index2 < 0) {
            throw new IndexOutOfBoundsException("Index (" + index2 + ") is negative");
        }
        if (index2 >= this.size()) {
            throw new IndexOutOfBoundsException("Index (" + index2 + ") is greater than or equal to list size (" + this.size() + ")");
        }
    }

    @Override
    public void add(int index2, long k) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(long k) {
        this.add(this.size(), k);
        return true;
    }

    @Override
    public long removeLong(int i) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long set(int index2, long k) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index2, Collection<? extends Long> c) {
        this.ensureIndex(index2);
        int n = c.size();
        if (n == 0) {
            return false;
        }
        Iterator<? extends Long> i = c.iterator();
        while (n-- != 0) {
            this.add(index2++, i.next());
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends Long> c) {
        return this.addAll(this.size(), c);
    }

    @Override
    @Deprecated
    public LongListIterator longListIterator() {
        return this.listIterator();
    }

    @Override
    @Deprecated
    public LongListIterator longListIterator(int index2) {
        return this.listIterator(index2);
    }

    @Override
    public LongListIterator iterator() {
        return this.listIterator();
    }

    @Override
    public LongListIterator listIterator() {
        return this.listIterator(0);
    }

    @Override
    public LongListIterator listIterator(final int index2) {
        return new AbstractLongListIterator(){
            int pos;
            int last;
            {
                this.pos = index2;
                this.last = -1;
            }

            @Override
            public boolean hasNext() {
                return this.pos < AbstractLongList.this.size();
            }

            @Override
            public boolean hasPrevious() {
                return this.pos > 0;
            }

            @Override
            public long nextLong() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.last = this.pos++;
                return AbstractLongList.this.getLong(this.last);
            }

            @Override
            public long previousLong() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                this.last = --this.pos;
                return AbstractLongList.this.getLong(this.pos);
            }

            @Override
            public int nextIndex() {
                return this.pos;
            }

            @Override
            public int previousIndex() {
                return this.pos - 1;
            }

            @Override
            public void add(long k) {
                if (this.last == -1) {
                    throw new IllegalStateException();
                }
                AbstractLongList.this.add(this.pos++, k);
                this.last = -1;
            }

            @Override
            public void set(long k) {
                if (this.last == -1) {
                    throw new IllegalStateException();
                }
                AbstractLongList.this.set(this.last, k);
            }

            @Override
            public void remove() {
                if (this.last == -1) {
                    throw new IllegalStateException();
                }
                AbstractLongList.this.removeLong(this.last);
                if (this.last < this.pos) {
                    --this.pos;
                }
                this.last = -1;
            }
        };
    }

    @Override
    public boolean contains(long k) {
        return this.indexOf(k) >= 0;
    }

    @Override
    public int indexOf(long k) {
        LongListIterator i = this.listIterator();
        while (i.hasNext()) {
            long e = i.nextLong();
            if (k != e) continue;
            return i.previousIndex();
        }
        return -1;
    }

    @Override
    public int lastIndexOf(long k) {
        LongListIterator i = this.listIterator(this.size());
        while (i.hasPrevious()) {
            long e = i.previousLong();
            if (k != e) continue;
            return i.nextIndex();
        }
        return -1;
    }

    @Override
    public void size(int size2) {
        int i = this.size();
        if (size2 > i) {
            while (i++ < size2) {
                this.add(0L);
            }
        } else {
            while (i-- != size2) {
                this.remove(i);
            }
        }
    }

    @Override
    public LongList subList(int from2, int to2) {
        this.ensureIndex(from2);
        this.ensureIndex(to2);
        if (from2 > to2) {
            throw new IndexOutOfBoundsException("Start index (" + from2 + ") is greater than end index (" + to2 + ")");
        }
        return new LongSubList(this, from2, to2);
    }

    @Override
    @Deprecated
    public LongList longSubList(int from2, int to2) {
        return this.subList(from2, to2);
    }

    @Override
    public void removeElements(int from2, int to2) {
        this.ensureIndex(to2);
        LongListIterator i = this.listIterator(from2);
        int n = to2 - from2;
        if (n < 0) {
            throw new IllegalArgumentException("Start index (" + from2 + ") is greater than end index (" + to2 + ")");
        }
        while (n-- != 0) {
            i.nextLong();
            i.remove();
        }
    }

    @Override
    public void addElements(int index2, long[] a, int offset, int length) {
        this.ensureIndex(index2);
        if (offset < 0) {
            throw new ArrayIndexOutOfBoundsException("Offset (" + offset + ") is negative");
        }
        if (offset + length > a.length) {
            throw new ArrayIndexOutOfBoundsException("End index (" + (offset + length) + ") is greater than array length (" + a.length + ")");
        }
        while (length-- != 0) {
            this.add(index2++, a[offset++]);
        }
    }

    @Override
    public void addElements(int index2, long[] a) {
        this.addElements(index2, a, 0, a.length);
    }

    @Override
    public void getElements(int from2, long[] a, int offset, int length) {
        LongListIterator i = this.listIterator(from2);
        if (offset < 0) {
            throw new ArrayIndexOutOfBoundsException("Offset (" + offset + ") is negative");
        }
        if (offset + length > a.length) {
            throw new ArrayIndexOutOfBoundsException("End index (" + (offset + length) + ") is greater than array length (" + a.length + ")");
        }
        if (from2 + length > this.size()) {
            throw new IndexOutOfBoundsException("End index (" + (from2 + length) + ") is greater than list size (" + this.size() + ")");
        }
        while (length-- != 0) {
            a[offset++] = i.nextLong();
        }
    }

    private boolean valEquals(Object a, Object b) {
        return a == null ? b == null : a.equals(b);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof List)) {
            return false;
        }
        List l = (List)o;
        int s2 = this.size();
        if (s2 != l.size()) {
            return false;
        }
        if (l instanceof LongList) {
            LongListIterator i1 = this.listIterator();
            LongListIterator i2 = ((LongList)l).listIterator();
            while (s2-- != 0) {
                if (i1.nextLong() == i2.nextLong()) continue;
                return false;
            }
            return true;
        }
        LongListIterator i1 = this.listIterator();
        ListIterator i2 = l.listIterator();
        while (s2-- != 0) {
            if (this.valEquals(i1.next(), i2.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(List<? extends Long> l) {
        if (l == this) {
            return 0;
        }
        if (l instanceof LongList) {
            LongListIterator i1 = this.listIterator();
            LongListIterator i2 = ((LongList)l).listIterator();
            while (i1.hasNext() && i2.hasNext()) {
                int r;
                long e2;
                long e1 = i1.nextLong();
                if ((e1 < (e2 = i2.nextLong()) ? -1 : (r = e1 == e2 ? 0 : 1)) == 0) continue;
                return r;
            }
            return i2.hasNext() ? -1 : (i1.hasNext() ? 1 : 0);
        }
        LongListIterator i1 = this.listIterator();
        ListIterator<? extends Long> i2 = l.listIterator();
        while (i1.hasNext() && i2.hasNext()) {
            int r = ((Comparable)i1.next()).compareTo(i2.next());
            if (r == 0) continue;
            return r;
        }
        return i2.hasNext() ? -1 : (i1.hasNext() ? 1 : 0);
    }

    @Override
    public int hashCode() {
        LongListIterator i = this.iterator();
        int h = 1;
        int s2 = this.size();
        while (s2-- != 0) {
            long k = i.nextLong();
            h = 31 * h + HashCommon.long2int(k);
        }
        return h;
    }

    @Override
    public void push(long o) {
        this.add(o);
    }

    @Override
    public long popLong() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.removeLong(this.size() - 1);
    }

    @Override
    public long topLong() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.getLong(this.size() - 1);
    }

    @Override
    public long peekLong(int i) {
        return this.getLong(this.size() - 1 - i);
    }

    @Override
    public boolean rem(long k) {
        int index2 = this.indexOf(k);
        if (index2 == -1) {
            return false;
        }
        this.removeLong(index2);
        return true;
    }

    @Override
    public boolean remove(Object o) {
        return this.rem((Long)o);
    }

    @Override
    public boolean addAll(int index2, LongCollection c) {
        return this.addAll(index2, (Collection<? extends Long>)c);
    }

    @Override
    public boolean addAll(int index2, LongList l) {
        return this.addAll(index2, (LongCollection)l);
    }

    @Override
    public boolean addAll(LongCollection c) {
        return this.addAll(this.size(), c);
    }

    @Override
    public boolean addAll(LongList l) {
        return this.addAll(this.size(), l);
    }

    @Override
    public void add(int index2, Long ok) {
        this.add(index2, (long)ok);
    }

    @Override
    public Long set(int index2, Long ok) {
        return this.set(index2, (long)ok);
    }

    @Override
    public Long get(int index2) {
        return this.getLong(index2);
    }

    @Override
    public int indexOf(Object ok) {
        return this.indexOf((Long)ok);
    }

    @Override
    public int lastIndexOf(Object ok) {
        return this.lastIndexOf((Long)ok);
    }

    @Override
    public Long remove(int index2) {
        return this.removeLong(index2);
    }

    @Override
    public void push(Long o) {
        this.push((long)o);
    }

    @Override
    public Long pop() {
        return this.popLong();
    }

    @Override
    public Long top() {
        return this.topLong();
    }

    @Override
    public Long peek(int i) {
        return this.peekLong(i);
    }

    @Override
    public String toString() {
        StringBuilder s2 = new StringBuilder();
        LongListIterator i = this.iterator();
        int n = this.size();
        boolean first2 = true;
        s2.append("[");
        while (n-- != 0) {
            if (first2) {
                first2 = false;
            } else {
                s2.append(", ");
            }
            long k = i.nextLong();
            s2.append(String.valueOf(k));
        }
        s2.append("]");
        return s2.toString();
    }

    public static class LongSubList
    extends AbstractLongList
    implements Serializable {
        private static final long serialVersionUID = -7046029254386353129L;
        protected final LongList l;
        protected final int from;
        protected int to;
        private static final boolean ASSERTS = false;

        public LongSubList(LongList l, int from2, int to2) {
            this.l = l;
            this.from = from2;
            this.to = to2;
        }

        private void assertRange() {
        }

        @Override
        public boolean add(long k) {
            this.l.add(this.to, k);
            ++this.to;
            return true;
        }

        @Override
        public void add(int index2, long k) {
            this.ensureIndex(index2);
            this.l.add(this.from + index2, k);
            ++this.to;
        }

        @Override
        public boolean addAll(int index2, Collection<? extends Long> c) {
            this.ensureIndex(index2);
            this.to += c.size();
            return this.l.addAll(this.from + index2, c);
        }

        @Override
        public long getLong(int index2) {
            this.ensureRestrictedIndex(index2);
            return this.l.getLong(this.from + index2);
        }

        @Override
        public long removeLong(int index2) {
            this.ensureRestrictedIndex(index2);
            --this.to;
            return this.l.removeLong(this.from + index2);
        }

        @Override
        public long set(int index2, long k) {
            this.ensureRestrictedIndex(index2);
            return this.l.set(this.from + index2, k);
        }

        @Override
        public void clear() {
            this.removeElements(0, this.size());
        }

        @Override
        public int size() {
            return this.to - this.from;
        }

        @Override
        public void getElements(int from2, long[] a, int offset, int length) {
            this.ensureIndex(from2);
            if (from2 + length > this.size()) {
                throw new IndexOutOfBoundsException("End index (" + from2 + length + ") is greater than list size (" + this.size() + ")");
            }
            this.l.getElements(this.from + from2, a, offset, length);
        }

        @Override
        public void removeElements(int from2, int to2) {
            this.ensureIndex(from2);
            this.ensureIndex(to2);
            this.l.removeElements(this.from + from2, this.from + to2);
            this.to -= to2 - from2;
        }

        @Override
        public void addElements(int index2, long[] a, int offset, int length) {
            this.ensureIndex(index2);
            this.l.addElements(this.from + index2, a, offset, length);
            this.to += length;
        }

        @Override
        public LongListIterator listIterator(final int index2) {
            this.ensureIndex(index2);
            return new AbstractLongListIterator(){
                int pos;
                int last;
                {
                    this.pos = index2;
                    this.last = -1;
                }

                @Override
                public boolean hasNext() {
                    return this.pos < LongSubList.this.size();
                }

                @Override
                public boolean hasPrevious() {
                    return this.pos > 0;
                }

                @Override
                public long nextLong() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    this.last = this.pos++;
                    return LongSubList.this.l.getLong(LongSubList.this.from + this.last);
                }

                @Override
                public long previousLong() {
                    if (!this.hasPrevious()) {
                        throw new NoSuchElementException();
                    }
                    this.last = --this.pos;
                    return LongSubList.this.l.getLong(LongSubList.this.from + this.pos);
                }

                @Override
                public int nextIndex() {
                    return this.pos;
                }

                @Override
                public int previousIndex() {
                    return this.pos - 1;
                }

                @Override
                public void add(long k) {
                    if (this.last == -1) {
                        throw new IllegalStateException();
                    }
                    LongSubList.this.add(this.pos++, k);
                    this.last = -1;
                }

                @Override
                public void set(long k) {
                    if (this.last == -1) {
                        throw new IllegalStateException();
                    }
                    LongSubList.this.set(this.last, k);
                }

                @Override
                public void remove() {
                    if (this.last == -1) {
                        throw new IllegalStateException();
                    }
                    LongSubList.this.removeLong(this.last);
                    if (this.last < this.pos) {
                        --this.pos;
                    }
                    this.last = -1;
                }
            };
        }

        @Override
        public LongList subList(int from2, int to2) {
            this.ensureIndex(from2);
            this.ensureIndex(to2);
            if (from2 > to2) {
                throw new IllegalArgumentException("Start index (" + from2 + ") is greater than end index (" + to2 + ")");
            }
            return new LongSubList(this, from2, to2);
        }

        @Override
        public boolean rem(long k) {
            int index2 = this.indexOf(k);
            if (index2 == -1) {
                return false;
            }
            --this.to;
            this.l.removeLong(this.from + index2);
            return true;
        }

        @Override
        public boolean remove(Object o) {
            return this.rem((Long)o);
        }

        @Override
        public boolean addAll(int index2, LongCollection c) {
            this.ensureIndex(index2);
            this.to += c.size();
            return this.l.addAll(this.from + index2, c);
        }

        @Override
        public boolean addAll(int index2, LongList l) {
            this.ensureIndex(index2);
            this.to += l.size();
            return this.l.addAll(this.from + index2, l);
        }
    }
}

