/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.it.unimi.dsi.fastutil.ints;

import java.io.Serializable;
import java.util.Random;
import org.apache.parquet.it.unimi.dsi.fastutil.Arrays;
import org.apache.parquet.it.unimi.dsi.fastutil.Hash;
import org.apache.parquet.it.unimi.dsi.fastutil.ints.IntComparator;

public class IntArrays {
    public static final int[] EMPTY_ARRAY = new int[0];
    private static final int SMALL = 7;
    private static final int MEDIUM = 50;
    private static final int DIGIT_BITS = 8;
    private static final int DIGIT_MASK = 255;
    private static final int DIGITS_PER_ELEMENT = 4;
    public static final Hash.Strategy<int[]> HASH_STRATEGY = new ArrayHashStrategy();

    private IntArrays() {
    }

    public static int[] ensureCapacity(int[] array2, int length) {
        if (length > array2.length) {
            int[] t = new int[length];
            System.arraycopy(array2, 0, t, 0, array2.length);
            return t;
        }
        return array2;
    }

    public static int[] ensureCapacity(int[] array2, int length, int preserve) {
        if (length > array2.length) {
            int[] t = new int[length];
            System.arraycopy(array2, 0, t, 0, preserve);
            return t;
        }
        return array2;
    }

    public static int[] grow(int[] array2, int length) {
        if (length > array2.length) {
            int newLength = (int)Math.min(Math.max(2L * (long)array2.length, (long)length), 0x7FFFFFF7L);
            int[] t = new int[newLength];
            System.arraycopy(array2, 0, t, 0, array2.length);
            return t;
        }
        return array2;
    }

    public static int[] grow(int[] array2, int length, int preserve) {
        if (length > array2.length) {
            int newLength = (int)Math.min(Math.max(2L * (long)array2.length, (long)length), 0x7FFFFFF7L);
            int[] t = new int[newLength];
            System.arraycopy(array2, 0, t, 0, preserve);
            return t;
        }
        return array2;
    }

    public static int[] trim(int[] array2, int length) {
        if (length >= array2.length) {
            return array2;
        }
        int[] t = length == 0 ? EMPTY_ARRAY : new int[length];
        System.arraycopy(array2, 0, t, 0, length);
        return t;
    }

    public static int[] setLength(int[] array2, int length) {
        if (length == array2.length) {
            return array2;
        }
        if (length < array2.length) {
            return IntArrays.trim(array2, length);
        }
        return IntArrays.ensureCapacity(array2, length);
    }

    public static int[] copy(int[] array2, int offset, int length) {
        IntArrays.ensureOffsetLength(array2, offset, length);
        int[] a = length == 0 ? EMPTY_ARRAY : new int[length];
        System.arraycopy(array2, offset, a, 0, length);
        return a;
    }

    public static int[] copy(int[] array2) {
        return (int[])array2.clone();
    }

    public static void fill(int[] array2, int value2) {
        int i = array2.length;
        while (i-- != 0) {
            array2[i] = value2;
        }
    }

    public static void fill(int[] array2, int from2, int to2, int value2) {
        IntArrays.ensureFromTo(array2, from2, to2);
        if (from2 == 0) {
            while (to2-- != 0) {
                array2[to2] = value2;
            }
        } else {
            for (int i = from2; i < to2; ++i) {
                array2[i] = value2;
            }
        }
    }

    @Deprecated
    public static boolean equals(int[] a1, int[] a2) {
        int i = a1.length;
        if (i != a2.length) {
            return false;
        }
        while (i-- != 0) {
            if (a1[i] == a2[i]) continue;
            return false;
        }
        return true;
    }

    public static void ensureFromTo(int[] a, int from2, int to2) {
        Arrays.ensureFromTo(a.length, from2, to2);
    }

    public static void ensureOffsetLength(int[] a, int offset, int length) {
        Arrays.ensureOffsetLength(a.length, offset, length);
    }

    private static void swap(int[] x, int a, int b) {
        int t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    private static void vecSwap(int[] x, int a, int b, int n) {
        int i = 0;
        while (i < n) {
            IntArrays.swap(x, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    private static int med3(int[] x, int a, int b, int c, IntComparator comp) {
        int ab = comp.compare(x[a], x[b]);
        int ac = comp.compare(x[a], x[c]);
        int bc = comp.compare(x[b], x[c]);
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c : a)) : (bc > 0 ? b : (ac > 0 ? c : a));
    }

    private static void selectionSort(int[] a, int from2, int to2, IntComparator comp) {
        for (int i = from2; i < to2 - 1; ++i) {
            int m = i;
            for (int j = i + 1; j < to2; ++j) {
                if (comp.compare(a[j], a[m]) >= 0) continue;
                m = j;
            }
            if (m == i) continue;
            int u = a[i];
            a[i] = a[m];
            a[m] = u;
        }
    }

    private static void insertionSort(int[] a, int from2, int to2, IntComparator comp) {
        int i = from2;
        while (++i < to2) {
            int t = a[i];
            int j = i;
            int u = a[j - 1];
            while (comp.compare(t, u) < 0) {
                a[j] = u;
                if (from2 == j - 1) {
                    --j;
                    break;
                }
                u = a[--j - 1];
            }
            a[j] = t;
        }
    }

    private static void selectionSort(int[] a, int from2, int to2) {
        for (int i = from2; i < to2 - 1; ++i) {
            int m = i;
            for (int j = i + 1; j < to2; ++j) {
                if (a[j] >= a[m]) continue;
                m = j;
            }
            if (m == i) continue;
            int u = a[i];
            a[i] = a[m];
            a[m] = u;
        }
    }

    private static void insertionSort(int[] a, int from2, int to2) {
        int i = from2;
        while (++i < to2) {
            int t = a[i];
            int j = i;
            int u = a[j - 1];
            while (t < u) {
                a[j] = u;
                if (from2 == j - 1) {
                    --j;
                    break;
                }
                u = a[--j - 1];
            }
            a[j] = t;
        }
    }

    public static void quickSort(int[] x, int from2, int to2, IntComparator comp) {
        int c;
        int a;
        int len = to2 - from2;
        if (len < 7) {
            IntArrays.selectionSort(x, from2, to2, comp);
            return;
        }
        int m = from2 + len / 2;
        if (len > 7) {
            int l = from2;
            int n = to2 - 1;
            if (len > 50) {
                int s2 = len / 8;
                l = IntArrays.med3(x, l, l + s2, l + 2 * s2, comp);
                m = IntArrays.med3(x, m - s2, m, m + s2, comp);
                n = IntArrays.med3(x, n - 2 * s2, n - s2, n, comp);
            }
            m = IntArrays.med3(x, l, m, n, comp);
        }
        int v = x[m];
        int b = a = from2;
        int d = c = to2 - 1;
        while (true) {
            int comparison;
            if (b <= c && (comparison = comp.compare(x[b], v)) <= 0) {
                if (comparison == 0) {
                    IntArrays.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (comparison = comp.compare(x[c], v)) >= 0) {
                if (comparison == 0) {
                    IntArrays.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            IntArrays.swap(x, b++, c--);
        }
        int n = to2;
        int s3 = Math.min(a - from2, b - a);
        IntArrays.vecSwap(x, from2, b - s3, s3);
        s3 = Math.min(d - c, n - d - 1);
        IntArrays.vecSwap(x, b, n - s3, s3);
        s3 = b - a;
        if (s3 > 1) {
            IntArrays.quickSort(x, from2, from2 + s3, comp);
        }
        if ((s3 = d - c) > 1) {
            IntArrays.quickSort(x, n - s3, n, comp);
        }
    }

    public static void quickSort(int[] x, IntComparator comp) {
        IntArrays.quickSort(x, 0, x.length, comp);
    }

    private static int med3(int[] x, int a, int b, int c) {
        int bc;
        int ac;
        int ab;
        int n = x[a] < x[b] ? -1 : (ab = x[a] == x[b] ? 0 : 1);
        int n2 = x[a] < x[c] ? -1 : (ac = x[a] == x[c] ? 0 : 1);
        int n3 = x[b] < x[c] ? -1 : (bc = x[b] == x[c] ? 0 : 1);
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c : a)) : (bc > 0 ? b : (ac > 0 ? c : a));
    }

    @Deprecated
    public static void quickSort(int[] x, int from2, int to2) {
        int c;
        int a;
        int len = to2 - from2;
        if (len < 7) {
            IntArrays.selectionSort(x, from2, to2);
            return;
        }
        int m = from2 + len / 2;
        if (len > 7) {
            int l = from2;
            int n = to2 - 1;
            if (len > 50) {
                int s2 = len / 8;
                l = IntArrays.med3(x, l, l + s2, l + 2 * s2);
                m = IntArrays.med3(x, m - s2, m, m + s2);
                n = IntArrays.med3(x, n - 2 * s2, n - s2, n);
            }
            m = IntArrays.med3(x, l, m, n);
        }
        int v = x[m];
        int b = a = from2;
        int d = c = to2 - 1;
        while (true) {
            int comparison;
            if (b <= c && (x[b] < v ? -1 : (comparison = x[b] == v ? 0 : 1)) <= 0) {
                if (comparison == 0) {
                    IntArrays.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (x[c] < v ? -1 : (comparison = x[c] == v ? 0 : 1)) >= 0) {
                if (comparison == 0) {
                    IntArrays.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            IntArrays.swap(x, b++, c--);
        }
        int n = to2;
        int s3 = Math.min(a - from2, b - a);
        IntArrays.vecSwap(x, from2, b - s3, s3);
        s3 = Math.min(d - c, n - d - 1);
        IntArrays.vecSwap(x, b, n - s3, s3);
        s3 = b - a;
        if (s3 > 1) {
            IntArrays.quickSort(x, from2, from2 + s3);
        }
        if ((s3 = d - c) > 1) {
            IntArrays.quickSort(x, n - s3, n);
        }
    }

    @Deprecated
    public static void quickSort(int[] x) {
        IntArrays.quickSort(x, 0, x.length);
    }

    public static void mergeSort(int[] a, int from2, int to2, int[] supp) {
        int len = to2 - from2;
        if (len < 7) {
            IntArrays.insertionSort(a, from2, to2);
            return;
        }
        int mid = from2 + to2 >>> 1;
        IntArrays.mergeSort(supp, from2, mid, a);
        IntArrays.mergeSort(supp, mid, to2, a);
        if (supp[mid - 1] <= supp[mid]) {
            System.arraycopy(supp, from2, a, from2, len);
            return;
        }
        int p = from2;
        int q = mid;
        for (int i = from2; i < to2; ++i) {
            a[i] = q >= to2 || p < mid && supp[p] <= supp[q] ? supp[p++] : supp[q++];
        }
    }

    public static void mergeSort(int[] a, int from2, int to2) {
        IntArrays.mergeSort(a, from2, to2, (int[])a.clone());
    }

    public static void mergeSort(int[] a) {
        IntArrays.mergeSort(a, 0, a.length);
    }

    public static void mergeSort(int[] a, int from2, int to2, IntComparator comp, int[] supp) {
        int len = to2 - from2;
        if (len < 7) {
            IntArrays.insertionSort(a, from2, to2, comp);
            return;
        }
        int mid = from2 + to2 >>> 1;
        IntArrays.mergeSort(supp, from2, mid, comp, a);
        IntArrays.mergeSort(supp, mid, to2, comp, a);
        if (comp.compare(supp[mid - 1], supp[mid]) <= 0) {
            System.arraycopy(supp, from2, a, from2, len);
            return;
        }
        int p = from2;
        int q = mid;
        for (int i = from2; i < to2; ++i) {
            a[i] = q >= to2 || p < mid && comp.compare(supp[p], supp[q]) <= 0 ? supp[p++] : supp[q++];
        }
    }

    public static void mergeSort(int[] a, int from2, int to2, IntComparator comp) {
        IntArrays.mergeSort(a, from2, to2, comp, (int[])a.clone());
    }

    public static void mergeSort(int[] a, IntComparator comp) {
        IntArrays.mergeSort(a, 0, a.length, comp);
    }

    public static int binarySearch(int[] a, int from2, int to2, int key) {
        --to2;
        while (from2 <= to2) {
            int mid = from2 + to2 >>> 1;
            int midVal = a[mid];
            if (midVal < key) {
                from2 = mid + 1;
                continue;
            }
            if (midVal > key) {
                to2 = mid - 1;
                continue;
            }
            return mid;
        }
        return -(from2 + 1);
    }

    public static int binarySearch(int[] a, int key) {
        return IntArrays.binarySearch(a, 0, a.length, key);
    }

    public static int binarySearch(int[] a, int from2, int to2, int key, IntComparator c) {
        --to2;
        while (from2 <= to2) {
            int mid = from2 + to2 >>> 1;
            int midVal = a[mid];
            int cmp = c.compare(midVal, key);
            if (cmp < 0) {
                from2 = mid + 1;
                continue;
            }
            if (cmp > 0) {
                to2 = mid - 1;
                continue;
            }
            return mid;
        }
        return -(from2 + 1);
    }

    public static int binarySearch(int[] a, int key, IntComparator c) {
        return IntArrays.binarySearch(a, 0, a.length, key, c);
    }

    public static void radixSort(int[] a) {
        IntArrays.radixSort(a, 0, a.length);
    }

    public static void radixSort(int[] a, int from2, int to2) {
        int maxLevel = 3;
        int stackSize = 766;
        int[] offsetStack = new int[766];
        int offsetPos = 0;
        int[] lengthStack = new int[766];
        int lengthPos = 0;
        int[] levelStack = new int[766];
        int levelPos = 0;
        offsetStack[offsetPos++] = from2;
        lengthStack[lengthPos++] = to2 - from2;
        levelStack[levelPos++] = 0;
        int[] count2 = new int[256];
        int[] pos = new int[256];
        byte[] digit2 = new byte[to2 - from2];
        while (offsetPos > 0) {
            int level;
            int signMask;
            int first2 = offsetStack[--offsetPos];
            int length = lengthStack[--lengthPos];
            int n = signMask = (level = levelStack[--levelPos]) % 4 == 0 ? 128 : 0;
            if (length < 50) {
                IntArrays.selectionSort(a, first2, first2 + length);
                continue;
            }
            int shift = (3 - level % 4) * 8;
            int i = length;
            while (i-- != 0) {
                digit2[i] = (byte)(a[first2 + i] >>> shift & 0xFF ^ signMask);
            }
            i = length;
            while (i-- != 0) {
                int n2 = digit2[i] & 0xFF;
                count2[n2] = count2[n2] + 1;
            }
            int lastUsed = -1;
            int p = 0;
            for (int i2 = 0; i2 < 256; ++i2) {
                if (count2[i2] != 0) {
                    lastUsed = i2;
                    if (level < 3 && count2[i2] > 1) {
                        offsetStack[offsetPos++] = p + first2;
                        lengthStack[lengthPos++] = count2[i2];
                        levelStack[levelPos++] = level + 1;
                    }
                }
                pos[i2] = p += count2[i2];
            }
            int end = length - count2[lastUsed];
            count2[lastUsed] = 0;
            int c = -1;
            for (int i3 = 0; i3 < end; i3 += count2[c]) {
                int t = a[i3 + first2];
                c = digit2[i3] & 0xFF;
                while (true) {
                    int n3 = c;
                    int n4 = pos[n3] - 1;
                    pos[n3] = n4;
                    int d = n4;
                    if (n4 <= i3) break;
                    int z2 = t;
                    int zz = c;
                    t = a[d + first2];
                    c = digit2[d] & 0xFF;
                    a[d + first2] = z2;
                    digit2[d] = (byte)zz;
                }
                a[i3 + first2] = t;
                count2[c] = 0;
            }
        }
    }

    private static void insertionSortIndirect(int[] perm, int[] a, int from2, int to2) {
        int i = from2;
        while (++i < to2) {
            int t = perm[i];
            int j = i;
            int u = perm[j - 1];
            while (a[t] < a[u]) {
                perm[j] = u;
                if (from2 == j - 1) {
                    --j;
                    break;
                }
                u = perm[--j - 1];
            }
            perm[j] = t;
        }
    }

    public static void radixSortIndirect(int[] perm, int[] a, boolean stable) {
        IntArrays.radixSortIndirect(perm, a, 0, perm.length, stable);
    }

    public static void radixSortIndirect(int[] perm, int[] a, int from2, int to2, boolean stable) {
        int maxLevel = 3;
        int stackSize = 766;
        int[] offsetStack = new int[766];
        int offsetPos = 0;
        int[] lengthStack = new int[766];
        int lengthPos = 0;
        int[] levelStack = new int[766];
        int levelPos = 0;
        offsetStack[offsetPos++] = from2;
        lengthStack[lengthPos++] = to2 - from2;
        levelStack[levelPos++] = 0;
        int[] count2 = new int[256];
        int[] pos = stable ? null : new int[256];
        int[] support = stable ? new int[perm.length] : null;
        byte[] digit2 = new byte[to2 - from2];
        while (offsetPos > 0) {
            int i;
            int level;
            int signMask;
            int first2 = offsetStack[--offsetPos];
            int length = lengthStack[--lengthPos];
            int n = signMask = (level = levelStack[--levelPos]) % 4 == 0 ? 128 : 0;
            if (length < 50) {
                IntArrays.insertionSortIndirect(perm, a, first2, first2 + length);
                continue;
            }
            int shift = (3 - level % 4) * 8;
            int i2 = length;
            while (i2-- != 0) {
                digit2[i2] = (byte)(a[perm[first2 + i2]] >>> shift & 0xFF ^ signMask);
            }
            i2 = length;
            while (i2-- != 0) {
                int n2 = digit2[i2] & 0xFF;
                count2[n2] = count2[n2] + 1;
            }
            int lastUsed = -1;
            int p = 0;
            for (i = 0; i < 256; ++i) {
                if (count2[i] != 0) {
                    lastUsed = i;
                    if (level < 3 && count2[i] > 1) {
                        offsetStack[offsetPos++] = p + first2;
                        lengthStack[lengthPos++] = count2[i];
                        levelStack[levelPos++] = level + 1;
                    }
                }
                if (stable) {
                    count2[i] = p += count2[i];
                    continue;
                }
                pos[i] = p += count2[i];
            }
            if (stable) {
                i = length;
                while (i-- != 0) {
                    int n3 = digit2[i] & 0xFF;
                    int n4 = count2[n3] - 1;
                    count2[n3] = n4;
                    support[n4] = perm[first2 + i];
                }
                System.arraycopy(support, 0, perm, first2, length);
                IntArrays.fill(count2, 0);
                continue;
            }
            int end = length - count2[lastUsed];
            count2[lastUsed] = 0;
            int c = -1;
            for (int i3 = 0; i3 < end; i3 += count2[c]) {
                int t = perm[i3 + first2];
                c = digit2[i3] & 0xFF;
                while (true) {
                    int n5 = c;
                    int n6 = pos[n5] - 1;
                    pos[n5] = n6;
                    int d = n6;
                    if (n6 <= i3) break;
                    int z2 = t;
                    int zz = c;
                    t = perm[d + first2];
                    c = digit2[d] & 0xFF;
                    perm[d + first2] = z2;
                    digit2[d] = (byte)zz;
                }
                perm[i3 + first2] = t;
                count2[c] = 0;
            }
        }
    }

    private static void selectionSort(int[] a, int[] b, int from2, int to2) {
        for (int i = from2; i < to2 - 1; ++i) {
            int m = i;
            for (int j = i + 1; j < to2; ++j) {
                if (a[j] >= a[m] && (a[j] != a[m] || b[j] >= b[m])) continue;
                m = j;
            }
            if (m == i) continue;
            int t = a[i];
            a[i] = a[m];
            a[m] = t;
            t = b[i];
            b[i] = b[m];
            b[m] = t;
        }
    }

    public static void radixSort(int[] a, int[] b) {
        IntArrays.radixSort(a, b, 0, a.length);
    }

    public static void radixSort(int[] a, int[] b, int from2, int to2) {
        int layers = 2;
        if (a.length != b.length) {
            throw new IllegalArgumentException("Array size mismatch.");
        }
        int maxLevel = 7;
        int stackSize = 1786;
        int[] offsetStack = new int[1786];
        int offsetPos = 0;
        int[] lengthStack = new int[1786];
        int lengthPos = 0;
        int[] levelStack = new int[1786];
        int levelPos = 0;
        offsetStack[offsetPos++] = from2;
        lengthStack[lengthPos++] = to2 - from2;
        levelStack[levelPos++] = 0;
        int[] count2 = new int[256];
        int[] pos = new int[256];
        byte[] digit2 = new byte[to2 - from2];
        while (offsetPos > 0) {
            int level;
            int signMask;
            int first2 = offsetStack[--offsetPos];
            int length = lengthStack[--lengthPos];
            int n = signMask = (level = levelStack[--levelPos]) % 4 == 0 ? 128 : 0;
            if (length < 50) {
                IntArrays.selectionSort(a, b, first2, first2 + length);
                continue;
            }
            int[] k = level < 4 ? a : b;
            int shift = (3 - level % 4) * 8;
            int i = length;
            while (i-- != 0) {
                digit2[i] = (byte)(k[first2 + i] >>> shift & 0xFF ^ signMask);
            }
            i = length;
            while (i-- != 0) {
                int n2 = digit2[i] & 0xFF;
                count2[n2] = count2[n2] + 1;
            }
            int lastUsed = -1;
            int p = 0;
            for (int i2 = 0; i2 < 256; ++i2) {
                if (count2[i2] != 0) {
                    lastUsed = i2;
                    if (level < 7 && count2[i2] > 1) {
                        offsetStack[offsetPos++] = p + first2;
                        lengthStack[lengthPos++] = count2[i2];
                        levelStack[levelPos++] = level + 1;
                    }
                }
                pos[i2] = p += count2[i2];
            }
            int end = length - count2[lastUsed];
            count2[lastUsed] = 0;
            int c = -1;
            for (int i3 = 0; i3 < end; i3 += count2[c]) {
                int t = a[i3 + first2];
                int u = b[i3 + first2];
                c = digit2[i3] & 0xFF;
                while (true) {
                    int n3 = c;
                    int n4 = pos[n3] - 1;
                    pos[n3] = n4;
                    int d = n4;
                    if (n4 <= i3) break;
                    int z2 = t;
                    int zz = c;
                    t = a[d + first2];
                    a[d + first2] = z2;
                    z2 = u;
                    u = b[d + first2];
                    b[d + first2] = z2;
                    c = digit2[d] & 0xFF;
                    digit2[d] = (byte)zz;
                }
                a[i3 + first2] = t;
                b[i3 + first2] = u;
                count2[c] = 0;
            }
        }
    }

    private static void insertionSortIndirect(int[] perm, int[] a, int[] b, int from2, int to2) {
        int i = from2;
        while (++i < to2) {
            int t = perm[i];
            int j = i;
            int u = perm[j - 1];
            while (a[t] < a[u] || a[t] == a[u] && b[t] < b[u]) {
                perm[j] = u;
                if (from2 == j - 1) {
                    --j;
                    break;
                }
                u = perm[--j - 1];
            }
            perm[j] = t;
        }
    }

    public static void radixSortIndirect(int[] perm, int[] a, int[] b, boolean stable) {
        IntArrays.radixSortIndirect(perm, a, b, 0, perm.length, stable);
    }

    public static void radixSortIndirect(int[] perm, int[] a, int[] b, int from2, int to2, boolean stable) {
        int layers = 2;
        if (a.length != b.length) {
            throw new IllegalArgumentException("Array size mismatch.");
        }
        int maxLevel = 7;
        int stackSize = 1786;
        int[] offsetStack = new int[1786];
        int offsetPos = 0;
        int[] lengthStack = new int[1786];
        int lengthPos = 0;
        int[] levelStack = new int[1786];
        int levelPos = 0;
        offsetStack[offsetPos++] = from2;
        lengthStack[lengthPos++] = to2 - from2;
        levelStack[levelPos++] = 0;
        int[] count2 = new int[256];
        int[] pos = stable ? null : new int[256];
        int[] support = stable ? new int[perm.length] : null;
        byte[] digit2 = new byte[to2 - from2];
        while (offsetPos > 0) {
            int i;
            int level;
            int signMask;
            int first2 = offsetStack[--offsetPos];
            int length = lengthStack[--lengthPos];
            int n = signMask = (level = levelStack[--levelPos]) % 4 == 0 ? 128 : 0;
            if (length < 50) {
                IntArrays.insertionSortIndirect(perm, a, b, first2, first2 + length);
                continue;
            }
            int[] k = level < 4 ? a : b;
            int shift = (3 - level % 4) * 8;
            int i2 = length;
            while (i2-- != 0) {
                digit2[i2] = (byte)(k[perm[first2 + i2]] >>> shift & 0xFF ^ signMask);
            }
            i2 = length;
            while (i2-- != 0) {
                int n2 = digit2[i2] & 0xFF;
                count2[n2] = count2[n2] + 1;
            }
            int lastUsed = -1;
            int p = 0;
            for (i = 0; i < 256; ++i) {
                if (count2[i] != 0) {
                    lastUsed = i;
                    if (level < 7 && count2[i] > 1) {
                        offsetStack[offsetPos++] = p + first2;
                        lengthStack[lengthPos++] = count2[i];
                        levelStack[levelPos++] = level + 1;
                    }
                }
                if (stable) {
                    count2[i] = p += count2[i];
                    continue;
                }
                pos[i] = p += count2[i];
            }
            if (stable) {
                i = length;
                while (i-- != 0) {
                    int n3 = digit2[i] & 0xFF;
                    int n4 = count2[n3] - 1;
                    count2[n3] = n4;
                    support[n4] = perm[first2 + i];
                }
                System.arraycopy(support, 0, perm, first2, length);
                IntArrays.fill(count2, 0);
                continue;
            }
            int end = length - count2[lastUsed];
            count2[lastUsed] = 0;
            int c = -1;
            for (int i3 = 0; i3 < end; i3 += count2[c]) {
                int t = perm[i3 + first2];
                c = digit2[i3] & 0xFF;
                while (true) {
                    int n5 = c;
                    int n6 = pos[n5] - 1;
                    pos[n5] = n6;
                    int d = n6;
                    if (n6 <= i3) break;
                    int z2 = t;
                    int zz = c;
                    t = perm[d + first2];
                    c = digit2[d] & 0xFF;
                    perm[d + first2] = z2;
                    digit2[d] = (byte)zz;
                }
                perm[i3 + first2] = t;
                count2[c] = 0;
            }
        }
    }

    private static void selectionSort(int[][] a, int from2, int to2, int level) {
        int layers = a.length;
        int firstLayer = level / 4;
        for (int i = from2; i < to2 - 1; ++i) {
            int m = i;
            block1: for (int j = i + 1; j < to2; ++j) {
                for (int p = firstLayer; p < layers; ++p) {
                    if (a[p][j] < a[p][m]) {
                        m = j;
                        continue block1;
                    }
                    if (a[p][j] > a[p][m]) continue block1;
                }
            }
            if (m == i) continue;
            int p = layers;
            while (p-- != 0) {
                int u = a[p][i];
                a[p][i] = a[p][m];
                a[p][m] = u;
            }
        }
    }

    public static void radixSort(int[][] a) {
        IntArrays.radixSort(a, 0, a[0].length);
    }

    public static void radixSort(int[][] a, int from2, int to2) {
        int layers = a.length;
        int maxLevel = 4 * layers - 1;
        int p = layers;
        int l = a[0].length;
        while (p-- != 0) {
            if (a[p].length == l) continue;
            throw new IllegalArgumentException("The array of index " + p + " has not the same length of the array of index 0.");
        }
        int stackSize = 255 * (layers * 4 - 1) + 1;
        int[] offsetStack = new int[stackSize];
        int offsetPos = 0;
        int[] lengthStack = new int[stackSize];
        int lengthPos = 0;
        int[] levelStack = new int[stackSize];
        int levelPos = 0;
        offsetStack[offsetPos++] = from2;
        lengthStack[lengthPos++] = to2 - from2;
        levelStack[levelPos++] = 0;
        int[] count2 = new int[256];
        int[] pos = new int[256];
        byte[] digit2 = new byte[to2 - from2];
        int[] t = new int[layers];
        while (offsetPos > 0) {
            int level;
            int signMask;
            int first2 = offsetStack[--offsetPos];
            int length = lengthStack[--lengthPos];
            int n = signMask = (level = levelStack[--levelPos]) % 4 == 0 ? 128 : 0;
            if (length < 50) {
                IntArrays.selectionSort(a, first2, first2 + length, level);
                continue;
            }
            int[] k = a[level / 4];
            int shift = (3 - level % 4) * 8;
            int i = length;
            while (i-- != 0) {
                digit2[i] = (byte)(k[first2 + i] >>> shift & 0xFF ^ signMask);
            }
            i = length;
            while (i-- != 0) {
                int n2 = digit2[i] & 0xFF;
                count2[n2] = count2[n2] + 1;
            }
            int lastUsed = -1;
            int p2 = 0;
            for (int i2 = 0; i2 < 256; ++i2) {
                if (count2[i2] != 0) {
                    lastUsed = i2;
                    if (level < maxLevel && count2[i2] > 1) {
                        offsetStack[offsetPos++] = p2 + first2;
                        lengthStack[lengthPos++] = count2[i2];
                        levelStack[levelPos++] = level + 1;
                    }
                }
                pos[i2] = p2 += count2[i2];
            }
            int end = length - count2[lastUsed];
            count2[lastUsed] = 0;
            int c = -1;
            for (int i3 = 0; i3 < end; i3 += count2[c]) {
                int p3 = layers;
                while (p3-- != 0) {
                    t[p3] = a[p3][i3 + first2];
                }
                c = digit2[i3] & 0xFF;
                while (true) {
                    int n3 = c;
                    int n4 = pos[n3] - 1;
                    pos[n3] = n4;
                    int d = n4;
                    if (n4 <= i3) break;
                    p3 = layers;
                    while (p3-- != 0) {
                        int u = t[p3];
                        t[p3] = a[p3][d + first2];
                        a[p3][d + first2] = u;
                    }
                    int zz = c;
                    c = digit2[d] & 0xFF;
                    digit2[d] = (byte)zz;
                }
                p3 = layers;
                while (p3-- != 0) {
                    a[p3][i3 + first2] = t[p3];
                }
                count2[c] = 0;
            }
        }
    }

    public static int[] shuffle(int[] a, int from2, int to2, Random random) {
        int i = to2 - from2;
        while (i-- != 0) {
            int p = random.nextInt(i + 1);
            int t = a[from2 + i];
            a[from2 + i] = a[from2 + p];
            a[from2 + p] = t;
        }
        return a;
    }

    public static int[] shuffle(int[] a, Random random) {
        int i = a.length;
        while (i-- != 0) {
            int p = random.nextInt(i + 1);
            int t = a[i];
            a[i] = a[p];
            a[p] = t;
        }
        return a;
    }

    public static int[] reverse(int[] a) {
        int length = a.length;
        int i = length / 2;
        while (i-- != 0) {
            int t = a[length - i - 1];
            a[length - i - 1] = a[i];
            a[i] = t;
        }
        return a;
    }

    private static final class ArrayHashStrategy
    implements Hash.Strategy<int[]>,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;

        private ArrayHashStrategy() {
        }

        @Override
        public int hashCode(int[] o) {
            return java.util.Arrays.hashCode(o);
        }

        @Override
        public boolean equals(int[] a, int[] b) {
            return java.util.Arrays.equals(a, b);
        }
    }
}

