/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.it.unimi.dsi.fastutil.doubles;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.apache.parquet.it.unimi.dsi.fastutil.HashCommon;
import org.apache.parquet.it.unimi.dsi.fastutil.doubles.AbstractDoubleCollection;
import org.apache.parquet.it.unimi.dsi.fastutil.doubles.AbstractDoubleListIterator;
import org.apache.parquet.it.unimi.dsi.fastutil.doubles.DoubleCollection;
import org.apache.parquet.it.unimi.dsi.fastutil.doubles.DoubleList;
import org.apache.parquet.it.unimi.dsi.fastutil.doubles.DoubleListIterator;
import org.apache.parquet.it.unimi.dsi.fastutil.doubles.DoubleStack;

public abstract class AbstractDoubleList
extends AbstractDoubleCollection
implements DoubleList,
DoubleStack {
    protected AbstractDoubleList() {
    }

    protected void ensureIndex(int index2) {
        if (index2 < 0) {
            throw new IndexOutOfBoundsException("Index (" + index2 + ") is negative");
        }
        if (index2 > this.size()) {
            throw new IndexOutOfBoundsException("Index (" + index2 + ") is greater than list size (" + this.size() + ")");
        }
    }

    protected void ensureRestrictedIndex(int index2) {
        if (index2 < 0) {
            throw new IndexOutOfBoundsException("Index (" + index2 + ") is negative");
        }
        if (index2 >= this.size()) {
            throw new IndexOutOfBoundsException("Index (" + index2 + ") is greater than or equal to list size (" + this.size() + ")");
        }
    }

    @Override
    public void add(int index2, double k) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(double k) {
        this.add(this.size(), k);
        return true;
    }

    @Override
    public double removeDouble(int i) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double set(int index2, double k) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index2, Collection<? extends Double> c) {
        this.ensureIndex(index2);
        int n = c.size();
        if (n == 0) {
            return false;
        }
        Iterator<? extends Double> i = c.iterator();
        while (n-- != 0) {
            this.add(index2++, i.next());
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends Double> c) {
        return this.addAll(this.size(), c);
    }

    @Override
    @Deprecated
    public DoubleListIterator doubleListIterator() {
        return this.listIterator();
    }

    @Override
    @Deprecated
    public DoubleListIterator doubleListIterator(int index2) {
        return this.listIterator(index2);
    }

    @Override
    public DoubleListIterator iterator() {
        return this.listIterator();
    }

    @Override
    public DoubleListIterator listIterator() {
        return this.listIterator(0);
    }

    @Override
    public DoubleListIterator listIterator(final int index2) {
        return new AbstractDoubleListIterator(){
            int pos;
            int last;
            {
                this.pos = index2;
                this.last = -1;
            }

            @Override
            public boolean hasNext() {
                return this.pos < AbstractDoubleList.this.size();
            }

            @Override
            public boolean hasPrevious() {
                return this.pos > 0;
            }

            @Override
            public double nextDouble() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.last = this.pos++;
                return AbstractDoubleList.this.getDouble(this.last);
            }

            @Override
            public double previousDouble() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                this.last = --this.pos;
                return AbstractDoubleList.this.getDouble(this.pos);
            }

            @Override
            public int nextIndex() {
                return this.pos;
            }

            @Override
            public int previousIndex() {
                return this.pos - 1;
            }

            @Override
            public void add(double k) {
                if (this.last == -1) {
                    throw new IllegalStateException();
                }
                AbstractDoubleList.this.add(this.pos++, k);
                this.last = -1;
            }

            @Override
            public void set(double k) {
                if (this.last == -1) {
                    throw new IllegalStateException();
                }
                AbstractDoubleList.this.set(this.last, k);
            }

            @Override
            public void remove() {
                if (this.last == -1) {
                    throw new IllegalStateException();
                }
                AbstractDoubleList.this.removeDouble(this.last);
                if (this.last < this.pos) {
                    --this.pos;
                }
                this.last = -1;
            }
        };
    }

    @Override
    public boolean contains(double k) {
        return this.indexOf(k) >= 0;
    }

    @Override
    public int indexOf(double k) {
        DoubleListIterator i = this.listIterator();
        while (i.hasNext()) {
            double e = i.nextDouble();
            if (k != e) continue;
            return i.previousIndex();
        }
        return -1;
    }

    @Override
    public int lastIndexOf(double k) {
        DoubleListIterator i = this.listIterator(this.size());
        while (i.hasPrevious()) {
            double e = i.previousDouble();
            if (k != e) continue;
            return i.nextIndex();
        }
        return -1;
    }

    @Override
    public void size(int size2) {
        int i = this.size();
        if (size2 > i) {
            while (i++ < size2) {
                this.add(0.0);
            }
        } else {
            while (i-- != size2) {
                this.remove(i);
            }
        }
    }

    @Override
    public DoubleList subList(int from2, int to2) {
        this.ensureIndex(from2);
        this.ensureIndex(to2);
        if (from2 > to2) {
            throw new IndexOutOfBoundsException("Start index (" + from2 + ") is greater than end index (" + to2 + ")");
        }
        return new DoubleSubList(this, from2, to2);
    }

    @Override
    @Deprecated
    public DoubleList doubleSubList(int from2, int to2) {
        return this.subList(from2, to2);
    }

    @Override
    public void removeElements(int from2, int to2) {
        this.ensureIndex(to2);
        DoubleListIterator i = this.listIterator(from2);
        int n = to2 - from2;
        if (n < 0) {
            throw new IllegalArgumentException("Start index (" + from2 + ") is greater than end index (" + to2 + ")");
        }
        while (n-- != 0) {
            i.nextDouble();
            i.remove();
        }
    }

    @Override
    public void addElements(int index2, double[] a, int offset, int length) {
        this.ensureIndex(index2);
        if (offset < 0) {
            throw new ArrayIndexOutOfBoundsException("Offset (" + offset + ") is negative");
        }
        if (offset + length > a.length) {
            throw new ArrayIndexOutOfBoundsException("End index (" + (offset + length) + ") is greater than array length (" + a.length + ")");
        }
        while (length-- != 0) {
            this.add(index2++, a[offset++]);
        }
    }

    @Override
    public void addElements(int index2, double[] a) {
        this.addElements(index2, a, 0, a.length);
    }

    @Override
    public void getElements(int from2, double[] a, int offset, int length) {
        DoubleListIterator i = this.listIterator(from2);
        if (offset < 0) {
            throw new ArrayIndexOutOfBoundsException("Offset (" + offset + ") is negative");
        }
        if (offset + length > a.length) {
            throw new ArrayIndexOutOfBoundsException("End index (" + (offset + length) + ") is greater than array length (" + a.length + ")");
        }
        if (from2 + length > this.size()) {
            throw new IndexOutOfBoundsException("End index (" + (from2 + length) + ") is greater than list size (" + this.size() + ")");
        }
        while (length-- != 0) {
            a[offset++] = i.nextDouble();
        }
    }

    private boolean valEquals(Object a, Object b) {
        return a == null ? b == null : a.equals(b);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof List)) {
            return false;
        }
        List l = (List)o;
        int s2 = this.size();
        if (s2 != l.size()) {
            return false;
        }
        if (l instanceof DoubleList) {
            DoubleListIterator i1 = this.listIterator();
            DoubleListIterator i2 = ((DoubleList)l).listIterator();
            while (s2-- != 0) {
                if (i1.nextDouble() == i2.nextDouble()) continue;
                return false;
            }
            return true;
        }
        DoubleListIterator i1 = this.listIterator();
        ListIterator i2 = l.listIterator();
        while (s2-- != 0) {
            if (this.valEquals(i1.next(), i2.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(List<? extends Double> l) {
        if (l == this) {
            return 0;
        }
        if (l instanceof DoubleList) {
            DoubleListIterator i1 = this.listIterator();
            DoubleListIterator i2 = ((DoubleList)l).listIterator();
            while (i1.hasNext() && i2.hasNext()) {
                double e2;
                double e1 = i1.nextDouble();
                int r = Double.compare(e1, e2 = i2.nextDouble());
                if (r == 0) continue;
                return r;
            }
            return i2.hasNext() ? -1 : (i1.hasNext() ? 1 : 0);
        }
        DoubleListIterator i1 = this.listIterator();
        ListIterator<? extends Double> i2 = l.listIterator();
        while (i1.hasNext() && i2.hasNext()) {
            int r = ((Comparable)i1.next()).compareTo(i2.next());
            if (r == 0) continue;
            return r;
        }
        return i2.hasNext() ? -1 : (i1.hasNext() ? 1 : 0);
    }

    @Override
    public int hashCode() {
        DoubleListIterator i = this.iterator();
        int h = 1;
        int s2 = this.size();
        while (s2-- != 0) {
            double k = i.nextDouble();
            h = 31 * h + HashCommon.double2int(k);
        }
        return h;
    }

    @Override
    public void push(double o) {
        this.add(o);
    }

    @Override
    public double popDouble() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.removeDouble(this.size() - 1);
    }

    @Override
    public double topDouble() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.getDouble(this.size() - 1);
    }

    @Override
    public double peekDouble(int i) {
        return this.getDouble(this.size() - 1 - i);
    }

    @Override
    public boolean rem(double k) {
        int index2 = this.indexOf(k);
        if (index2 == -1) {
            return false;
        }
        this.removeDouble(index2);
        return true;
    }

    @Override
    public boolean remove(Object o) {
        return this.rem((Double)o);
    }

    @Override
    public boolean addAll(int index2, DoubleCollection c) {
        return this.addAll(index2, (Collection<? extends Double>)c);
    }

    @Override
    public boolean addAll(int index2, DoubleList l) {
        return this.addAll(index2, (DoubleCollection)l);
    }

    @Override
    public boolean addAll(DoubleCollection c) {
        return this.addAll(this.size(), c);
    }

    @Override
    public boolean addAll(DoubleList l) {
        return this.addAll(this.size(), l);
    }

    @Override
    public void add(int index2, Double ok) {
        this.add(index2, (double)ok);
    }

    @Override
    public Double set(int index2, Double ok) {
        return this.set(index2, (double)ok);
    }

    @Override
    public Double get(int index2) {
        return this.getDouble(index2);
    }

    @Override
    public int indexOf(Object ok) {
        return this.indexOf((Double)ok);
    }

    @Override
    public int lastIndexOf(Object ok) {
        return this.lastIndexOf((Double)ok);
    }

    @Override
    public Double remove(int index2) {
        return this.removeDouble(index2);
    }

    @Override
    public void push(Double o) {
        this.push((double)o);
    }

    @Override
    public Double pop() {
        return this.popDouble();
    }

    @Override
    public Double top() {
        return this.topDouble();
    }

    @Override
    public Double peek(int i) {
        return this.peekDouble(i);
    }

    @Override
    public String toString() {
        StringBuilder s2 = new StringBuilder();
        DoubleListIterator i = this.iterator();
        int n = this.size();
        boolean first2 = true;
        s2.append("[");
        while (n-- != 0) {
            if (first2) {
                first2 = false;
            } else {
                s2.append(", ");
            }
            double k = i.nextDouble();
            s2.append(String.valueOf(k));
        }
        s2.append("]");
        return s2.toString();
    }

    public static class DoubleSubList
    extends AbstractDoubleList
    implements Serializable {
        private static final long serialVersionUID = -7046029254386353129L;
        protected final DoubleList l;
        protected final int from;
        protected int to;
        private static final boolean ASSERTS = false;

        public DoubleSubList(DoubleList l, int from2, int to2) {
            this.l = l;
            this.from = from2;
            this.to = to2;
        }

        private void assertRange() {
        }

        @Override
        public boolean add(double k) {
            this.l.add(this.to, k);
            ++this.to;
            return true;
        }

        @Override
        public void add(int index2, double k) {
            this.ensureIndex(index2);
            this.l.add(this.from + index2, k);
            ++this.to;
        }

        @Override
        public boolean addAll(int index2, Collection<? extends Double> c) {
            this.ensureIndex(index2);
            this.to += c.size();
            return this.l.addAll(this.from + index2, c);
        }

        @Override
        public double getDouble(int index2) {
            this.ensureRestrictedIndex(index2);
            return this.l.getDouble(this.from + index2);
        }

        @Override
        public double removeDouble(int index2) {
            this.ensureRestrictedIndex(index2);
            --this.to;
            return this.l.removeDouble(this.from + index2);
        }

        @Override
        public double set(int index2, double k) {
            this.ensureRestrictedIndex(index2);
            return this.l.set(this.from + index2, k);
        }

        @Override
        public void clear() {
            this.removeElements(0, this.size());
        }

        @Override
        public int size() {
            return this.to - this.from;
        }

        @Override
        public void getElements(int from2, double[] a, int offset, int length) {
            this.ensureIndex(from2);
            if (from2 + length > this.size()) {
                throw new IndexOutOfBoundsException("End index (" + from2 + length + ") is greater than list size (" + this.size() + ")");
            }
            this.l.getElements(this.from + from2, a, offset, length);
        }

        @Override
        public void removeElements(int from2, int to2) {
            this.ensureIndex(from2);
            this.ensureIndex(to2);
            this.l.removeElements(this.from + from2, this.from + to2);
            this.to -= to2 - from2;
        }

        @Override
        public void addElements(int index2, double[] a, int offset, int length) {
            this.ensureIndex(index2);
            this.l.addElements(this.from + index2, a, offset, length);
            this.to += length;
        }

        @Override
        public DoubleListIterator listIterator(final int index2) {
            this.ensureIndex(index2);
            return new AbstractDoubleListIterator(){
                int pos;
                int last;
                {
                    this.pos = index2;
                    this.last = -1;
                }

                @Override
                public boolean hasNext() {
                    return this.pos < DoubleSubList.this.size();
                }

                @Override
                public boolean hasPrevious() {
                    return this.pos > 0;
                }

                @Override
                public double nextDouble() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    this.last = this.pos++;
                    return DoubleSubList.this.l.getDouble(DoubleSubList.this.from + this.last);
                }

                @Override
                public double previousDouble() {
                    if (!this.hasPrevious()) {
                        throw new NoSuchElementException();
                    }
                    this.last = --this.pos;
                    return DoubleSubList.this.l.getDouble(DoubleSubList.this.from + this.pos);
                }

                @Override
                public int nextIndex() {
                    return this.pos;
                }

                @Override
                public int previousIndex() {
                    return this.pos - 1;
                }

                @Override
                public void add(double k) {
                    if (this.last == -1) {
                        throw new IllegalStateException();
                    }
                    DoubleSubList.this.add(this.pos++, k);
                    this.last = -1;
                }

                @Override
                public void set(double k) {
                    if (this.last == -1) {
                        throw new IllegalStateException();
                    }
                    DoubleSubList.this.set(this.last, k);
                }

                @Override
                public void remove() {
                    if (this.last == -1) {
                        throw new IllegalStateException();
                    }
                    DoubleSubList.this.removeDouble(this.last);
                    if (this.last < this.pos) {
                        --this.pos;
                    }
                    this.last = -1;
                }
            };
        }

        @Override
        public DoubleList subList(int from2, int to2) {
            this.ensureIndex(from2);
            this.ensureIndex(to2);
            if (from2 > to2) {
                throw new IllegalArgumentException("Start index (" + from2 + ") is greater than end index (" + to2 + ")");
            }
            return new DoubleSubList(this, from2, to2);
        }

        @Override
        public boolean rem(double k) {
            int index2 = this.indexOf(k);
            if (index2 == -1) {
                return false;
            }
            --this.to;
            this.l.removeDouble(this.from + index2);
            return true;
        }

        @Override
        public boolean remove(Object o) {
            return this.rem((Double)o);
        }

        @Override
        public boolean addAll(int index2, DoubleCollection c) {
            this.ensureIndex(index2);
            this.to += c.size();
            return this.l.addAll(this.from + index2, c);
        }

        @Override
        public boolean addAll(int index2, DoubleList l) {
            this.ensureIndex(index2);
            this.to += l.size();
            return this.l.addAll(this.from + index2, l);
        }
    }
}

