/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.it.unimi.dsi.fastutil.booleans;

import java.io.Serializable;
import java.util.Random;
import org.apache.parquet.it.unimi.dsi.fastutil.Arrays;
import org.apache.parquet.it.unimi.dsi.fastutil.Hash;
import org.apache.parquet.it.unimi.dsi.fastutil.booleans.BooleanComparator;

public class BooleanArrays {
    public static final boolean[] EMPTY_ARRAY = new boolean[0];
    private static final int SMALL = 7;
    private static final int MEDIUM = 50;
    public static final Hash.Strategy<boolean[]> HASH_STRATEGY = new ArrayHashStrategy();

    private BooleanArrays() {
    }

    public static boolean[] ensureCapacity(boolean[] array2, int length) {
        if (length > array2.length) {
            boolean[] t = new boolean[length];
            System.arraycopy(array2, 0, t, 0, array2.length);
            return t;
        }
        return array2;
    }

    public static boolean[] ensureCapacity(boolean[] array2, int length, int preserve) {
        if (length > array2.length) {
            boolean[] t = new boolean[length];
            System.arraycopy(array2, 0, t, 0, preserve);
            return t;
        }
        return array2;
    }

    public static boolean[] grow(boolean[] array2, int length) {
        if (length > array2.length) {
            int newLength = (int)Math.min(Math.max(2L * (long)array2.length, (long)length), 0x7FFFFFF7L);
            boolean[] t = new boolean[newLength];
            System.arraycopy(array2, 0, t, 0, array2.length);
            return t;
        }
        return array2;
    }

    public static boolean[] grow(boolean[] array2, int length, int preserve) {
        if (length > array2.length) {
            int newLength = (int)Math.min(Math.max(2L * (long)array2.length, (long)length), 0x7FFFFFF7L);
            boolean[] t = new boolean[newLength];
            System.arraycopy(array2, 0, t, 0, preserve);
            return t;
        }
        return array2;
    }

    public static boolean[] trim(boolean[] array2, int length) {
        if (length >= array2.length) {
            return array2;
        }
        boolean[] t = length == 0 ? EMPTY_ARRAY : new boolean[length];
        System.arraycopy(array2, 0, t, 0, length);
        return t;
    }

    public static boolean[] setLength(boolean[] array2, int length) {
        if (length == array2.length) {
            return array2;
        }
        if (length < array2.length) {
            return BooleanArrays.trim(array2, length);
        }
        return BooleanArrays.ensureCapacity(array2, length);
    }

    public static boolean[] copy(boolean[] array2, int offset, int length) {
        BooleanArrays.ensureOffsetLength(array2, offset, length);
        boolean[] a = length == 0 ? EMPTY_ARRAY : new boolean[length];
        System.arraycopy(array2, offset, a, 0, length);
        return a;
    }

    public static boolean[] copy(boolean[] array2) {
        return (boolean[])array2.clone();
    }

    public static void fill(boolean[] array2, boolean value2) {
        int i = array2.length;
        while (i-- != 0) {
            array2[i] = value2;
        }
    }

    public static void fill(boolean[] array2, int from2, int to2, boolean value2) {
        BooleanArrays.ensureFromTo(array2, from2, to2);
        if (from2 == 0) {
            while (to2-- != 0) {
                array2[to2] = value2;
            }
        } else {
            for (int i = from2; i < to2; ++i) {
                array2[i] = value2;
            }
        }
    }

    @Deprecated
    public static boolean equals(boolean[] a1, boolean[] a2) {
        int i = a1.length;
        if (i != a2.length) {
            return false;
        }
        while (i-- != 0) {
            if (a1[i] == a2[i]) continue;
            return false;
        }
        return true;
    }

    public static void ensureFromTo(boolean[] a, int from2, int to2) {
        Arrays.ensureFromTo(a.length, from2, to2);
    }

    public static void ensureOffsetLength(boolean[] a, int offset, int length) {
        Arrays.ensureOffsetLength(a.length, offset, length);
    }

    private static void swap(boolean[] x, int a, int b) {
        boolean t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    private static void vecSwap(boolean[] x, int a, int b, int n) {
        int i = 0;
        while (i < n) {
            BooleanArrays.swap(x, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    private static int med3(boolean[] x, int a, int b, int c, BooleanComparator comp) {
        int ab = comp.compare(x[a], x[b]);
        int ac = comp.compare(x[a], x[c]);
        int bc = comp.compare(x[b], x[c]);
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c : a)) : (bc > 0 ? b : (ac > 0 ? c : a));
    }

    private static void selectionSort(boolean[] a, int from2, int to2, BooleanComparator comp) {
        for (int i = from2; i < to2 - 1; ++i) {
            int m = i;
            for (int j = i + 1; j < to2; ++j) {
                if (comp.compare(a[j], a[m]) >= 0) continue;
                m = j;
            }
            if (m == i) continue;
            boolean u = a[i];
            a[i] = a[m];
            a[m] = u;
        }
    }

    private static void insertionSort(boolean[] a, int from2, int to2, BooleanComparator comp) {
        int i = from2;
        while (++i < to2) {
            boolean t = a[i];
            int j = i;
            boolean u = a[j - 1];
            while (comp.compare(t, u) < 0) {
                a[j] = u;
                if (from2 == j - 1) {
                    --j;
                    break;
                }
                u = a[--j - 1];
            }
            a[j] = t;
        }
    }

    private static void selectionSort(boolean[] a, int from2, int to2) {
        for (int i = from2; i < to2 - 1; ++i) {
            int m = i;
            for (int j = i + 1; j < to2; ++j) {
                if (a[j] || !a[m]) continue;
                m = j;
            }
            if (m == i) continue;
            boolean u = a[i];
            a[i] = a[m];
            a[m] = u;
        }
    }

    private static void insertionSort(boolean[] a, int from2, int to2) {
        int i = from2;
        while (++i < to2) {
            boolean t = a[i];
            int j = i;
            boolean u = a[j - 1];
            while (!t && u) {
                a[j] = u;
                if (from2 == j - 1) {
                    --j;
                    break;
                }
                u = a[--j - 1];
            }
            a[j] = t;
        }
    }

    public static void quickSort(boolean[] x, int from2, int to2, BooleanComparator comp) {
        int c;
        int a;
        int len = to2 - from2;
        if (len < 7) {
            BooleanArrays.selectionSort(x, from2, to2, comp);
            return;
        }
        int m = from2 + len / 2;
        if (len > 7) {
            int l = from2;
            int n = to2 - 1;
            if (len > 50) {
                int s2 = len / 8;
                l = BooleanArrays.med3(x, l, l + s2, l + 2 * s2, comp);
                m = BooleanArrays.med3(x, m - s2, m, m + s2, comp);
                n = BooleanArrays.med3(x, n - 2 * s2, n - s2, n, comp);
            }
            m = BooleanArrays.med3(x, l, m, n, comp);
        }
        boolean v = x[m];
        int b = a = from2;
        int d = c = to2 - 1;
        while (true) {
            int comparison;
            if (b <= c && (comparison = comp.compare(x[b], v)) <= 0) {
                if (comparison == 0) {
                    BooleanArrays.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (comparison = comp.compare(x[c], v)) >= 0) {
                if (comparison == 0) {
                    BooleanArrays.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            BooleanArrays.swap(x, b++, c--);
        }
        int n = to2;
        int s3 = Math.min(a - from2, b - a);
        BooleanArrays.vecSwap(x, from2, b - s3, s3);
        s3 = Math.min(d - c, n - d - 1);
        BooleanArrays.vecSwap(x, b, n - s3, s3);
        s3 = b - a;
        if (s3 > 1) {
            BooleanArrays.quickSort(x, from2, from2 + s3, comp);
        }
        if ((s3 = d - c) > 1) {
            BooleanArrays.quickSort(x, n - s3, n, comp);
        }
    }

    public static void quickSort(boolean[] x, BooleanComparator comp) {
        BooleanArrays.quickSort(x, 0, x.length, comp);
    }

    private static int med3(boolean[] x, int a, int b, int c) {
        int bc;
        int ac;
        int ab;
        int n = !x[a] && x[b] ? -1 : (ab = x[a] == x[b] ? 0 : 1);
        int n2 = !x[a] && x[c] ? -1 : (ac = x[a] == x[c] ? 0 : 1);
        int n3 = !x[b] && x[c] ? -1 : (bc = x[b] == x[c] ? 0 : 1);
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c : a)) : (bc > 0 ? b : (ac > 0 ? c : a));
    }

    @Deprecated
    public static void quickSort(boolean[] x, int from2, int to2) {
        int c;
        int a;
        int len = to2 - from2;
        if (len < 7) {
            BooleanArrays.selectionSort(x, from2, to2);
            return;
        }
        int m = from2 + len / 2;
        if (len > 7) {
            int l = from2;
            int n = to2 - 1;
            if (len > 50) {
                int s2 = len / 8;
                l = BooleanArrays.med3(x, l, l + s2, l + 2 * s2);
                m = BooleanArrays.med3(x, m - s2, m, m + s2);
                n = BooleanArrays.med3(x, n - 2 * s2, n - s2, n);
            }
            m = BooleanArrays.med3(x, l, m, n);
        }
        boolean v = x[m];
        int b = a = from2;
        int d = c = to2 - 1;
        while (true) {
            int comparison;
            if (b <= c && (!x[b] && v ? -1 : (comparison = x[b] == v ? 0 : 1)) <= 0) {
                if (comparison == 0) {
                    BooleanArrays.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (!x[c] && v ? -1 : (comparison = x[c] == v ? 0 : 1)) >= 0) {
                if (comparison == 0) {
                    BooleanArrays.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            BooleanArrays.swap(x, b++, c--);
        }
        int n = to2;
        int s3 = Math.min(a - from2, b - a);
        BooleanArrays.vecSwap(x, from2, b - s3, s3);
        s3 = Math.min(d - c, n - d - 1);
        BooleanArrays.vecSwap(x, b, n - s3, s3);
        s3 = b - a;
        if (s3 > 1) {
            BooleanArrays.quickSort(x, from2, from2 + s3);
        }
        if ((s3 = d - c) > 1) {
            BooleanArrays.quickSort(x, n - s3, n);
        }
    }

    @Deprecated
    public static void quickSort(boolean[] x) {
        BooleanArrays.quickSort(x, 0, x.length);
    }

    public static void mergeSort(boolean[] a, int from2, int to2, boolean[] supp) {
        int len = to2 - from2;
        if (len < 7) {
            BooleanArrays.insertionSort(a, from2, to2);
            return;
        }
        int mid = from2 + to2 >>> 1;
        BooleanArrays.mergeSort(supp, from2, mid, a);
        BooleanArrays.mergeSort(supp, mid, to2, a);
        if (!supp[mid - 1] || supp[mid]) {
            System.arraycopy(supp, from2, a, from2, len);
            return;
        }
        int p = from2;
        int q = mid;
        for (int i = from2; i < to2; ++i) {
            a[i] = q >= to2 || p < mid && (!supp[p] || supp[q]) ? supp[p++] : supp[q++];
        }
    }

    public static void mergeSort(boolean[] a, int from2, int to2) {
        BooleanArrays.mergeSort(a, from2, to2, (boolean[])a.clone());
    }

    public static void mergeSort(boolean[] a) {
        BooleanArrays.mergeSort(a, 0, a.length);
    }

    public static void mergeSort(boolean[] a, int from2, int to2, BooleanComparator comp, boolean[] supp) {
        int len = to2 - from2;
        if (len < 7) {
            BooleanArrays.insertionSort(a, from2, to2, comp);
            return;
        }
        int mid = from2 + to2 >>> 1;
        BooleanArrays.mergeSort(supp, from2, mid, comp, a);
        BooleanArrays.mergeSort(supp, mid, to2, comp, a);
        if (comp.compare(supp[mid - 1], supp[mid]) <= 0) {
            System.arraycopy(supp, from2, a, from2, len);
            return;
        }
        int p = from2;
        int q = mid;
        for (int i = from2; i < to2; ++i) {
            a[i] = q >= to2 || p < mid && comp.compare(supp[p], supp[q]) <= 0 ? supp[p++] : supp[q++];
        }
    }

    public static void mergeSort(boolean[] a, int from2, int to2, BooleanComparator comp) {
        BooleanArrays.mergeSort(a, from2, to2, comp, (boolean[])a.clone());
    }

    public static void mergeSort(boolean[] a, BooleanComparator comp) {
        BooleanArrays.mergeSort(a, 0, a.length, comp);
    }

    public static boolean[] shuffle(boolean[] a, int from2, int to2, Random random) {
        int i = to2 - from2;
        while (i-- != 0) {
            int p = random.nextInt(i + 1);
            boolean t = a[from2 + i];
            a[from2 + i] = a[from2 + p];
            a[from2 + p] = t;
        }
        return a;
    }

    public static boolean[] shuffle(boolean[] a, Random random) {
        int i = a.length;
        while (i-- != 0) {
            int p = random.nextInt(i + 1);
            boolean t = a[i];
            a[i] = a[p];
            a[p] = t;
        }
        return a;
    }

    public static boolean[] reverse(boolean[] a) {
        int length = a.length;
        int i = length / 2;
        while (i-- != 0) {
            boolean t = a[length - i - 1];
            a[length - i - 1] = a[i];
            a[i] = t;
        }
        return a;
    }

    private static final class ArrayHashStrategy
    implements Hash.Strategy<boolean[]>,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;

        private ArrayHashStrategy() {
        }

        @Override
        public int hashCode(boolean[] o) {
            return java.util.Arrays.hashCode(o);
        }

        @Override
        public boolean equals(boolean[] a, boolean[] b) {
            return java.util.Arrays.equals(a, b);
        }
    }
}

