/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.io;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import org.apache.parquet.Log;
import org.apache.parquet.io.InvalidRecordException;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.RecordConsumer;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;

public class ValidatingRecordConsumer
extends RecordConsumer {
    private static final Log LOG = Log.getLog(ValidatingRecordConsumer.class);
    private static final boolean DEBUG = Log.DEBUG;
    private final RecordConsumer delegate;
    private Deque<Type> types = new ArrayDeque<Type>();
    private Deque<Integer> fields = new ArrayDeque<Integer>();
    private Deque<Integer> previousField = new ArrayDeque<Integer>();
    private Deque<Integer> fieldValueCount = new ArrayDeque<Integer>();

    public ValidatingRecordConsumer(RecordConsumer delegate, MessageType schema) {
        this.delegate = delegate;
        this.types.push(schema);
    }

    @Override
    public void startMessage() {
        this.previousField.push(-1);
        this.delegate.startMessage();
    }

    @Override
    public void endMessage() {
        this.delegate.endMessage();
        this.validateMissingFields(this.types.peek().asGroupType().getFieldCount());
        this.previousField.pop();
    }

    @Override
    public void startField(String field2, int index2) {
        if (index2 <= this.previousField.peek()) {
            throw new InvalidRecordException("fields must be added in order " + field2 + " index " + index2 + " is before previous field " + this.previousField.peek());
        }
        this.validateMissingFields(index2);
        this.fields.push(index2);
        this.fieldValueCount.push(0);
        this.delegate.startField(field2, index2);
    }

    private void validateMissingFields(int index2) {
        for (int i = this.previousField.peek() + 1; i < index2; ++i) {
            Type type = this.types.peek().asGroupType().getType(i);
            if (!type.isRepetition(Type.Repetition.REQUIRED)) continue;
            throw new InvalidRecordException("required field is missing " + type);
        }
    }

    @Override
    public void endField(String field2, int index2) {
        this.delegate.endField(field2, index2);
        this.fieldValueCount.pop();
        this.previousField.push(this.fields.pop());
    }

    @Override
    public void startGroup() {
        this.previousField.push(-1);
        this.types.push(this.types.peek().asGroupType().getType(this.fields.peek()));
        this.delegate.startGroup();
    }

    @Override
    public void endGroup() {
        this.delegate.endGroup();
        this.validateMissingFields(this.types.peek().asGroupType().getFieldCount());
        this.types.pop();
        this.previousField.pop();
    }

    private void validate(PrimitiveType.PrimitiveTypeName p) {
        Type currentType = this.types.peek().asGroupType().getType(this.fields.peek());
        int c = this.fieldValueCount.pop() + 1;
        this.fieldValueCount.push(c);
        if (DEBUG) {
            LOG.debug("validate " + (Object)((Object)p) + " for " + currentType.getName());
        }
        switch (currentType.getRepetition()) {
            case OPTIONAL: 
            case REQUIRED: {
                if (c <= 1) break;
                throw new InvalidRecordException("repeated value when the type is not repeated in " + currentType);
            }
            case REPEATED: {
                break;
            }
            default: {
                throw new InvalidRecordException("unknown repetition " + (Object)((Object)currentType.getRepetition()) + " in " + currentType);
            }
        }
        if (!currentType.isPrimitive() || currentType.asPrimitiveType().getPrimitiveTypeName() != p) {
            throw new InvalidRecordException("expected type " + (Object)((Object)p) + " but got " + currentType);
        }
    }

    private void validate(PrimitiveType.PrimitiveTypeName ... ptypes) {
        Type currentType = this.types.peek().asGroupType().getType(this.fields.peek());
        int c = this.fieldValueCount.pop() + 1;
        this.fieldValueCount.push(c);
        if (DEBUG) {
            LOG.debug("validate " + Arrays.toString((Object[])ptypes) + " for " + currentType.getName());
        }
        switch (currentType.getRepetition()) {
            case OPTIONAL: 
            case REQUIRED: {
                if (c <= 1) break;
                throw new InvalidRecordException("repeated value when the type is not repeated in " + currentType);
            }
            case REPEATED: {
                break;
            }
            default: {
                throw new InvalidRecordException("unknown repetition " + (Object)((Object)currentType.getRepetition()) + " in " + currentType);
            }
        }
        if (!currentType.isPrimitive()) {
            throw new InvalidRecordException("expected type in " + Arrays.toString((Object[])ptypes) + " but got " + currentType);
        }
        for (PrimitiveType.PrimitiveTypeName p : ptypes) {
            if (currentType.asPrimitiveType().getPrimitiveTypeName() != p) continue;
            return;
        }
        throw new InvalidRecordException("expected type in " + Arrays.toString((Object[])ptypes) + " but got " + currentType);
    }

    @Override
    public void addInteger(int value2) {
        this.validate(PrimitiveType.PrimitiveTypeName.INT32);
        this.delegate.addInteger(value2);
    }

    @Override
    public void addLong(long value2) {
        this.validate(PrimitiveType.PrimitiveTypeName.INT64);
        this.delegate.addLong(value2);
    }

    @Override
    public void addBoolean(boolean value2) {
        this.validate(PrimitiveType.PrimitiveTypeName.BOOLEAN);
        this.delegate.addBoolean(value2);
    }

    @Override
    public void addBinary(Binary value2) {
        this.validate(PrimitiveType.PrimitiveTypeName.BINARY, PrimitiveType.PrimitiveTypeName.INT96, PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY);
        this.delegate.addBinary(value2);
    }

    @Override
    public void addFloat(float value2) {
        this.validate(PrimitiveType.PrimitiveTypeName.FLOAT);
        this.delegate.addFloat(value2);
    }

    @Override
    public void addDouble(double value2) {
        this.validate(PrimitiveType.PrimitiveTypeName.DOUBLE);
        this.delegate.addDouble(value2);
    }
}

