/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.io;

import java.util.Arrays;
import org.apache.parquet.Log;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.RecordConsumer;

public class RecordConsumerLoggingWrapper
extends RecordConsumer {
    private static final Log logger = Log.getLog(RecordConsumerLoggingWrapper.class);
    private static final boolean DEBUG = Log.DEBUG;
    private final RecordConsumer delegate;
    int indent = 0;

    public RecordConsumerLoggingWrapper(RecordConsumer delegate) {
        this.delegate = delegate;
    }

    @Override
    public void startField(String field2, int index2) {
        if (DEBUG) {
            this.logOpen(field2);
        }
        this.delegate.startField(field2, index2);
    }

    private void logOpen(String field2) {
        this.log("<" + field2 + ">");
    }

    private String indent() {
        StringBuilder result2 = new StringBuilder();
        for (int i = 0; i < this.indent; ++i) {
            result2.append("  ");
        }
        return result2.toString();
    }

    private void log(Object value2) {
        logger.debug(this.indent() + value2);
    }

    @Override
    public void startGroup() {
        if (DEBUG) {
            ++this.indent;
        }
        if (DEBUG) {
            this.log("<!-- start group -->");
        }
        this.delegate.startGroup();
    }

    @Override
    public void addInteger(int value2) {
        if (DEBUG) {
            this.log(value2);
        }
        this.delegate.addInteger(value2);
    }

    @Override
    public void addLong(long value2) {
        if (DEBUG) {
            this.log(value2);
        }
        this.delegate.addLong(value2);
    }

    @Override
    public void addBoolean(boolean value2) {
        if (DEBUG) {
            this.log(value2);
        }
        this.delegate.addBoolean(value2);
    }

    @Override
    public void addBinary(Binary value2) {
        if (DEBUG) {
            this.log(Arrays.toString(value2.getBytesUnsafe()));
        }
        this.delegate.addBinary(value2);
    }

    @Override
    public void addFloat(float value2) {
        if (DEBUG) {
            this.log(Float.valueOf(value2));
        }
        this.delegate.addFloat(value2);
    }

    @Override
    public void addDouble(double value2) {
        if (DEBUG) {
            this.log(value2);
        }
        this.delegate.addDouble(value2);
    }

    @Override
    public void endGroup() {
        if (DEBUG) {
            this.log("<!-- end group -->");
        }
        if (DEBUG) {
            --this.indent;
        }
        this.delegate.endGroup();
    }

    @Override
    public void endField(String field2, int index2) {
        if (DEBUG) {
            this.logClose(field2);
        }
        this.delegate.endField(field2, index2);
    }

    private void logClose(String field2) {
        this.log("</" + field2 + ">");
    }

    @Override
    public void startMessage() {
        if (DEBUG) {
            this.log("<!-- start message -->");
        }
        this.delegate.startMessage();
    }

    @Override
    public void endMessage() {
        this.delegate.endMessage();
        if (DEBUG) {
            this.log("<!-- end message -->");
        }
    }
}

