/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.io;

import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import org.apache.parquet.Log;
import org.apache.parquet.Preconditions;
import org.apache.parquet.column.ColumnWriteStore;
import org.apache.parquet.column.ColumnWriter;
import org.apache.parquet.column.impl.ColumnReadStoreImpl;
import org.apache.parquet.column.page.PageReadStore;
import org.apache.parquet.filter.UnboundRecordFilter;
import org.apache.parquet.filter2.compat.FilterCompat;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.filter2.recordlevel.FilteringRecordMaterializer;
import org.apache.parquet.filter2.recordlevel.IncrementallyUpdatedFilterPredicate;
import org.apache.parquet.filter2.recordlevel.IncrementallyUpdatedFilterPredicateBuilder;
import org.apache.parquet.io.ColumnIO;
import org.apache.parquet.io.EmptyRecordReader;
import org.apache.parquet.io.FilteredRecordReader;
import org.apache.parquet.io.GroupColumnIO;
import org.apache.parquet.io.InvalidRecordException;
import org.apache.parquet.io.ParquetEncodingException;
import org.apache.parquet.io.PrimitiveColumnIO;
import org.apache.parquet.io.RecordConsumerLoggingWrapper;
import org.apache.parquet.io.RecordReader;
import org.apache.parquet.io.RecordReaderImplementation;
import org.apache.parquet.io.ValidatingRecordConsumer;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.RecordConsumer;
import org.apache.parquet.io.api.RecordMaterializer;
import org.apache.parquet.schema.MessageType;

public class MessageColumnIO
extends GroupColumnIO {
    private static final Log logger = Log.getLog(MessageColumnIO.class);
    private static final boolean DEBUG = Log.DEBUG;
    private List<PrimitiveColumnIO> leaves;
    private final boolean validating;
    private final String createdBy;

    MessageColumnIO(MessageType messageType, boolean validating, String createdBy) {
        super(messageType, null, 0);
        this.validating = validating;
        this.createdBy = createdBy;
    }

    @Override
    public List<String[]> getColumnNames() {
        return super.getColumnNames();
    }

    public <T> RecordReader<T> getRecordReader(PageReadStore columns, RecordMaterializer<T> recordMaterializer) {
        return this.getRecordReader(columns, recordMaterializer, FilterCompat.NOOP);
    }

    @Deprecated
    public <T> RecordReader<T> getRecordReader(PageReadStore columns, RecordMaterializer<T> recordMaterializer, UnboundRecordFilter filter2) {
        return this.getRecordReader(columns, recordMaterializer, FilterCompat.get(filter2));
    }

    public <T> RecordReader<T> getRecordReader(final PageReadStore columns, final RecordMaterializer<T> recordMaterializer, FilterCompat.Filter filter2) {
        Preconditions.checkNotNull(columns, "columns");
        Preconditions.checkNotNull(recordMaterializer, "recordMaterializer");
        Preconditions.checkNotNull(filter2, "filter");
        if (this.leaves.isEmpty()) {
            return new EmptyRecordReader<T>(recordMaterializer);
        }
        return (RecordReader)filter2.accept(new FilterCompat.Visitor<RecordReader<T>>(){

            @Override
            public RecordReader<T> visit(FilterCompat.FilterPredicateCompat filterPredicateCompat) {
                FilterPredicate predicate = filterPredicateCompat.getFilterPredicate();
                IncrementallyUpdatedFilterPredicateBuilder builder = new IncrementallyUpdatedFilterPredicateBuilder();
                IncrementallyUpdatedFilterPredicate streamingPredicate = builder.build(predicate);
                FilteringRecordMaterializer filteringRecordMaterializer = new FilteringRecordMaterializer(recordMaterializer, MessageColumnIO.this.leaves, builder.getValueInspectorsByColumn(), streamingPredicate);
                return new RecordReaderImplementation(MessageColumnIO.this, filteringRecordMaterializer, MessageColumnIO.this.validating, new ColumnReadStoreImpl(columns, ((RecordMaterializer)filteringRecordMaterializer).getRootConverter(), MessageColumnIO.this.getType(), MessageColumnIO.this.createdBy));
            }

            @Override
            public RecordReader<T> visit(FilterCompat.UnboundRecordFilterCompat unboundRecordFilterCompat) {
                return new FilteredRecordReader(MessageColumnIO.this, recordMaterializer, MessageColumnIO.this.validating, new ColumnReadStoreImpl(columns, recordMaterializer.getRootConverter(), MessageColumnIO.this.getType(), MessageColumnIO.this.createdBy), unboundRecordFilterCompat.getUnboundRecordFilter(), columns.getRowCount());
            }

            @Override
            public RecordReader<T> visit(FilterCompat.NoOpFilter noOpFilter) {
                return new RecordReaderImplementation(MessageColumnIO.this, recordMaterializer, MessageColumnIO.this.validating, new ColumnReadStoreImpl(columns, recordMaterializer.getRootConverter(), MessageColumnIO.this.getType(), MessageColumnIO.this.createdBy));
            }
        });
    }

    public RecordConsumer getRecordWriter(ColumnWriteStore columns) {
        RecordConsumer recordWriter = new MessageColumnIORecordConsumer(columns);
        if (DEBUG) {
            recordWriter = new RecordConsumerLoggingWrapper(recordWriter);
        }
        return this.validating ? new ValidatingRecordConsumer(recordWriter, this.getType()) : recordWriter;
    }

    void setLevels() {
        this.setLevels(0, 0, new String[0], new int[0], Arrays.asList(this), Arrays.asList(this));
    }

    void setLeaves(List<PrimitiveColumnIO> leaves) {
        this.leaves = leaves;
    }

    public List<PrimitiveColumnIO> getLeaves() {
        return this.leaves;
    }

    @Override
    public MessageType getType() {
        return (MessageType)super.getType();
    }

    private class MessageColumnIORecordConsumer
    extends RecordConsumer {
        private ColumnIO currentColumnIO;
        private int currentLevel = 0;
        private final FieldsMarker[] fieldsWritten;
        private final int[] r;
        private final ColumnWriter[] columnWriter;
        private final ColumnWriteStore columns;
        private boolean emptyField = true;

        public MessageColumnIORecordConsumer(ColumnWriteStore columns) {
            this.columns = columns;
            int maxDepth = 0;
            this.columnWriter = new ColumnWriter[MessageColumnIO.this.getLeaves().size()];
            for (PrimitiveColumnIO primitiveColumnIO : MessageColumnIO.this.getLeaves()) {
                maxDepth = Math.max(maxDepth, primitiveColumnIO.getFieldPath().length);
                this.columnWriter[primitiveColumnIO.getId()] = columns.getColumnWriter(primitiveColumnIO.getColumnDescriptor());
            }
            this.fieldsWritten = new FieldsMarker[maxDepth];
            for (int i = 0; i < maxDepth; ++i) {
                this.fieldsWritten[i] = new FieldsMarker();
            }
            this.r = new int[maxDepth];
        }

        public void printState() {
            this.log(this.currentLevel + ", " + this.fieldsWritten[this.currentLevel] + ": " + Arrays.toString(this.currentColumnIO.getFieldPath()) + " r:" + this.r[this.currentLevel]);
            if (this.r[this.currentLevel] > this.currentColumnIO.getRepetitionLevel()) {
                throw new InvalidRecordException(this.r[this.currentLevel] + "(r) > " + this.currentColumnIO.getRepetitionLevel() + " ( schema r)");
            }
        }

        private void log(Object m) {
            String indent2 = "";
            for (int i = 0; i < this.currentLevel; ++i) {
                indent2 = indent2 + "  ";
            }
            logger.debug(indent2 + m);
        }

        @Override
        public void startMessage() {
            if (DEBUG) {
                this.log("< MESSAGE START >");
            }
            this.currentColumnIO = MessageColumnIO.this;
            this.r[0] = 0;
            int numberOfFieldsToVisit = ((GroupColumnIO)this.currentColumnIO).getChildrenCount();
            this.fieldsWritten[0].reset(numberOfFieldsToVisit);
            if (DEBUG) {
                this.printState();
            }
        }

        @Override
        public void endMessage() {
            this.writeNullForMissingFieldsAtCurrentLevel();
            this.columns.endRecord();
            if (DEBUG) {
                this.log("< MESSAGE END >");
            }
            if (DEBUG) {
                this.printState();
            }
        }

        @Override
        public void startField(String field2, int index2) {
            try {
                if (DEBUG) {
                    this.log("startField(" + field2 + ", " + index2 + ")");
                }
                this.currentColumnIO = ((GroupColumnIO)this.currentColumnIO).getChild(index2);
                this.emptyField = true;
                if (DEBUG) {
                    this.printState();
                }
            }
            catch (RuntimeException e) {
                throw new ParquetEncodingException("error starting field " + field2 + " at " + index2, e);
            }
        }

        @Override
        public void endField(String field2, int index2) {
            if (DEBUG) {
                this.log("endField(" + field2 + ", " + index2 + ")");
            }
            this.currentColumnIO = this.currentColumnIO.getParent();
            if (this.emptyField) {
                throw new ParquetEncodingException("empty fields are illegal, the field should be ommited completely instead");
            }
            this.fieldsWritten[this.currentLevel].markWritten(index2);
            int n = this.r[this.currentLevel] = this.currentLevel == 0 ? 0 : this.r[this.currentLevel - 1];
            if (DEBUG) {
                this.printState();
            }
        }

        private void writeNullForMissingFieldsAtCurrentLevel() {
            int currentFieldsCount = ((GroupColumnIO)this.currentColumnIO).getChildrenCount();
            for (int i = 0; i < currentFieldsCount; ++i) {
                if (this.fieldsWritten[this.currentLevel].isWritten(i)) continue;
                try {
                    ColumnIO undefinedField = ((GroupColumnIO)this.currentColumnIO).getChild(i);
                    int d = this.currentColumnIO.getDefinitionLevel();
                    if (DEBUG) {
                        this.log(Arrays.toString(undefinedField.getFieldPath()) + ".writeNull(" + this.r[this.currentLevel] + "," + d + ")");
                    }
                    this.writeNull(undefinedField, this.r[this.currentLevel], d);
                    continue;
                }
                catch (RuntimeException e) {
                    throw new ParquetEncodingException("error while writing nulls for fields of indexes " + i + " . current index: " + this.fieldsWritten[this.currentLevel], e);
                }
            }
        }

        private void writeNull(ColumnIO undefinedField, int r, int d) {
            if (undefinedField.getType().isPrimitive()) {
                this.columnWriter[((PrimitiveColumnIO)undefinedField).getId()].writeNull(r, d);
            } else {
                GroupColumnIO groupColumnIO = (GroupColumnIO)undefinedField;
                int childrenCount = groupColumnIO.getChildrenCount();
                for (int i = 0; i < childrenCount; ++i) {
                    this.writeNull(groupColumnIO.getChild(i), r, d);
                }
            }
        }

        private void setRepetitionLevel() {
            this.r[this.currentLevel] = this.currentColumnIO.getRepetitionLevel();
            if (DEBUG) {
                this.log("r: " + this.r[this.currentLevel]);
            }
        }

        @Override
        public void startGroup() {
            if (DEBUG) {
                this.log("startGroup()");
            }
            ++this.currentLevel;
            this.r[this.currentLevel] = this.r[this.currentLevel - 1];
            int fieldsCount = ((GroupColumnIO)this.currentColumnIO).getChildrenCount();
            this.fieldsWritten[this.currentLevel].reset(fieldsCount);
            if (DEBUG) {
                this.printState();
            }
        }

        @Override
        public void endGroup() {
            if (DEBUG) {
                this.log("endGroup()");
            }
            this.emptyField = false;
            this.writeNullForMissingFieldsAtCurrentLevel();
            --this.currentLevel;
            this.setRepetitionLevel();
            if (DEBUG) {
                this.printState();
            }
        }

        private ColumnWriter getColumnWriter() {
            return this.columnWriter[((PrimitiveColumnIO)this.currentColumnIO).getId()];
        }

        @Override
        public void addInteger(int value2) {
            if (DEBUG) {
                this.log("addInt(" + value2 + ")");
            }
            this.emptyField = false;
            this.getColumnWriter().write(value2, this.r[this.currentLevel], this.currentColumnIO.getDefinitionLevel());
            this.setRepetitionLevel();
            if (DEBUG) {
                this.printState();
            }
        }

        @Override
        public void addLong(long value2) {
            if (DEBUG) {
                this.log("addLong(" + value2 + ")");
            }
            this.emptyField = false;
            this.getColumnWriter().write(value2, this.r[this.currentLevel], this.currentColumnIO.getDefinitionLevel());
            this.setRepetitionLevel();
            if (DEBUG) {
                this.printState();
            }
        }

        @Override
        public void addBoolean(boolean value2) {
            if (DEBUG) {
                this.log("addBoolean(" + value2 + ")");
            }
            this.emptyField = false;
            this.getColumnWriter().write(value2, this.r[this.currentLevel], this.currentColumnIO.getDefinitionLevel());
            this.setRepetitionLevel();
            if (DEBUG) {
                this.printState();
            }
        }

        @Override
        public void addBinary(Binary value2) {
            if (DEBUG) {
                this.log("addBinary(" + value2.length() + " bytes)");
            }
            this.emptyField = false;
            this.getColumnWriter().write(value2, this.r[this.currentLevel], this.currentColumnIO.getDefinitionLevel());
            this.setRepetitionLevel();
            if (DEBUG) {
                this.printState();
            }
        }

        @Override
        public void addFloat(float value2) {
            if (DEBUG) {
                this.log("addFloat(" + value2 + ")");
            }
            this.emptyField = false;
            this.getColumnWriter().write(value2, this.r[this.currentLevel], this.currentColumnIO.getDefinitionLevel());
            this.setRepetitionLevel();
            if (DEBUG) {
                this.printState();
            }
        }

        @Override
        public void addDouble(double value2) {
            if (DEBUG) {
                this.log("addDouble(" + value2 + ")");
            }
            this.emptyField = false;
            this.getColumnWriter().write(value2, this.r[this.currentLevel], this.currentColumnIO.getDefinitionLevel());
            this.setRepetitionLevel();
            if (DEBUG) {
                this.printState();
            }
        }

        private class FieldsMarker {
            private BitSet vistedIndexes = new BitSet();

            private FieldsMarker() {
            }

            public String toString() {
                return "VistedIndex{vistedIndexes=" + this.vistedIndexes + '}';
            }

            public void reset(int fieldsCount) {
                this.vistedIndexes.clear(0, fieldsCount);
            }

            public void markWritten(int i) {
                this.vistedIndexes.set(i);
            }

            public boolean isWritten(int i) {
                return this.vistedIndexes.get(i);
            }
        }
    }
}

