/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.io;

import org.apache.parquet.Log;
import org.apache.parquet.column.ColumnReadStore;
import org.apache.parquet.io.ParquetDecodingException;
import org.apache.parquet.io.RecordReader;
import org.apache.parquet.io.RecordReaderImplementation;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.RecordConsumer;
import org.apache.parquet.io.api.RecordMaterializer;

public abstract class BaseRecordReader<T>
extends RecordReader<T> {
    private static final Log LOG = Log.getLog(BaseRecordReader.class);
    public RecordConsumer recordConsumer;
    public RecordMaterializer<T> recordMaterializer;
    public ColumnReadStore columnStore;
    RecordReaderImplementation.State[] caseLookup;
    private String endField;
    private int endIndex;

    @Override
    public T read() {
        this.readOneRecord();
        return this.recordMaterializer.getCurrentRecord();
    }

    protected abstract void readOneRecord();

    protected void currentLevel(int currentLevel) {
        if (Log.DEBUG) {
            LOG.debug("currentLevel: " + currentLevel);
        }
    }

    protected void log(String message) {
        if (Log.DEBUG) {
            LOG.debug("bc: " + message);
        }
    }

    protected final int getCaseId(int state, int currentLevel, int d, int nextR) {
        return this.caseLookup[state].getCase(currentLevel, d, nextR).getID();
    }

    protected final void startMessage() {
        this.endField = null;
        if (Log.DEBUG) {
            LOG.debug("startMessage()");
        }
        this.recordConsumer.startMessage();
    }

    protected final void startGroup(String field2, int index2) {
        this.startField(field2, index2);
        if (Log.DEBUG) {
            LOG.debug("startGroup()");
        }
        this.recordConsumer.startGroup();
    }

    private void startField(String field2, int index2) {
        if (Log.DEBUG) {
            LOG.debug("startField(" + field2 + "," + index2 + ")");
        }
        if (this.endField != null && index2 == this.endIndex) {
            this.endField = null;
        } else {
            if (this.endField != null) {
                this.recordConsumer.endField(this.endField, this.endIndex);
                this.endField = null;
            }
            this.recordConsumer.startField(field2, index2);
        }
    }

    protected final void addPrimitiveINT64(String field2, int index2, long value2) {
        this.startField(field2, index2);
        if (Log.DEBUG) {
            LOG.debug("addLong(" + value2 + ")");
        }
        this.recordConsumer.addLong(value2);
        this.endField(field2, index2);
    }

    private void endField(String field2, int index2) {
        if (Log.DEBUG) {
            LOG.debug("endField(" + field2 + "," + index2 + ")");
        }
        if (this.endField != null) {
            this.recordConsumer.endField(this.endField, this.endIndex);
        }
        this.endField = field2;
        this.endIndex = index2;
    }

    protected final void addPrimitiveBINARY(String field2, int index2, Binary value2) {
        this.startField(field2, index2);
        if (Log.DEBUG) {
            LOG.debug("addBinary(" + value2 + ")");
        }
        this.recordConsumer.addBinary(value2);
        this.endField(field2, index2);
    }

    protected final void addPrimitiveINT32(String field2, int index2, int value2) {
        this.startField(field2, index2);
        if (Log.DEBUG) {
            LOG.debug("addInteger(" + value2 + ")");
        }
        this.recordConsumer.addInteger(value2);
        this.endField(field2, index2);
    }

    protected final void endGroup(String field2, int index2) {
        if (this.endField != null) {
            this.recordConsumer.endField(this.endField, this.endIndex);
            this.endField = null;
        }
        if (Log.DEBUG) {
            LOG.debug("endGroup()");
        }
        this.recordConsumer.endGroup();
        this.endField(field2, index2);
    }

    protected final void endMessage() {
        if (this.endField != null) {
            this.recordConsumer.endField(this.endField, this.endIndex);
            this.endField = null;
        }
        if (Log.DEBUG) {
            LOG.debug("endMessage()");
        }
        this.recordConsumer.endMessage();
    }

    protected void error(String message) {
        throw new ParquetDecodingException(message);
    }
}

