/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.Closeables;
import org.apache.parquet.Log;

public final class SerializationUtil {
    private static final Log LOG = Log.getLog(SerializationUtil.class);

    private SerializationUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeObjectToConfAsBase64(String key, Object obj, Configuration conf) throws IOException {
        ByteArrayOutputStream baos = null;
        GZIPOutputStream gos = null;
        ObjectOutputStream oos = null;
        try {
            baos = new ByteArrayOutputStream();
            gos = new GZIPOutputStream(baos);
            oos = new ObjectOutputStream(gos);
            oos.writeObject(obj);
        }
        catch (Throwable throwable2) {
            Closeables.close(oos);
            Closeables.close(gos);
            Closeables.close(baos);
            throw throwable2;
        }
        Closeables.close(oos);
        Closeables.close(gos);
        Closeables.close(baos);
        conf.set(key, new String(Base64.encodeBase64(baos.toByteArray()), "UTF-8"));
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T readObjectFromConfAsBase64(String key, Configuration conf) throws IOException {
        Object object;
        String b64 = conf.get(key);
        if (b64 == null) {
            return null;
        }
        byte[] bytes2 = Base64.decodeBase64(b64.getBytes("UTF-8"));
        ByteArrayInputStream bais = null;
        GZIPInputStream gis = null;
        ObjectInputStream ois = null;
        try {
            bais = new ByteArrayInputStream(bytes2);
            gis = new GZIPInputStream(bais);
            ois = new ObjectInputStream(gis);
            object = ois.readObject();
        }
        catch (ClassNotFoundException e) {
            try {
                throw new IOException("Could not read object from config with key " + key, e);
                catch (ClassCastException e2) {
                    throw new IOException("Couldn't cast object read from config with key " + key, e2);
                }
            }
            catch (Throwable throwable2) {
                Closeables.close(ois);
                Closeables.close(gis);
                Closeables.close(bais);
                throw throwable2;
            }
        }
        Closeables.close(ois);
        Closeables.close(gis);
        Closeables.close(bais);
        return (T)object;
    }
}

