/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop.thrift;

import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.hadoop.thrift.AbstractThriftWriteSupport;
import org.apache.parquet.io.ParquetEncodingException;
import org.apache.parquet.thrift.ThriftSchemaConverter;
import org.apache.parquet.thrift.struct.ThriftType;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;

public class TBaseWriteSupport<T extends TBase<?, ?>>
extends AbstractThriftWriteSupport<T> {
    public static <U extends TBase<?, ?>> void setThriftClass(Configuration configuration, Class<U> thriftClass) {
        AbstractThriftWriteSupport.setGenericThriftClass(configuration, thriftClass);
    }

    public static Class<? extends TBase<?, ?>> getThriftClass(Configuration configuration) {
        return AbstractThriftWriteSupport.getGenericThriftClass(configuration);
    }

    public TBaseWriteSupport() {
    }

    public TBaseWriteSupport(Class<T> thriftClass) {
        super(thriftClass);
    }

    @Override
    protected ThriftType.StructType getThriftStruct() {
        ThriftSchemaConverter thriftSchemaConverter = new ThriftSchemaConverter();
        return ThriftSchemaConverter.toStructType(this.thriftClass);
    }

    @Override
    public void write(T record2) {
        try {
            record2.write(this.parquetWriteProtocol);
        }
        catch (TException e) {
            throw new ParquetEncodingException(e);
        }
    }
}

