/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop.metadata;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.parquet.column.Encoding;
import org.apache.parquet.hadoop.metadata.Canonicalizer;

public class EncodingList
implements Iterable<Encoding> {
    private static Canonicalizer<EncodingList> encodingLists = new Canonicalizer();
    private final List<Encoding> encodings;

    public static EncodingList getEncodingList(List<Encoding> encodings) {
        return encodingLists.canonicalize(new EncodingList(encodings));
    }

    private EncodingList(List<Encoding> encodings) {
        this.encodings = Collections.unmodifiableList(encodings);
    }

    public boolean equals(Object obj) {
        if (obj instanceof EncodingList) {
            List<Encoding> other = ((EncodingList)obj).encodings;
            int size2 = other.size();
            if (size2 != this.encodings.size()) {
                return false;
            }
            for (int i = 0; i < size2; ++i) {
                if (other.get(i).equals((Object)this.encodings.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int result2 = 1;
        for (Encoding element : this.encodings) {
            result2 = 31 * result2 + (element == null ? 0 : element.hashCode());
        }
        return result2;
    }

    public List<Encoding> toList() {
        return this.encodings;
    }

    @Override
    public Iterator<Encoding> iterator() {
        return this.encodings.iterator();
    }

    public int size() {
        return this.encodings.size();
    }
}

