/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop.metadata;

import org.apache.parquet.format.CompressionCodec;
import org.apache.parquet.hadoop.codec.CompressionCodecNotSupportedException;

public enum CompressionCodecName {
    UNCOMPRESSED(null, CompressionCodec.UNCOMPRESSED, ""),
    SNAPPY("org.apache.parquet.hadoop.codec.SnappyCodec", CompressionCodec.SNAPPY, ".snappy"),
    GZIP("org.apache.hadoop.io.compress.GzipCodec", CompressionCodec.GZIP, ".gz"),
    LZO("com.hadoop.compression.lzo.LzoCodec", CompressionCodec.LZO, ".lzo");

    private final String hadoopCompressionCodecClass;
    private final CompressionCodec parquetCompressionCodec;
    private final String extension;

    public static CompressionCodecName fromConf(String name2) {
        if (name2 == null) {
            return UNCOMPRESSED;
        }
        return CompressionCodecName.valueOf(name2.toUpperCase());
    }

    public static CompressionCodecName fromCompressionCodec(Class<?> clazz2) {
        if (clazz2 == null) {
            return UNCOMPRESSED;
        }
        String name2 = clazz2.getName();
        for (CompressionCodecName codec : CompressionCodecName.values()) {
            if (!name2.equals(codec.getHadoopCompressionCodecClassName())) continue;
            return codec;
        }
        throw new CompressionCodecNotSupportedException(clazz2);
    }

    public static CompressionCodecName fromParquet(CompressionCodec codec) {
        for (CompressionCodecName codecName : CompressionCodecName.values()) {
            if (!codec.equals(codecName.parquetCompressionCodec)) continue;
            return codecName;
        }
        throw new IllegalArgumentException("Unknown compression codec " + codec);
    }

    private CompressionCodecName(String hadoopCompressionCodecClass, CompressionCodec parquetCompressionCodec, String extension2) {
        this.hadoopCompressionCodecClass = hadoopCompressionCodecClass;
        this.parquetCompressionCodec = parquetCompressionCodec;
        this.extension = extension2;
    }

    public String getHadoopCompressionCodecClassName() {
        return this.hadoopCompressionCodecClass;
    }

    public Class getHadoopCompressionCodecClass() {
        String codecClassName = this.getHadoopCompressionCodecClassName();
        if (codecClassName == null) {
            return null;
        }
        try {
            return Class.forName(codecClassName);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public CompressionCodec getParquetCompressionCodec() {
        return this.parquetCompressionCodec;
    }

    public String getExtension() {
        return this.extension;
    }
}

