/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.parquet.CorruptDeltaByteArrays;
import org.apache.parquet.Log;
import org.apache.parquet.column.Encoding;
import org.apache.parquet.filter.UnboundRecordFilter;
import org.apache.parquet.filter2.compat.FilterCompat;
import org.apache.parquet.filter2.compat.RowGroupFilter;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.InternalParquetRecordReader;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.ParquetInputFormat;
import org.apache.parquet.hadoop.ParquetInputSplit;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.hadoop.util.ContextUtil;
import org.apache.parquet.hadoop.util.counters.BenchmarkCounter;
import org.apache.parquet.io.ParquetDecodingException;
import org.apache.parquet.schema.MessageType;

public class ParquetRecordReader<T>
extends RecordReader<Void, T> {
    private static final Log LOG = Log.getLog(ParquetRecordReader.class);
    private final InternalParquetRecordReader<T> internalReader;

    public ParquetRecordReader(ReadSupport<T> readSupport) {
        this(readSupport, FilterCompat.NOOP);
    }

    public ParquetRecordReader(ReadSupport<T> readSupport, FilterCompat.Filter filter2) {
        this.internalReader = new InternalParquetRecordReader<T>(readSupport, filter2);
    }

    @Deprecated
    public ParquetRecordReader(ReadSupport<T> readSupport, UnboundRecordFilter filter2) {
        this(readSupport, FilterCompat.get(filter2));
    }

    public void close() throws IOException {
        this.internalReader.close();
    }

    public Void getCurrentKey() throws IOException, InterruptedException {
        return null;
    }

    public T getCurrentValue() throws IOException, InterruptedException {
        return this.internalReader.getCurrentValue();
    }

    public float getProgress() throws IOException, InterruptedException {
        return this.internalReader.getProgress();
    }

    public void initialize(InputSplit inputSplit, TaskAttemptContext context) throws IOException, InterruptedException {
        if (context instanceof TaskInputOutputContext) {
            BenchmarkCounter.initCounterFromContext((TaskInputOutputContext)context);
        } else {
            LOG.error("Can not initialize counter due to context is not a instance of TaskInputOutputContext, but is " + context.getClass().getCanonicalName());
        }
        this.initializeInternalReader(this.toParquetSplit(inputSplit), ContextUtil.getConfiguration((JobContext)context));
    }

    public void initialize(InputSplit inputSplit, Configuration configuration, Reporter reporter) throws IOException, InterruptedException {
        BenchmarkCounter.initCounterFromReporter(reporter, configuration);
        this.initializeInternalReader(this.toParquetSplit(inputSplit), configuration);
    }

    private void initializeInternalReader(ParquetInputSplit split2, Configuration configuration) throws IOException {
        List<BlockMetaData> filteredBlocks;
        MessageType fileSchema;
        ParquetMetadata footer;
        Path path = split2.getPath();
        long[] rowGroupOffsets = split2.getRowGroupOffsets();
        if (rowGroupOffsets == null) {
            footer = ParquetFileReader.readFooter(configuration, path, ParquetMetadataConverter.range(split2.getStart(), split2.getEnd()));
            fileSchema = footer.getFileMetaData().getSchema();
            FilterCompat.Filter filter2 = ParquetInputFormat.getFilter(configuration);
            filteredBlocks = RowGroupFilter.filterRowGroups(filter2, footer.getBlocks(), fileSchema);
        } else {
            footer = ParquetFileReader.readFooter(configuration, path, ParquetMetadataConverter.NO_FILTER);
            HashSet<Long> offsets = new HashSet<Long>();
            for (long offset : rowGroupOffsets) {
                offsets.add(offset);
            }
            filteredBlocks = new ArrayList<BlockMetaData>();
            for (BlockMetaData block : footer.getBlocks()) {
                if (!offsets.contains(block.getStartingPos())) continue;
                filteredBlocks.add(block);
            }
            if (filteredBlocks.size() != rowGroupOffsets.length) {
                long[] foundRowGroupOffsets = new long[footer.getBlocks().size()];
                for (int i = 0; i < foundRowGroupOffsets.length; ++i) {
                    foundRowGroupOffsets[i] = footer.getBlocks().get(i).getStartingPos();
                }
                throw new IllegalStateException("All the offsets listed in the split should be found in the file. expected: " + Arrays.toString(rowGroupOffsets) + " found: " + filteredBlocks + " out of: " + Arrays.toString(foundRowGroupOffsets) + " in range " + split2.getStart() + ", " + split2.getEnd());
            }
        }
        if (!filteredBlocks.isEmpty()) {
            this.checkDeltaByteArrayProblem(footer.getFileMetaData(), configuration, filteredBlocks.get(0));
        }
        fileSchema = footer.getFileMetaData().getSchema();
        this.internalReader.initialize(fileSchema, footer.getFileMetaData(), path, filteredBlocks, configuration);
    }

    private void checkDeltaByteArrayProblem(FileMetaData meta, Configuration conf, BlockMetaData block) {
        if (conf.getBoolean("parquet.split.files", true)) {
            HashSet<Encoding> encodings = new HashSet<Encoding>();
            for (ColumnChunkMetaData column : block.getColumns()) {
                encodings.addAll(column.getEncodings());
            }
            for (Encoding encoding : encodings) {
                if (!CorruptDeltaByteArrays.requiresSequentialReads(meta.getCreatedBy(), encoding)) continue;
                throw new ParquetDecodingException("Cannot read data due to PARQUET-246: to read safely, set parquet.split.files to false");
            }
        }
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        return this.internalReader.nextKeyValue();
    }

    private ParquetInputSplit toParquetSplit(InputSplit split2) throws IOException {
        if (split2 instanceof ParquetInputSplit) {
            return (ParquetInputSplit)split2;
        }
        if (split2 instanceof FileSplit) {
            return ParquetInputSplit.from((FileSplit)split2);
        }
        if (split2 instanceof org.apache.hadoop.mapred.FileSplit) {
            return ParquetInputSplit.from((org.apache.hadoop.mapred.FileSplit)split2);
        }
        throw new IllegalArgumentException("Invalid split (not a FileSplit or ParquetInputSplit): " + split2);
    }
}

