/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.glob;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.parquet.glob.GlobNode;
import org.apache.parquet.glob.GlobParser;

public final class GlobExpander {
    private GlobExpander() {
    }

    public static List<String> expand(String globPattern) {
        return GlobExpanderImpl.expand(GlobParser.parse(globPattern));
    }

    private static final class GlobExpanderImpl
    implements GlobNode.Visitor<List<String>> {
        private static final GlobExpanderImpl INSTANCE = new GlobExpanderImpl();

        private GlobExpanderImpl() {
        }

        public static List<String> expand(GlobNode node) {
            return node.accept(INSTANCE);
        }

        @Override
        public List<String> visit(GlobNode.Atom atom) {
            return Arrays.asList(atom.get());
        }

        @Override
        public List<String> visit(GlobNode.OneOf oneOf) {
            ArrayList<String> results2 = new ArrayList<String>();
            for (GlobNode n : oneOf.getChildren()) {
                results2.addAll((Collection<String>)n.accept(this));
            }
            return results2;
        }

        @Override
        public List<String> visit(GlobNode.GlobNodeSequence seq) {
            List<String> results2 = new ArrayList<String>();
            for (GlobNode n : seq.getChildren()) {
                results2 = GlobExpanderImpl.crossOrTakeNonEmpty(results2, n.accept(this));
            }
            return results2;
        }

        public static List<String> crossOrTakeNonEmpty(List<String> list1, List<String> list2) {
            if (list1.isEmpty()) {
                ArrayList<String> result2 = new ArrayList<String>(list2.size());
                result2.addAll(list2);
                return result2;
            }
            if (list2.isEmpty()) {
                ArrayList<String> result3 = new ArrayList<String>(list1.size());
                result3.addAll(list1);
                return result3;
            }
            ArrayList<String> result4 = new ArrayList<String>(list1.size() * list2.size());
            for (String s1 : list1) {
                for (String s2 : list2) {
                    result4.add(s1 + s2);
                }
            }
            return result4;
        }
    }
}

