/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.format;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.parquet.format.FileMetaData;
import org.apache.parquet.format.InterningProtocol;
import org.apache.parquet.format.KeyValue;
import org.apache.parquet.format.PageHeader;
import org.apache.parquet.format.RowGroup;
import org.apache.parquet.format.SchemaElement;
import org.apache.parquet.format.event.Consumers;
import org.apache.parquet.format.event.EventBasedThriftReader;
import org.apache.parquet.format.event.TypedConsumer;
import parquet.org.apache.thrift.TBase;
import parquet.org.apache.thrift.TException;
import parquet.org.apache.thrift.protocol.TCompactProtocol;
import parquet.org.apache.thrift.protocol.TProtocol;
import parquet.org.apache.thrift.transport.TIOStreamTransport;

public class Util {
    public static void writePageHeader(PageHeader pageHeader, OutputStream to2) throws IOException {
        Util.write(pageHeader, to2);
    }

    public static PageHeader readPageHeader(InputStream from2) throws IOException {
        return Util.read(from2, new PageHeader());
    }

    public static void writeFileMetaData(FileMetaData fileMetadata, OutputStream to2) throws IOException {
        Util.write(fileMetadata, to2);
    }

    public static FileMetaData readFileMetaData(InputStream from2) throws IOException {
        return Util.read(from2, new FileMetaData());
    }

    public static FileMetaData readFileMetaData(InputStream from2, boolean skipRowGroups) throws IOException {
        FileMetaData md = new FileMetaData();
        if (skipRowGroups) {
            Util.readFileMetaData(from2, new DefaultFileMetaDataConsumer(md), skipRowGroups);
        } else {
            Util.read(from2, md);
        }
        return md;
    }

    public static void readFileMetaData(InputStream from2, FileMetaDataConsumer consumer) throws IOException {
        Util.readFileMetaData(from2, consumer, false);
    }

    public static void readFileMetaData(InputStream from2, final FileMetaDataConsumer consumer, boolean skipRowGroups) throws IOException {
        try {
            Consumers.DelegatingFieldConsumer eventConsumer = Consumers.fieldConsumer().onField(FileMetaData._Fields.VERSION, new TypedConsumer.I32Consumer(){

                @Override
                public void consume(int value2) {
                    consumer.setVersion(value2);
                }
            }).onField(FileMetaData._Fields.SCHEMA, Consumers.listOf(SchemaElement.class, new Consumers.Consumer<List<SchemaElement>>(){

                @Override
                public void consume(List<SchemaElement> schema) {
                    consumer.setSchema(schema);
                }
            })).onField(FileMetaData._Fields.NUM_ROWS, new TypedConsumer.I64Consumer(){

                @Override
                public void consume(long value2) {
                    consumer.setNumRows(value2);
                }
            }).onField(FileMetaData._Fields.KEY_VALUE_METADATA, Consumers.listElementsOf(Consumers.struct(KeyValue.class, new Consumers.Consumer<KeyValue>(){

                @Override
                public void consume(KeyValue kv) {
                    consumer.addKeyValueMetaData(kv);
                }
            }))).onField(FileMetaData._Fields.CREATED_BY, new TypedConsumer.StringConsumer(){

                @Override
                public void consume(String value2) {
                    consumer.setCreatedBy(value2);
                }
            });
            if (!skipRowGroups) {
                eventConsumer = eventConsumer.onField(FileMetaData._Fields.ROW_GROUPS, Consumers.listElementsOf(Consumers.struct(RowGroup.class, new Consumers.Consumer<RowGroup>(){

                    @Override
                    public void consume(RowGroup rowGroup) {
                        consumer.addRowGroup(rowGroup);
                    }
                })));
            }
            new EventBasedThriftReader(Util.protocol(from2)).readStruct(eventConsumer);
        }
        catch (TException e) {
            throw new IOException("can not read FileMetaData: " + e.getMessage(), e);
        }
    }

    private static TProtocol protocol(OutputStream to2) {
        return Util.protocol(new TIOStreamTransport(to2));
    }

    private static TProtocol protocol(InputStream from2) {
        return Util.protocol(new TIOStreamTransport(from2));
    }

    private static InterningProtocol protocol(TIOStreamTransport t) {
        return new InterningProtocol(new TCompactProtocol(t));
    }

    private static <T extends TBase<?, ?>> T read(InputStream from2, T tbase) throws IOException {
        try {
            tbase.read(Util.protocol(from2));
            return tbase;
        }
        catch (TException e) {
            throw new IOException("can not read " + tbase.getClass() + ": " + e.getMessage(), e);
        }
    }

    private static void write(TBase<?, ?> tbase, OutputStream to2) throws IOException {
        try {
            tbase.write(Util.protocol(to2));
        }
        catch (TException e) {
            throw new IOException("can not write " + tbase, e);
        }
    }

    public static final class DefaultFileMetaDataConsumer
    extends FileMetaDataConsumer {
        private final FileMetaData md;

        public DefaultFileMetaDataConsumer(FileMetaData md) {
            this.md = md;
        }

        @Override
        public void setVersion(int version) {
            this.md.setVersion(version);
        }

        @Override
        public void setSchema(List<SchemaElement> schema) {
            this.md.setSchema(schema);
        }

        @Override
        public void setNumRows(long numRows) {
            this.md.setNum_rows(numRows);
        }

        @Override
        public void setCreatedBy(String createdBy) {
            this.md.setCreated_by(createdBy);
        }

        @Override
        public void addRowGroup(RowGroup rowGroup) {
            this.md.addToRow_groups(rowGroup);
        }

        @Override
        public void addKeyValueMetaData(KeyValue kv) {
            this.md.addToKey_value_metadata(kv);
        }
    }

    public static abstract class FileMetaDataConsumer {
        public abstract void setVersion(int var1);

        public abstract void setSchema(List<SchemaElement> var1);

        public abstract void setNumRows(long var1);

        public abstract void addRowGroup(RowGroup var1);

        public abstract void addKeyValueMetaData(KeyValue var1);

        public abstract void setCreatedBy(String var1);
    }
}

