/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.filter2.recordlevel;

import org.apache.parquet.filter2.predicate.Operators;
import org.apache.parquet.filter2.predicate.UserDefinedPredicate;
import org.apache.parquet.filter2.recordlevel.IncrementallyUpdatedFilterPredicate;
import org.apache.parquet.filter2.recordlevel.IncrementallyUpdatedFilterPredicateBuilderBase;
import org.apache.parquet.hadoop.metadata.ColumnPath;
import org.apache.parquet.io.api.Binary;

public class IncrementallyUpdatedFilterPredicateBuilder
extends IncrementallyUpdatedFilterPredicateBuilderBase {
    @Override
    public <T extends Comparable<T>> IncrementallyUpdatedFilterPredicate visit(Operators.Eq<T> pred) {
        ColumnPath columnPath = pred.getColumn().getColumnPath();
        Class clazz2 = pred.getColumn().getColumnType();
        IncrementallyUpdatedFilterPredicate.ValueInspector valueInspector = null;
        if (clazz2.equals(Integer.class)) {
            if (pred.getValue() == null) {
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(true);
                    }

                    @Override
                    public void update(int value2) {
                        this.setResult(false);
                    }
                };
            } else {
                final int n = (Integer)pred.getValue();
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(false);
                    }

                    @Override
                    public void update(int value2) {
                        this.setResult(value2 == n);
                    }
                };
            }
        }
        if (clazz2.equals(Long.class)) {
            if (pred.getValue() == null) {
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(true);
                    }

                    @Override
                    public void update(long value2) {
                        this.setResult(false);
                    }
                };
            } else {
                final long target2 = (Long)pred.getValue();
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(false);
                    }

                    @Override
                    public void update(long value2) {
                        this.setResult(value2 == target2);
                    }
                };
            }
        }
        if (clazz2.equals(Boolean.class)) {
            if (pred.getValue() == null) {
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(true);
                    }

                    @Override
                    public void update(boolean value2) {
                        this.setResult(false);
                    }
                };
            } else {
                final boolean bl = (Boolean)pred.getValue();
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(false);
                    }

                    @Override
                    public void update(boolean value2) {
                        this.setResult(value2 == bl);
                    }
                };
            }
        }
        if (clazz2.equals(Float.class)) {
            if (pred.getValue() == null) {
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(true);
                    }

                    @Override
                    public void update(float value2) {
                        this.setResult(false);
                    }
                };
            } else {
                final float f2 = ((Float)pred.getValue()).floatValue();
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(false);
                    }

                    @Override
                    public void update(float value2) {
                        this.setResult(value2 == f2);
                    }
                };
            }
        }
        if (clazz2.equals(Double.class)) {
            if (pred.getValue() == null) {
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(true);
                    }

                    @Override
                    public void update(double value2) {
                        this.setResult(false);
                    }
                };
            } else {
                final double target4 = (Double)pred.getValue();
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(false);
                    }

                    @Override
                    public void update(double value2) {
                        this.setResult(value2 == target4);
                    }
                };
            }
        }
        if (clazz2.equals(Binary.class)) {
            if (pred.getValue() == null) {
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(true);
                    }

                    @Override
                    public void update(Binary value2) {
                        this.setResult(false);
                    }
                };
            } else {
                final Binary binary = (Binary)pred.getValue();
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(false);
                    }

                    @Override
                    public void update(Binary value2) {
                        this.setResult(value2.compareTo(binary) == 0);
                    }
                };
            }
        }
        if (valueInspector == null) {
            throw new IllegalArgumentException("Encountered unknown type " + clazz2);
        }
        this.addValueInspector(columnPath, valueInspector);
        return valueInspector;
    }

    @Override
    public <T extends Comparable<T>> IncrementallyUpdatedFilterPredicate visit(Operators.NotEq<T> pred) {
        ColumnPath columnPath = pred.getColumn().getColumnPath();
        Class clazz2 = pred.getColumn().getColumnType();
        IncrementallyUpdatedFilterPredicate.ValueInspector valueInspector = null;
        if (clazz2.equals(Integer.class)) {
            if (pred.getValue() == null) {
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(false);
                    }

                    @Override
                    public void update(int value2) {
                        this.setResult(true);
                    }
                };
            } else {
                final int n = (Integer)pred.getValue();
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(true);
                    }

                    @Override
                    public void update(int value2) {
                        this.setResult(value2 != n);
                    }
                };
            }
        }
        if (clazz2.equals(Long.class)) {
            if (pred.getValue() == null) {
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(false);
                    }

                    @Override
                    public void update(long value2) {
                        this.setResult(true);
                    }
                };
            } else {
                final long target2 = (Long)pred.getValue();
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(true);
                    }

                    @Override
                    public void update(long value2) {
                        this.setResult(value2 != target2);
                    }
                };
            }
        }
        if (clazz2.equals(Boolean.class)) {
            if (pred.getValue() == null) {
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(false);
                    }

                    @Override
                    public void update(boolean value2) {
                        this.setResult(true);
                    }
                };
            } else {
                final boolean bl = (Boolean)pred.getValue();
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(true);
                    }

                    @Override
                    public void update(boolean value2) {
                        this.setResult(value2 != bl);
                    }
                };
            }
        }
        if (clazz2.equals(Float.class)) {
            if (pred.getValue() == null) {
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(false);
                    }

                    @Override
                    public void update(float value2) {
                        this.setResult(true);
                    }
                };
            } else {
                final float f2 = ((Float)pred.getValue()).floatValue();
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(true);
                    }

                    @Override
                    public void update(float value2) {
                        this.setResult(value2 != f2);
                    }
                };
            }
        }
        if (clazz2.equals(Double.class)) {
            if (pred.getValue() == null) {
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(false);
                    }

                    @Override
                    public void update(double value2) {
                        this.setResult(true);
                    }
                };
            } else {
                final double target4 = (Double)pred.getValue();
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(true);
                    }

                    @Override
                    public void update(double value2) {
                        this.setResult(value2 != target4);
                    }
                };
            }
        }
        if (clazz2.equals(Binary.class)) {
            if (pred.getValue() == null) {
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(false);
                    }

                    @Override
                    public void update(Binary value2) {
                        this.setResult(true);
                    }
                };
            } else {
                final Binary binary = (Binary)pred.getValue();
                valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                    @Override
                    public void updateNull() {
                        this.setResult(true);
                    }

                    @Override
                    public void update(Binary value2) {
                        this.setResult(value2.compareTo(binary) != 0);
                    }
                };
            }
        }
        if (valueInspector == null) {
            throw new IllegalArgumentException("Encountered unknown type " + clazz2);
        }
        this.addValueInspector(columnPath, valueInspector);
        return valueInspector;
    }

    @Override
    public <T extends Comparable<T>> IncrementallyUpdatedFilterPredicate visit(Operators.Lt<T> pred) {
        ColumnPath columnPath = pred.getColumn().getColumnPath();
        Class clazz2 = pred.getColumn().getColumnType();
        IncrementallyUpdatedFilterPredicate.ValueInspector valueInspector = null;
        if (clazz2.equals(Integer.class)) {
            final int target = (Integer)pred.getValue();
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                @Override
                public void updateNull() {
                    this.setResult(false);
                }

                @Override
                public void update(int value2) {
                    this.setResult(value2 < target);
                }
            };
        }
        if (clazz2.equals(Long.class)) {
            final long target = (Long)pred.getValue();
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                @Override
                public void updateNull() {
                    this.setResult(false);
                }

                @Override
                public void update(long value2) {
                    this.setResult(value2 < target);
                }
            };
        }
        if (clazz2.equals(Boolean.class)) {
            throw new IllegalArgumentException("Operator < not supported for Boolean");
        }
        if (clazz2.equals(Float.class)) {
            final float target = ((Float)pred.getValue()).floatValue();
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                @Override
                public void updateNull() {
                    this.setResult(false);
                }

                @Override
                public void update(float value2) {
                    this.setResult(value2 < target);
                }
            };
        }
        if (clazz2.equals(Double.class)) {
            final double target = (Double)pred.getValue();
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                @Override
                public void updateNull() {
                    this.setResult(false);
                }

                @Override
                public void update(double value2) {
                    this.setResult(value2 < target);
                }
            };
        }
        if (clazz2.equals(Binary.class)) {
            final Binary target = (Binary)pred.getValue();
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                @Override
                public void updateNull() {
                    this.setResult(false);
                }

                @Override
                public void update(Binary value2) {
                    this.setResult(value2.compareTo(target) < 0);
                }
            };
        }
        if (valueInspector == null) {
            throw new IllegalArgumentException("Encountered unknown type " + clazz2);
        }
        this.addValueInspector(columnPath, valueInspector);
        return valueInspector;
    }

    @Override
    public <T extends Comparable<T>> IncrementallyUpdatedFilterPredicate visit(Operators.LtEq<T> pred) {
        ColumnPath columnPath = pred.getColumn().getColumnPath();
        Class clazz2 = pred.getColumn().getColumnType();
        IncrementallyUpdatedFilterPredicate.ValueInspector valueInspector = null;
        if (clazz2.equals(Integer.class)) {
            final int target = (Integer)pred.getValue();
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                @Override
                public void updateNull() {
                    this.setResult(false);
                }

                @Override
                public void update(int value2) {
                    this.setResult(value2 <= target);
                }
            };
        }
        if (clazz2.equals(Long.class)) {
            final long target = (Long)pred.getValue();
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                @Override
                public void updateNull() {
                    this.setResult(false);
                }

                @Override
                public void update(long value2) {
                    this.setResult(value2 <= target);
                }
            };
        }
        if (clazz2.equals(Boolean.class)) {
            throw new IllegalArgumentException("Operator <= not supported for Boolean");
        }
        if (clazz2.equals(Float.class)) {
            final float target = ((Float)pred.getValue()).floatValue();
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                @Override
                public void updateNull() {
                    this.setResult(false);
                }

                @Override
                public void update(float value2) {
                    this.setResult(value2 <= target);
                }
            };
        }
        if (clazz2.equals(Double.class)) {
            final double target = (Double)pred.getValue();
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                @Override
                public void updateNull() {
                    this.setResult(false);
                }

                @Override
                public void update(double value2) {
                    this.setResult(value2 <= target);
                }
            };
        }
        if (clazz2.equals(Binary.class)) {
            final Binary target = (Binary)pred.getValue();
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                @Override
                public void updateNull() {
                    this.setResult(false);
                }

                @Override
                public void update(Binary value2) {
                    this.setResult(value2.compareTo(target) <= 0);
                }
            };
        }
        if (valueInspector == null) {
            throw new IllegalArgumentException("Encountered unknown type " + clazz2);
        }
        this.addValueInspector(columnPath, valueInspector);
        return valueInspector;
    }

    @Override
    public <T extends Comparable<T>> IncrementallyUpdatedFilterPredicate visit(Operators.Gt<T> pred) {
        ColumnPath columnPath = pred.getColumn().getColumnPath();
        Class clazz2 = pred.getColumn().getColumnType();
        IncrementallyUpdatedFilterPredicate.ValueInspector valueInspector = null;
        if (clazz2.equals(Integer.class)) {
            final int target = (Integer)pred.getValue();
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                @Override
                public void updateNull() {
                    this.setResult(false);
                }

                @Override
                public void update(int value2) {
                    this.setResult(value2 > target);
                }
            };
        }
        if (clazz2.equals(Long.class)) {
            final long target = (Long)pred.getValue();
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                @Override
                public void updateNull() {
                    this.setResult(false);
                }

                @Override
                public void update(long value2) {
                    this.setResult(value2 > target);
                }
            };
        }
        if (clazz2.equals(Boolean.class)) {
            throw new IllegalArgumentException("Operator > not supported for Boolean");
        }
        if (clazz2.equals(Float.class)) {
            final float target = ((Float)pred.getValue()).floatValue();
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                @Override
                public void updateNull() {
                    this.setResult(false);
                }

                @Override
                public void update(float value2) {
                    this.setResult(value2 > target);
                }
            };
        }
        if (clazz2.equals(Double.class)) {
            final double target = (Double)pred.getValue();
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                @Override
                public void updateNull() {
                    this.setResult(false);
                }

                @Override
                public void update(double value2) {
                    this.setResult(value2 > target);
                }
            };
        }
        if (clazz2.equals(Binary.class)) {
            final Binary target = (Binary)pred.getValue();
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                @Override
                public void updateNull() {
                    this.setResult(false);
                }

                @Override
                public void update(Binary value2) {
                    this.setResult(value2.compareTo(target) > 0);
                }
            };
        }
        if (valueInspector == null) {
            throw new IllegalArgumentException("Encountered unknown type " + clazz2);
        }
        this.addValueInspector(columnPath, valueInspector);
        return valueInspector;
    }

    @Override
    public <T extends Comparable<T>> IncrementallyUpdatedFilterPredicate visit(Operators.GtEq<T> pred) {
        ColumnPath columnPath = pred.getColumn().getColumnPath();
        Class clazz2 = pred.getColumn().getColumnType();
        IncrementallyUpdatedFilterPredicate.ValueInspector valueInspector = null;
        if (clazz2.equals(Integer.class)) {
            final int target = (Integer)pred.getValue();
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                @Override
                public void updateNull() {
                    this.setResult(false);
                }

                @Override
                public void update(int value2) {
                    this.setResult(value2 >= target);
                }
            };
        }
        if (clazz2.equals(Long.class)) {
            final long target = (Long)pred.getValue();
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                @Override
                public void updateNull() {
                    this.setResult(false);
                }

                @Override
                public void update(long value2) {
                    this.setResult(value2 >= target);
                }
            };
        }
        if (clazz2.equals(Boolean.class)) {
            throw new IllegalArgumentException("Operator >= not supported for Boolean");
        }
        if (clazz2.equals(Float.class)) {
            final float target = ((Float)pred.getValue()).floatValue();
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                @Override
                public void updateNull() {
                    this.setResult(false);
                }

                @Override
                public void update(float value2) {
                    this.setResult(value2 >= target);
                }
            };
        }
        if (clazz2.equals(Double.class)) {
            final double target = (Double)pred.getValue();
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                @Override
                public void updateNull() {
                    this.setResult(false);
                }

                @Override
                public void update(double value2) {
                    this.setResult(value2 >= target);
                }
            };
        }
        if (clazz2.equals(Binary.class)) {
            final Binary target = (Binary)pred.getValue();
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector(){

                @Override
                public void updateNull() {
                    this.setResult(false);
                }

                @Override
                public void update(Binary value2) {
                    this.setResult(value2.compareTo(target) >= 0);
                }
            };
        }
        if (valueInspector == null) {
            throw new IllegalArgumentException("Encountered unknown type " + clazz2);
        }
        this.addValueInspector(columnPath, valueInspector);
        return valueInspector;
    }

    @Override
    public <T extends Comparable<T>, U extends UserDefinedPredicate<T>> IncrementallyUpdatedFilterPredicate visit(Operators.UserDefined<T, U> pred) {
        ColumnPath columnPath = pred.getColumn().getColumnPath();
        Class<T> clazz2 = pred.getColumn().getColumnType();
        IncrementallyUpdatedFilterPredicate.ValueInspector valueInspector = null;
        U udp = pred.getUserDefinedPredicate();
        if (clazz2.equals(Integer.class)) {
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector((UserDefinedPredicate)udp){
                final /* synthetic */ UserDefinedPredicate val$udp;
                {
                    this.val$udp = userDefinedPredicate;
                }

                @Override
                public void updateNull() {
                    this.setResult(this.val$udp.keep(null));
                }

                @Override
                public void update(int value2) {
                    this.setResult(this.val$udp.keep(value2));
                }
            };
        }
        if (clazz2.equals(Long.class)) {
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector((UserDefinedPredicate)udp){
                final /* synthetic */ UserDefinedPredicate val$udp;
                {
                    this.val$udp = userDefinedPredicate;
                }

                @Override
                public void updateNull() {
                    this.setResult(this.val$udp.keep(null));
                }

                @Override
                public void update(long value2) {
                    this.setResult(this.val$udp.keep(value2));
                }
            };
        }
        if (clazz2.equals(Boolean.class)) {
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector((UserDefinedPredicate)udp){
                final /* synthetic */ UserDefinedPredicate val$udp;
                {
                    this.val$udp = userDefinedPredicate;
                }

                @Override
                public void updateNull() {
                    this.setResult(this.val$udp.keep(null));
                }

                @Override
                public void update(boolean value2) {
                    this.setResult(this.val$udp.keep(value2));
                }
            };
        }
        if (clazz2.equals(Float.class)) {
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector((UserDefinedPredicate)udp){
                final /* synthetic */ UserDefinedPredicate val$udp;
                {
                    this.val$udp = userDefinedPredicate;
                }

                @Override
                public void updateNull() {
                    this.setResult(this.val$udp.keep(null));
                }

                @Override
                public void update(float value2) {
                    this.setResult(this.val$udp.keep((Comparable)Float.valueOf(value2)));
                }
            };
        }
        if (clazz2.equals(Double.class)) {
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector((UserDefinedPredicate)udp){
                final /* synthetic */ UserDefinedPredicate val$udp;
                {
                    this.val$udp = userDefinedPredicate;
                }

                @Override
                public void updateNull() {
                    this.setResult(this.val$udp.keep(null));
                }

                @Override
                public void update(double value2) {
                    this.setResult(this.val$udp.keep(value2));
                }
            };
        }
        if (clazz2.equals(Binary.class)) {
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector((UserDefinedPredicate)udp){
                final /* synthetic */ UserDefinedPredicate val$udp;
                {
                    this.val$udp = userDefinedPredicate;
                }

                @Override
                public void updateNull() {
                    this.setResult(this.val$udp.keep(null));
                }

                @Override
                public void update(Binary value2) {
                    this.setResult(this.val$udp.keep((Comparable)value2));
                }
            };
        }
        if (valueInspector == null) {
            throw new IllegalArgumentException("Encountered unknown type " + clazz2);
        }
        this.addValueInspector(columnPath, valueInspector);
        return valueInspector;
    }

    @Override
    public <T extends Comparable<T>, U extends UserDefinedPredicate<T>> IncrementallyUpdatedFilterPredicate visit(Operators.LogicalNotUserDefined<T, U> notPred) {
        Operators.UserDefined<T, U> pred = notPred.getUserDefined();
        ColumnPath columnPath = pred.getColumn().getColumnPath();
        Class<T> clazz2 = pred.getColumn().getColumnType();
        IncrementallyUpdatedFilterPredicate.ValueInspector valueInspector = null;
        U udp = pred.getUserDefinedPredicate();
        if (clazz2.equals(Integer.class)) {
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector((UserDefinedPredicate)udp){
                final /* synthetic */ UserDefinedPredicate val$udp;
                {
                    this.val$udp = userDefinedPredicate;
                }

                @Override
                public void updateNull() {
                    this.setResult(!this.val$udp.keep(null));
                }

                @Override
                public void update(int value2) {
                    this.setResult(!this.val$udp.keep(value2));
                }
            };
        }
        if (clazz2.equals(Long.class)) {
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector((UserDefinedPredicate)udp){
                final /* synthetic */ UserDefinedPredicate val$udp;
                {
                    this.val$udp = userDefinedPredicate;
                }

                @Override
                public void updateNull() {
                    this.setResult(!this.val$udp.keep(null));
                }

                @Override
                public void update(long value2) {
                    this.setResult(!this.val$udp.keep(value2));
                }
            };
        }
        if (clazz2.equals(Boolean.class)) {
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector((UserDefinedPredicate)udp){
                final /* synthetic */ UserDefinedPredicate val$udp;
                {
                    this.val$udp = userDefinedPredicate;
                }

                @Override
                public void updateNull() {
                    this.setResult(!this.val$udp.keep(null));
                }

                @Override
                public void update(boolean value2) {
                    this.setResult(!this.val$udp.keep(value2));
                }
            };
        }
        if (clazz2.equals(Float.class)) {
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector((UserDefinedPredicate)udp){
                final /* synthetic */ UserDefinedPredicate val$udp;
                {
                    this.val$udp = userDefinedPredicate;
                }

                @Override
                public void updateNull() {
                    this.setResult(!this.val$udp.keep(null));
                }

                @Override
                public void update(float value2) {
                    this.setResult(!this.val$udp.keep((Comparable)Float.valueOf(value2)));
                }
            };
        }
        if (clazz2.equals(Double.class)) {
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector((UserDefinedPredicate)udp){
                final /* synthetic */ UserDefinedPredicate val$udp;
                {
                    this.val$udp = userDefinedPredicate;
                }

                @Override
                public void updateNull() {
                    this.setResult(!this.val$udp.keep(null));
                }

                @Override
                public void update(double value2) {
                    this.setResult(!this.val$udp.keep(value2));
                }
            };
        }
        if (clazz2.equals(Binary.class)) {
            valueInspector = new IncrementallyUpdatedFilterPredicate.ValueInspector((UserDefinedPredicate)udp){
                final /* synthetic */ UserDefinedPredicate val$udp;
                {
                    this.val$udp = userDefinedPredicate;
                }

                @Override
                public void updateNull() {
                    this.setResult(!this.val$udp.keep(null));
                }

                @Override
                public void update(Binary value2) {
                    this.setResult(!this.val$udp.keep((Comparable)value2));
                }
            };
        }
        if (valueInspector == null) {
            throw new IllegalArgumentException("Encountered unknown type " + clazz2);
        }
        this.addValueInspector(columnPath, valueInspector);
        return valueInspector;
    }
}

