/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.filter2.recordlevel;

import org.apache.parquet.Preconditions;
import org.apache.parquet.column.Dictionary;
import org.apache.parquet.filter2.recordlevel.IncrementallyUpdatedFilterPredicate;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.PrimitiveConverter;

public class FilteringPrimitiveConverter
extends PrimitiveConverter {
    private final PrimitiveConverter delegate;
    private final IncrementallyUpdatedFilterPredicate.ValueInspector[] valueInspectors;

    public FilteringPrimitiveConverter(PrimitiveConverter delegate, IncrementallyUpdatedFilterPredicate.ValueInspector[] valueInspectors) {
        this.delegate = Preconditions.checkNotNull(delegate, "delegate");
        this.valueInspectors = Preconditions.checkNotNull(valueInspectors, "valueInspectors");
    }

    @Override
    public boolean hasDictionarySupport() {
        return false;
    }

    @Override
    public void setDictionary(Dictionary dictionary) {
        throw new UnsupportedOperationException("FilteringPrimitiveConverter doesn't have dictionary support");
    }

    @Override
    public void addValueFromDictionary(int dictionaryId) {
        throw new UnsupportedOperationException("FilteringPrimitiveConverter doesn't have dictionary support");
    }

    @Override
    public void addBinary(Binary value2) {
        for (IncrementallyUpdatedFilterPredicate.ValueInspector valueInspector : this.valueInspectors) {
            valueInspector.update(value2);
        }
        this.delegate.addBinary(value2);
    }

    @Override
    public void addBoolean(boolean value2) {
        for (IncrementallyUpdatedFilterPredicate.ValueInspector valueInspector : this.valueInspectors) {
            valueInspector.update(value2);
        }
        this.delegate.addBoolean(value2);
    }

    @Override
    public void addDouble(double value2) {
        for (IncrementallyUpdatedFilterPredicate.ValueInspector valueInspector : this.valueInspectors) {
            valueInspector.update(value2);
        }
        this.delegate.addDouble(value2);
    }

    @Override
    public void addFloat(float value2) {
        for (IncrementallyUpdatedFilterPredicate.ValueInspector valueInspector : this.valueInspectors) {
            valueInspector.update(value2);
        }
        this.delegate.addFloat(value2);
    }

    @Override
    public void addInt(int value2) {
        for (IncrementallyUpdatedFilterPredicate.ValueInspector valueInspector : this.valueInspectors) {
            valueInspector.update(value2);
        }
        this.delegate.addInt(value2);
    }

    @Override
    public void addLong(long value2) {
        for (IncrementallyUpdatedFilterPredicate.ValueInspector valueInspector : this.valueInspectors) {
            valueInspector.update(value2);
        }
        this.delegate.addLong(value2);
    }
}

