/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.filter2.predicate;

import java.io.Serializable;
import org.apache.parquet.Preconditions;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.filter2.predicate.UserDefinedPredicate;
import org.apache.parquet.hadoop.metadata.ColumnPath;
import org.apache.parquet.io.api.Binary;

public final class Operators {
    private Operators() {
    }

    public static final class LogicalNotUserDefined<T extends Comparable<T>, U extends UserDefinedPredicate<T>>
    implements FilterPredicate,
    Serializable {
        private final UserDefined<T, U> udp;
        private final String toString;

        LogicalNotUserDefined(UserDefined<T, U> userDefined) {
            this.udp = Preconditions.checkNotNull(userDefined, "userDefined");
            this.toString = "inverted(" + this.udp + ")";
        }

        public UserDefined<T, U> getUserDefined() {
            return this.udp;
        }

        @Override
        public <R> R accept(FilterPredicate.Visitor<R> visitor) {
            return visitor.visit(this);
        }

        public String toString() {
            return this.toString;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LogicalNotUserDefined that = (LogicalNotUserDefined)o;
            return this.udp.equals(that.udp);
        }

        public int hashCode() {
            int result2 = this.udp.hashCode();
            result2 = result2 * 31 + this.getClass().hashCode();
            return result2;
        }
    }

    public static final class UserDefinedByInstance<T extends Comparable<T>, U extends UserDefinedPredicate<T>>
    extends UserDefined<T, U> {
        private final String toString;
        private final U udpInstance;

        UserDefinedByInstance(Column<T> column, U udpInstance) {
            super(column);
            this.udpInstance = (UserDefinedPredicate)Preconditions.checkNotNull(udpInstance, "udpInstance");
            String name2 = this.getClass().getSimpleName().toLowerCase();
            this.toString = name2 + "(" + column.getColumnPath().toDotString() + ", " + udpInstance + ")";
        }

        @Override
        public U getUserDefinedPredicate() {
            return this.udpInstance;
        }

        public String toString() {
            return this.toString;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UserDefinedByInstance that = (UserDefinedByInstance)o;
            if (!this.column.equals(that.column)) {
                return false;
            }
            return this.udpInstance.equals(that.udpInstance);
        }

        public int hashCode() {
            int result2 = this.column.hashCode();
            result2 = 31 * result2 + this.udpInstance.hashCode();
            result2 = result2 * 31 + this.getClass().hashCode();
            return result2;
        }
    }

    public static final class UserDefinedByClass<T extends Comparable<T>, U extends UserDefinedPredicate<T>>
    extends UserDefined<T, U> {
        private final Class<U> udpClass;
        private final String toString;
        private static final String INSTANTIATION_ERROR_MESSAGE = "Could not instantiate custom filter: %s. User defined predicates must be static classes with a default constructor.";

        UserDefinedByClass(Column<T> column, Class<U> udpClass) {
            super(column);
            this.udpClass = Preconditions.checkNotNull(udpClass, "udpClass");
            String name2 = this.getClass().getSimpleName().toLowerCase();
            this.toString = name2 + "(" + column.getColumnPath().toDotString() + ", " + udpClass.getName() + ")";
            this.getUserDefinedPredicate();
        }

        public Class<U> getUserDefinedPredicateClass() {
            return this.udpClass;
        }

        @Override
        public U getUserDefinedPredicate() {
            try {
                return (U)((UserDefinedPredicate)this.udpClass.newInstance());
            }
            catch (InstantiationException e) {
                throw new RuntimeException(String.format(INSTANTIATION_ERROR_MESSAGE, this.udpClass), e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(String.format(INSTANTIATION_ERROR_MESSAGE, this.udpClass), e);
            }
        }

        public String toString() {
            return this.toString;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UserDefinedByClass that = (UserDefinedByClass)o;
            if (!this.column.equals(that.column)) {
                return false;
            }
            return this.udpClass.equals(that.udpClass);
        }

        public int hashCode() {
            int result2 = this.column.hashCode();
            result2 = 31 * result2 + this.udpClass.hashCode();
            result2 = result2 * 31 + this.getClass().hashCode();
            return result2;
        }
    }

    public static abstract class UserDefined<T extends Comparable<T>, U extends UserDefinedPredicate<T>>
    implements FilterPredicate,
    Serializable {
        protected final Column<T> column;

        UserDefined(Column<T> column) {
            this.column = Preconditions.checkNotNull(column, "column");
        }

        public Column<T> getColumn() {
            return this.column;
        }

        public abstract U getUserDefinedPredicate();

        @Override
        public <R> R accept(FilterPredicate.Visitor<R> visitor) {
            return visitor.visit(this);
        }
    }

    public static class Not
    implements FilterPredicate,
    Serializable {
        private final FilterPredicate predicate;
        private final String toString;

        Not(FilterPredicate predicate) {
            this.predicate = Preconditions.checkNotNull(predicate, "predicate");
            this.toString = "not(" + predicate + ")";
        }

        public FilterPredicate getPredicate() {
            return this.predicate;
        }

        public String toString() {
            return this.toString;
        }

        @Override
        public <R> R accept(FilterPredicate.Visitor<R> visitor) {
            return visitor.visit(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Not not2 = (Not)o;
            return this.predicate.equals(not2.predicate);
        }

        public int hashCode() {
            return this.predicate.hashCode() * 31 + this.getClass().hashCode();
        }
    }

    public static final class Or
    extends BinaryLogicalFilterPredicate {
        Or(FilterPredicate left3, FilterPredicate right) {
            super(left3, right);
        }

        @Override
        public <R> R accept(FilterPredicate.Visitor<R> visitor) {
            return visitor.visit(this);
        }
    }

    public static final class And
    extends BinaryLogicalFilterPredicate {
        And(FilterPredicate left3, FilterPredicate right) {
            super(left3, right);
        }

        @Override
        public <R> R accept(FilterPredicate.Visitor<R> visitor) {
            return visitor.visit(this);
        }
    }

    private static abstract class BinaryLogicalFilterPredicate
    implements FilterPredicate,
    Serializable {
        private final FilterPredicate left;
        private final FilterPredicate right;
        private final String toString;

        protected BinaryLogicalFilterPredicate(FilterPredicate left3, FilterPredicate right) {
            this.left = Preconditions.checkNotNull(left3, "left");
            this.right = Preconditions.checkNotNull(right, "right");
            String name2 = this.getClass().getSimpleName().toLowerCase();
            this.toString = name2 + "(" + left3 + ", " + right + ")";
        }

        public FilterPredicate getLeft() {
            return this.left;
        }

        public FilterPredicate getRight() {
            return this.right;
        }

        public String toString() {
            return this.toString;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BinaryLogicalFilterPredicate that = (BinaryLogicalFilterPredicate)o;
            if (!this.left.equals(that.left)) {
                return false;
            }
            return this.right.equals(that.right);
        }

        public int hashCode() {
            int result2 = this.left.hashCode();
            result2 = 31 * result2 + this.right.hashCode();
            result2 = 31 * result2 + this.getClass().hashCode();
            return result2;
        }
    }

    public static final class GtEq<T extends Comparable<T>>
    extends ColumnFilterPredicate<T> {
        GtEq(Column<T> column, T value2) {
            super(column, (Comparable)Preconditions.checkNotNull(value2, "value"));
        }

        @Override
        public <R> R accept(FilterPredicate.Visitor<R> visitor) {
            return visitor.visit(this);
        }
    }

    public static final class Gt<T extends Comparable<T>>
    extends ColumnFilterPredicate<T> {
        Gt(Column<T> column, T value2) {
            super(column, (Comparable)Preconditions.checkNotNull(value2, "value"));
        }

        @Override
        public <R> R accept(FilterPredicate.Visitor<R> visitor) {
            return visitor.visit(this);
        }
    }

    public static final class LtEq<T extends Comparable<T>>
    extends ColumnFilterPredicate<T> {
        LtEq(Column<T> column, T value2) {
            super(column, (Comparable)Preconditions.checkNotNull(value2, "value"));
        }

        @Override
        public <R> R accept(FilterPredicate.Visitor<R> visitor) {
            return visitor.visit(this);
        }
    }

    public static final class Lt<T extends Comparable<T>>
    extends ColumnFilterPredicate<T> {
        Lt(Column<T> column, T value2) {
            super(column, (Comparable)Preconditions.checkNotNull(value2, "value"));
        }

        @Override
        public <R> R accept(FilterPredicate.Visitor<R> visitor) {
            return visitor.visit(this);
        }
    }

    public static final class NotEq<T extends Comparable<T>>
    extends ColumnFilterPredicate<T> {
        NotEq(Column<T> column, T value2) {
            super(column, value2);
        }

        @Override
        public <R> R accept(FilterPredicate.Visitor<R> visitor) {
            return visitor.visit(this);
        }
    }

    public static final class Eq<T extends Comparable<T>>
    extends ColumnFilterPredicate<T> {
        Eq(Column<T> column, T value2) {
            super(column, value2);
        }

        @Override
        public <R> R accept(FilterPredicate.Visitor<R> visitor) {
            return visitor.visit(this);
        }
    }

    static abstract class ColumnFilterPredicate<T extends Comparable<T>>
    implements FilterPredicate,
    Serializable {
        private final Column<T> column;
        private final T value;
        private final String toString;

        protected ColumnFilterPredicate(Column<T> column, T value2) {
            this.column = Preconditions.checkNotNull(column, "column");
            this.value = value2;
            String name2 = this.getClass().getSimpleName().toLowerCase();
            this.toString = name2 + "(" + column.getColumnPath().toDotString() + ", " + value2 + ")";
        }

        public Column<T> getColumn() {
            return this.column;
        }

        public T getValue() {
            return this.value;
        }

        public String toString() {
            return this.toString;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ColumnFilterPredicate that = (ColumnFilterPredicate)o;
            if (!this.column.equals(that.column)) {
                return false;
            }
            return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
        }

        public int hashCode() {
            int result2 = this.column.hashCode();
            result2 = 31 * result2 + (this.value != null ? this.value.hashCode() : 0);
            result2 = 31 * result2 + this.getClass().hashCode();
            return result2;
        }
    }

    public static final class BinaryColumn
    extends Column<Binary>
    implements SupportsLtGt {
        BinaryColumn(ColumnPath columnPath) {
            super(columnPath, Binary.class);
        }
    }

    public static final class BooleanColumn
    extends Column<Boolean>
    implements SupportsEqNotEq {
        BooleanColumn(ColumnPath columnPath) {
            super(columnPath, Boolean.class);
        }
    }

    public static final class FloatColumn
    extends Column<Float>
    implements SupportsLtGt {
        FloatColumn(ColumnPath columnPath) {
            super(columnPath, Float.class);
        }
    }

    public static final class DoubleColumn
    extends Column<Double>
    implements SupportsLtGt {
        DoubleColumn(ColumnPath columnPath) {
            super(columnPath, Double.class);
        }
    }

    public static final class LongColumn
    extends Column<Long>
    implements SupportsLtGt {
        LongColumn(ColumnPath columnPath) {
            super(columnPath, Long.class);
        }
    }

    public static final class IntColumn
    extends Column<Integer>
    implements SupportsLtGt {
        IntColumn(ColumnPath columnPath) {
            super(columnPath, Integer.class);
        }
    }

    public static interface SupportsLtGt
    extends SupportsEqNotEq {
    }

    public static interface SupportsEqNotEq {
    }

    public static abstract class Column<T extends Comparable<T>>
    implements Serializable {
        private final ColumnPath columnPath;
        private final Class<T> columnType;

        protected Column(ColumnPath columnPath, Class<T> columnType) {
            Preconditions.checkNotNull(columnPath, "columnPath");
            Preconditions.checkNotNull(columnType, "columnType");
            this.columnPath = columnPath;
            this.columnType = columnType;
        }

        public Class<T> getColumnType() {
            return this.columnType;
        }

        public ColumnPath getColumnPath() {
            return this.columnPath;
        }

        public String toString() {
            return "column(" + this.columnPath.toDotString() + ")";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Column column = (Column)o;
            if (!this.columnType.equals(column.columnType)) {
                return false;
            }
            return this.columnPath.equals(column.columnPath);
        }

        public int hashCode() {
            int result2 = this.columnPath.hashCode();
            result2 = 31 * result2 + this.columnType.hashCode();
            return result2;
        }
    }
}

