/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.filter2.predicate;

import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.filter2.predicate.Operators;
import org.apache.parquet.filter2.predicate.UserDefinedPredicate;
import org.apache.parquet.hadoop.metadata.ColumnPath;

public final class FilterApi {
    private FilterApi() {
    }

    public static Operators.IntColumn intColumn(String columnPath) {
        return new Operators.IntColumn(ColumnPath.fromDotString(columnPath));
    }

    public static Operators.LongColumn longColumn(String columnPath) {
        return new Operators.LongColumn(ColumnPath.fromDotString(columnPath));
    }

    public static Operators.FloatColumn floatColumn(String columnPath) {
        return new Operators.FloatColumn(ColumnPath.fromDotString(columnPath));
    }

    public static Operators.DoubleColumn doubleColumn(String columnPath) {
        return new Operators.DoubleColumn(ColumnPath.fromDotString(columnPath));
    }

    public static Operators.BooleanColumn booleanColumn(String columnPath) {
        return new Operators.BooleanColumn(ColumnPath.fromDotString(columnPath));
    }

    public static Operators.BinaryColumn binaryColumn(String columnPath) {
        return new Operators.BinaryColumn(ColumnPath.fromDotString(columnPath));
    }

    public static <T extends Comparable<T>, C extends Operators.Column<T>> Operators.Eq<T> eq(C column, T value2) {
        return new Operators.Eq<T>(column, value2);
    }

    public static <T extends Comparable<T>, C extends Operators.Column<T>> Operators.NotEq<T> notEq(C column, T value2) {
        return new Operators.NotEq<T>(column, value2);
    }

    public static <T extends Comparable<T>, C extends Operators.Column<T>> Operators.Lt<T> lt(C column, T value2) {
        return new Operators.Lt<T>(column, value2);
    }

    public static <T extends Comparable<T>, C extends Operators.Column<T>> Operators.LtEq<T> ltEq(C column, T value2) {
        return new Operators.LtEq<T>(column, value2);
    }

    public static <T extends Comparable<T>, C extends Operators.Column<T>> Operators.Gt<T> gt(C column, T value2) {
        return new Operators.Gt<T>(column, value2);
    }

    public static <T extends Comparable<T>, C extends Operators.Column<T>> Operators.GtEq<T> gtEq(C column, T value2) {
        return new Operators.GtEq<T>(column, value2);
    }

    public static <T extends Comparable<T>, U extends UserDefinedPredicate<T>> Operators.UserDefined<T, U> userDefined(Operators.Column<T> column, Class<U> clazz2) {
        return new Operators.UserDefinedByClass<T, U>(column, clazz2);
    }

    public static <T extends Comparable<T>, U extends UserDefinedPredicate<T>> Operators.UserDefined<T, U> userDefined(Operators.Column<T> column, U udp) {
        return new Operators.UserDefinedByInstance<T, U>(column, udp);
    }

    public static FilterPredicate and(FilterPredicate left3, FilterPredicate right) {
        return new Operators.And(left3, right);
    }

    public static FilterPredicate or(FilterPredicate left3, FilterPredicate right) {
        return new Operators.Or(left3, right);
    }

    public static FilterPredicate not(FilterPredicate predicate) {
        return new Operators.Not(predicate);
    }
}

