/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.filter;

import org.apache.parquet.Preconditions;
import org.apache.parquet.column.ColumnReader;
import org.apache.parquet.io.api.Binary;

public class ColumnPredicates {
    public static Predicate equalTo(final String target) {
        Preconditions.checkNotNull(target, "target");
        return new Predicate(){

            @Override
            public boolean apply(ColumnReader input2) {
                return target.equals(input2.getBinary().toStringUsingUTF8());
            }
        };
    }

    public static Predicate applyFunctionToString(final PredicateFunction<String> fn2) {
        return new Predicate(){

            @Override
            public boolean apply(ColumnReader input2) {
                return fn2.functionToApply(input2.getBinary().toStringUsingUTF8());
            }
        };
    }

    public static Predicate equalTo(final int target) {
        return new Predicate(){

            @Override
            public boolean apply(ColumnReader input2) {
                return input2.getInteger() == target;
            }
        };
    }

    public static Predicate applyFunctionToInteger(final IntegerPredicateFunction fn2) {
        return new Predicate(){

            @Override
            public boolean apply(ColumnReader input2) {
                return fn2.functionToApply(input2.getInteger());
            }
        };
    }

    public static Predicate equalTo(final long target) {
        return new Predicate(){

            @Override
            public boolean apply(ColumnReader input2) {
                return input2.getLong() == target;
            }
        };
    }

    public static Predicate applyFunctionToLong(final LongPredicateFunction fn2) {
        return new Predicate(){

            @Override
            public boolean apply(ColumnReader input2) {
                return fn2.functionToApply(input2.getLong());
            }
        };
    }

    public static Predicate equalTo(final float target) {
        return new Predicate(){

            @Override
            public boolean apply(ColumnReader input2) {
                return input2.getFloat() == target;
            }
        };
    }

    public static Predicate applyFunctionToFloat(final FloatPredicateFunction fn2) {
        return new Predicate(){

            @Override
            public boolean apply(ColumnReader input2) {
                return fn2.functionToApply(input2.getFloat());
            }
        };
    }

    public static Predicate equalTo(final double target) {
        return new Predicate(){

            @Override
            public boolean apply(ColumnReader input2) {
                return input2.getDouble() == target;
            }
        };
    }

    public static Predicate applyFunctionToDouble(final DoublePredicateFunction fn2) {
        return new Predicate(){

            @Override
            public boolean apply(ColumnReader input2) {
                return fn2.functionToApply(input2.getDouble());
            }
        };
    }

    public static Predicate equalTo(final boolean target) {
        return new Predicate(){

            @Override
            public boolean apply(ColumnReader input2) {
                return input2.getBoolean() == target;
            }
        };
    }

    public static Predicate applyFunctionToBoolean(final BooleanPredicateFunction fn2) {
        return new Predicate(){

            @Override
            public boolean apply(ColumnReader input2) {
                return fn2.functionToApply(input2.getBoolean());
            }
        };
    }

    public static <E extends Enum> Predicate equalTo(E target) {
        Preconditions.checkNotNull(target, "target");
        final String targetAsString = target.name();
        return new Predicate(){

            @Override
            public boolean apply(ColumnReader input2) {
                return targetAsString.equals(input2.getBinary().toStringUsingUTF8());
            }
        };
    }

    public static Predicate applyFunctionToBinary(final PredicateFunction<Binary> fn2) {
        return new Predicate(){

            @Override
            public boolean apply(ColumnReader input2) {
                return fn2.functionToApply(input2.getBinary());
            }
        };
    }

    public static interface BooleanPredicateFunction {
        public boolean functionToApply(boolean var1);
    }

    public static interface DoublePredicateFunction {
        public boolean functionToApply(double var1);
    }

    public static interface FloatPredicateFunction {
        public boolean functionToApply(float var1);
    }

    public static interface LongPredicateFunction {
        public boolean functionToApply(long var1);
    }

    public static interface IntegerPredicateFunction {
        public boolean functionToApply(int var1);
    }

    public static interface PredicateFunction<T> {
        public boolean functionToApply(T var1);
    }

    public static interface Predicate {
        public boolean apply(ColumnReader var1);
    }
}

