/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.example.data.simple;

import java.util.ArrayList;
import java.util.List;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.example.data.simple.BinaryValue;
import org.apache.parquet.example.data.simple.BooleanValue;
import org.apache.parquet.example.data.simple.DoubleValue;
import org.apache.parquet.example.data.simple.FloatValue;
import org.apache.parquet.example.data.simple.Int96Value;
import org.apache.parquet.example.data.simple.IntegerValue;
import org.apache.parquet.example.data.simple.LongValue;
import org.apache.parquet.example.data.simple.NanoTime;
import org.apache.parquet.example.data.simple.Primitive;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.RecordConsumer;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.Type;

public class SimpleGroup
extends Group {
    private final GroupType schema;
    private final List<Object>[] data;

    public SimpleGroup(GroupType schema) {
        this.schema = schema;
        this.data = new List[schema.getFields().size()];
        for (int i = 0; i < schema.getFieldCount(); ++i) {
            this.data[i] = new ArrayList<Object>();
        }
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent2) {
        String result2 = "";
        int i = 0;
        for (Type field2 : this.schema.getFields()) {
            String name2 = field2.getName();
            List<Object> values2 = this.data[i];
            ++i;
            if (values2 == null || values2.size() <= 0) continue;
            for (Object value2 : values2) {
                result2 = result2 + indent2 + name2;
                if (value2 == null) {
                    result2 = result2 + ": NULL\n";
                    continue;
                }
                if (value2 instanceof Group) {
                    result2 = result2 + "\n" + ((SimpleGroup)value2).toString(indent2 + "  ");
                    continue;
                }
                result2 = result2 + ": " + value2.toString() + "\n";
            }
        }
        return result2;
    }

    @Override
    public Group addGroup(int fieldIndex) {
        SimpleGroup g = new SimpleGroup(this.schema.getType(fieldIndex).asGroupType());
        this.add(fieldIndex, (Group)g);
        return g;
    }

    @Override
    public Group getGroup(int fieldIndex, int index2) {
        return (Group)this.getValue(fieldIndex, index2);
    }

    private Object getValue(int fieldIndex, int index2) {
        List<Object> list2;
        try {
            list2 = this.data[fieldIndex];
        }
        catch (IndexOutOfBoundsException e) {
            throw new RuntimeException("not found " + fieldIndex + "(" + this.schema.getFieldName(fieldIndex) + ") in group:\n" + this);
        }
        try {
            return list2.get(index2);
        }
        catch (IndexOutOfBoundsException e) {
            throw new RuntimeException("not found " + fieldIndex + "(" + this.schema.getFieldName(fieldIndex) + ") element number " + index2 + " in group:\n" + this);
        }
    }

    private void add(int fieldIndex, Primitive value2) {
        Type type = this.schema.getType(fieldIndex);
        List<Object> list2 = this.data[fieldIndex];
        if (!type.isRepetition(Type.Repetition.REPEATED) && !list2.isEmpty()) {
            throw new IllegalStateException("field " + fieldIndex + " (" + type.getName() + ") can not have more than one value: " + list2);
        }
        list2.add(value2);
    }

    @Override
    public int getFieldRepetitionCount(int fieldIndex) {
        List<Object> list2 = this.data[fieldIndex];
        return list2 == null ? 0 : list2.size();
    }

    @Override
    public String getValueToString(int fieldIndex, int index2) {
        return String.valueOf(this.getValue(fieldIndex, index2));
    }

    @Override
    public String getString(int fieldIndex, int index2) {
        return ((BinaryValue)this.getValue(fieldIndex, index2)).getString();
    }

    @Override
    public int getInteger(int fieldIndex, int index2) {
        return ((IntegerValue)this.getValue(fieldIndex, index2)).getInteger();
    }

    @Override
    public long getLong(int fieldIndex, int index2) {
        return ((LongValue)this.getValue(fieldIndex, index2)).getLong();
    }

    @Override
    public double getDouble(int fieldIndex, int index2) {
        return ((DoubleValue)this.getValue(fieldIndex, index2)).getDouble();
    }

    @Override
    public float getFloat(int fieldIndex, int index2) {
        return ((FloatValue)this.getValue(fieldIndex, index2)).getFloat();
    }

    @Override
    public boolean getBoolean(int fieldIndex, int index2) {
        return ((BooleanValue)this.getValue(fieldIndex, index2)).getBoolean();
    }

    @Override
    public Binary getBinary(int fieldIndex, int index2) {
        return ((BinaryValue)this.getValue(fieldIndex, index2)).getBinary();
    }

    public NanoTime getTimeNanos(int fieldIndex, int index2) {
        return NanoTime.fromInt96((Int96Value)this.getValue(fieldIndex, index2));
    }

    @Override
    public Binary getInt96(int fieldIndex, int index2) {
        return ((Int96Value)this.getValue(fieldIndex, index2)).getInt96();
    }

    @Override
    public void add(int fieldIndex, int value2) {
        this.add(fieldIndex, new IntegerValue(value2));
    }

    @Override
    public void add(int fieldIndex, long value2) {
        this.add(fieldIndex, new LongValue(value2));
    }

    @Override
    public void add(int fieldIndex, String value2) {
        this.add(fieldIndex, new BinaryValue(Binary.fromString(value2)));
    }

    @Override
    public void add(int fieldIndex, NanoTime value2) {
        this.add(fieldIndex, value2.toInt96());
    }

    @Override
    public void add(int fieldIndex, boolean value2) {
        this.add(fieldIndex, new BooleanValue(value2));
    }

    @Override
    public void add(int fieldIndex, Binary value2) {
        switch (this.getType().getType(fieldIndex).asPrimitiveType().getPrimitiveTypeName()) {
            case BINARY: 
            case FIXED_LEN_BYTE_ARRAY: {
                this.add(fieldIndex, new BinaryValue(value2));
                break;
            }
            case INT96: {
                this.add(fieldIndex, new Int96Value(value2));
                break;
            }
            default: {
                throw new UnsupportedOperationException(this.getType().asPrimitiveType().getName() + " not supported for Binary");
            }
        }
    }

    @Override
    public void add(int fieldIndex, float value2) {
        this.add(fieldIndex, new FloatValue(value2));
    }

    @Override
    public void add(int fieldIndex, double value2) {
        this.add(fieldIndex, new DoubleValue(value2));
    }

    @Override
    public void add(int fieldIndex, Group value2) {
        this.data[fieldIndex].add(value2);
    }

    @Override
    public GroupType getType() {
        return this.schema;
    }

    @Override
    public void writeValue(int field2, int index2, RecordConsumer recordConsumer) {
        ((Primitive)this.getValue(field2, index2)).writeValue(recordConsumer);
    }
}

