/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.example.data;

import org.apache.parquet.example.data.Group;
import org.apache.parquet.io.api.RecordConsumer;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.Type;

public class GroupWriter {
    private final RecordConsumer recordConsumer;
    private final GroupType schema;

    public GroupWriter(RecordConsumer recordConsumer, GroupType schema) {
        this.recordConsumer = recordConsumer;
        this.schema = schema;
    }

    public void write(Group group2) {
        this.recordConsumer.startMessage();
        this.writeGroup(group2, this.schema);
        this.recordConsumer.endMessage();
    }

    private void writeGroup(Group group2, GroupType type) {
        int fieldCount = type.getFieldCount();
        for (int field2 = 0; field2 < fieldCount; ++field2) {
            int valueCount = group2.getFieldRepetitionCount(field2);
            if (valueCount <= 0) continue;
            Type fieldType = type.getType(field2);
            String fieldName = fieldType.getName();
            this.recordConsumer.startField(fieldName, field2);
            for (int index2 = 0; index2 < valueCount; ++index2) {
                if (fieldType.isPrimitive()) {
                    group2.writeValue(field2, index2, this.recordConsumer);
                    continue;
                }
                this.recordConsumer.startGroup();
                this.writeGroup(group2.getGroup(field2, index2), fieldType.asGroupType());
                this.recordConsumer.endGroup();
            }
            this.recordConsumer.endField(fieldName, field2);
        }
    }
}

