/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.column.values.bitpacking;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.parquet.Log;
import org.apache.parquet.bytes.BytesInput;
import org.apache.parquet.bytes.BytesUtils;
import org.apache.parquet.column.values.bitpacking.BytePacker;
import org.apache.parquet.column.values.bitpacking.Packer;

public class ByteBasedBitPackingEncoder {
    private static final Log LOG = Log.getLog(ByteBasedBitPackingEncoder.class);
    private static final int VALUES_WRITTEN_AT_A_TIME = 8;
    private final int bitWidth;
    private final BytePacker packer;
    private final int[] input = new int[8];
    private final int slabSize;
    private int inputSize;
    private byte[] packed;
    private int packedPosition;
    private final List<BytesInput> slabs = new ArrayList<BytesInput>();
    private int totalValues;

    public ByteBasedBitPackingEncoder(int bitWidth, Packer packer) {
        this.bitWidth = bitWidth;
        this.inputSize = 0;
        this.slabSize = bitWidth * 64 * 1024;
        this.initPackedSlab();
        this.packer = packer.newBytePacker(bitWidth);
    }

    public void writeInt(int value2) throws IOException {
        this.input[this.inputSize] = value2;
        ++this.inputSize;
        if (this.inputSize == 8) {
            this.pack();
            if (this.packedPosition == this.slabSize) {
                this.slabs.add(BytesInput.from(this.packed));
                this.initPackedSlab();
            }
        }
    }

    private void pack() {
        this.packer.pack8Values(this.input, 0, this.packed, this.packedPosition);
        this.packedPosition += this.bitWidth;
        this.totalValues += this.inputSize;
        this.inputSize = 0;
    }

    private void initPackedSlab() {
        this.packed = new byte[this.slabSize];
        this.packedPosition = 0;
    }

    public BytesInput toBytes() throws IOException {
        int packedByteLength = this.packedPosition + BytesUtils.paddedByteCountFromBits(this.inputSize * this.bitWidth);
        if (Log.DEBUG) {
            LOG.debug("writing " + (this.slabs.size() * this.slabSize + packedByteLength) + " bytes");
        }
        if (this.inputSize > 0) {
            for (int i = this.inputSize; i < this.input.length; ++i) {
                this.input[i] = 0;
            }
            this.pack();
        }
        return BytesInput.concat(BytesInput.concat(this.slabs), BytesInput.from(this.packed, 0, packedByteLength));
    }

    public long getBufferSize() {
        return BytesUtils.paddedByteCountFromBits(this.totalValues * this.bitWidth);
    }

    public long getAllocatedSize() {
        return this.slabs.size() * this.slabSize + this.packed.length + this.input.length * 4;
    }

    public String memUsageString(String prefix) {
        return String.format("%s ByteBitPacking %d slabs, %d bytes", prefix, this.slabs.size(), this.getAllocatedSize());
    }
}

