/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.column.values.bitpacking;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.parquet.column.values.bitpacking.BitPacking;

abstract class BaseBitPackingWriter
extends BitPacking.BitPackingWriter {
    BaseBitPackingWriter() {
    }

    void finish(int numberOfBits, int buffer2, OutputStream out) throws IOException {
        int padding2 = numberOfBits % 8 == 0 ? 0 : 8 - numberOfBits % 8;
        buffer2 <<= padding2;
        int numberOfBytes = (numberOfBits + padding2) / 8;
        for (int i = (numberOfBytes - 1) * 8; i >= 0; i -= 8) {
            out.write(buffer2 >>> i & 0xFF);
        }
    }

    void finish(int numberOfBits, long buffer2, OutputStream out) throws IOException {
        int padding2 = numberOfBits % 8 == 0 ? 0 : 8 - numberOfBits % 8;
        buffer2 <<= padding2;
        int numberOfBytes = (numberOfBits + padding2) / 8;
        for (int i = (numberOfBytes - 1) * 8; i >= 0; i -= 8) {
            out.write((int)(buffer2 >>> i) & 0xFF);
        }
    }
}

