/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.column.page;

import java.io.IOException;
import org.apache.parquet.Ints;
import org.apache.parquet.Preconditions;
import org.apache.parquet.bytes.BytesInput;
import org.apache.parquet.column.Encoding;
import org.apache.parquet.column.page.Page;

public class DictionaryPage
extends Page {
    private final BytesInput bytes;
    private final int dictionarySize;
    private final Encoding encoding;

    public DictionaryPage(BytesInput bytes2, int dictionarySize, Encoding encoding) {
        this(bytes2, (int)bytes2.size(), dictionarySize, encoding);
    }

    public DictionaryPage(BytesInput bytes2, int uncompressedSize, int dictionarySize, Encoding encoding) {
        super(Ints.checkedCast(bytes2.size()), uncompressedSize);
        this.bytes = Preconditions.checkNotNull(bytes2, "bytes");
        this.dictionarySize = dictionarySize;
        this.encoding = Preconditions.checkNotNull(encoding, "encoding");
    }

    public BytesInput getBytes() {
        return this.bytes;
    }

    public int getDictionarySize() {
        return this.dictionarySize;
    }

    public Encoding getEncoding() {
        return this.encoding;
    }

    public DictionaryPage copy() throws IOException {
        return new DictionaryPage(BytesInput.copy(this.bytes), this.getUncompressedSize(), this.dictionarySize, this.encoding);
    }

    public String toString() {
        return "Page [bytes.size=" + this.bytes.size() + ", entryCount=" + this.dictionarySize + ", uncompressedSize=" + this.getUncompressedSize() + ", encoding=" + (Object)((Object)this.encoding) + "]";
    }
}

