/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.column.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.ColumnWriteStore;
import org.apache.parquet.column.ColumnWriter;
import org.apache.parquet.column.ParquetProperties;
import org.apache.parquet.column.impl.ColumnWriterV1;
import org.apache.parquet.column.page.PageWriteStore;
import org.apache.parquet.column.page.PageWriter;

public class ColumnWriteStoreV1
implements ColumnWriteStore {
    private final Map<ColumnDescriptor, ColumnWriterV1> columns = new TreeMap<ColumnDescriptor, ColumnWriterV1>();
    private final PageWriteStore pageWriteStore;
    private final int pageSizeThreshold;
    private final int dictionaryPageSizeThreshold;
    private final boolean enableDictionary;
    private final ParquetProperties.WriterVersion writerVersion;

    public ColumnWriteStoreV1(PageWriteStore pageWriteStore, int pageSizeThreshold, int dictionaryPageSizeThreshold, boolean enableDictionary, ParquetProperties.WriterVersion writerVersion) {
        this.pageWriteStore = pageWriteStore;
        this.pageSizeThreshold = pageSizeThreshold;
        this.dictionaryPageSizeThreshold = dictionaryPageSizeThreshold;
        this.enableDictionary = enableDictionary;
        this.writerVersion = writerVersion;
    }

    @Override
    public ColumnWriter getColumnWriter(ColumnDescriptor path) {
        ColumnWriterV1 column = this.columns.get(path);
        if (column == null) {
            column = this.newMemColumn(path);
            this.columns.put(path, column);
        }
        return column;
    }

    public Set<ColumnDescriptor> getColumnDescriptors() {
        return this.columns.keySet();
    }

    private ColumnWriterV1 newMemColumn(ColumnDescriptor path) {
        PageWriter pageWriter = this.pageWriteStore.getPageWriter(path);
        return new ColumnWriterV1(path, pageWriter, this.pageSizeThreshold, this.dictionaryPageSizeThreshold, this.enableDictionary, this.writerVersion);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<ColumnDescriptor, ColumnWriterV1> entry2 : this.columns.entrySet()) {
            sb.append(Arrays.toString(entry2.getKey().getPath())).append(": ");
            sb.append(entry2.getValue().getBufferedSizeInMemory()).append(" bytes");
            sb.append("\n");
        }
        return sb.toString();
    }

    @Override
    public long getAllocatedSize() {
        Collection<ColumnWriterV1> values2 = this.columns.values();
        long total2 = 0L;
        for (ColumnWriterV1 memColumn : values2) {
            total2 += memColumn.allocatedSize();
        }
        return total2;
    }

    @Override
    public long getBufferedSize() {
        Collection<ColumnWriterV1> values2 = this.columns.values();
        long total2 = 0L;
        for (ColumnWriterV1 memColumn : values2) {
            total2 += memColumn.getBufferedSizeInMemory();
        }
        return total2;
    }

    @Override
    public String memUsageString() {
        StringBuilder b = new StringBuilder("Store {\n");
        Collection<ColumnWriterV1> values2 = this.columns.values();
        for (ColumnWriterV1 memColumn : values2) {
            b.append(memColumn.memUsageString(" "));
        }
        b.append("}\n");
        return b.toString();
    }

    public long maxColMemSize() {
        Collection<ColumnWriterV1> values2 = this.columns.values();
        long max2 = 0L;
        for (ColumnWriterV1 memColumn : values2) {
            max2 = Math.max(max2, memColumn.getBufferedSizeInMemory());
        }
        return max2;
    }

    @Override
    public void flush() {
        Collection<ColumnWriterV1> values2 = this.columns.values();
        for (ColumnWriterV1 memColumn : values2) {
            memColumn.flush();
        }
    }

    @Override
    public void endRecord() {
    }
}

