/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet;

public final class Preconditions {
    private Preconditions() {
    }

    public static <T> T checkNotNull(T o, String name2) throws NullPointerException {
        if (o == null) {
            throw new NullPointerException(name2 + " should not be null");
        }
        return o;
    }

    public static void checkArgument(boolean isValid2, String message) throws IllegalArgumentException {
        if (!isValid2) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void checkArgument(boolean isValid2, String message, Object ... args2) throws IllegalArgumentException {
        if (!isValid2) {
            throw new IllegalArgumentException(String.format(String.valueOf(message), Preconditions.strings(args2)));
        }
    }

    public static void checkState(boolean isValid2, String message) throws IllegalStateException {
        if (!isValid2) {
            throw new IllegalStateException(message);
        }
    }

    public static void checkState(boolean isValid2, String message, Object ... args2) throws IllegalStateException {
        if (!isValid2) {
            throw new IllegalStateException(String.format(String.valueOf(message), Preconditions.strings(args2)));
        }
    }

    private static String[] strings(Object[] objects) {
        String[] strings = new String[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            strings[i] = String.valueOf(objects[i]);
        }
        return strings;
    }
}

