/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.rewrite;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.apache.log4j.rewrite.RewritePolicy;
import org.apache.log4j.spi.LoggingEvent;

public class PropertyRewritePolicy
implements RewritePolicy {
    private Map properties = Collections.EMPTY_MAP;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperties(String props) {
        HashMap<String, String> hashTable = new HashMap<String, String>();
        StringTokenizer pairs2 = new StringTokenizer(props, ",");
        while (pairs2.hasMoreTokens()) {
            StringTokenizer entry2 = new StringTokenizer(pairs2.nextToken(), "=");
            hashTable.put(entry2.nextElement().toString().trim(), entry2.nextElement().toString().trim());
        }
        PropertyRewritePolicy propertyRewritePolicy = this;
        synchronized (propertyRewritePolicy) {
            this.properties = hashTable;
        }
    }

    public LoggingEvent rewrite(LoggingEvent source2) {
        if (!this.properties.isEmpty()) {
            HashMap rewriteProps = new HashMap(source2.getProperties());
            Iterator iter2 = this.properties.entrySet().iterator();
            while (iter2.hasNext()) {
                Map.Entry entry2 = iter2.next();
                if (rewriteProps.containsKey(entry2.getKey())) continue;
                rewriteProps.put(entry2.getKey(), entry2.getValue());
            }
            return new LoggingEvent(source2.getFQNOfLoggerClass(), source2.getLogger() != null ? source2.getLogger() : Logger.getLogger(source2.getLoggerName()), source2.getTimeStamp(), source2.getLevel(), source2.getMessage(), source2.getThreadName(), source2.getThrowableInformation(), source2.getNDC(), source2.getLocationInformation(), rewriteProps);
        }
        return source2;
    }
}

