/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.message;

import org.apache.http.HeaderElement;
import org.apache.http.NameValuePair;
import org.apache.http.annotation.Immutable;
import org.apache.http.message.HeaderValueFormatter;
import org.apache.http.util.Args;
import org.apache.http.util.CharArrayBuffer;

@Immutable
public class BasicHeaderValueFormatter
implements HeaderValueFormatter {
    @Deprecated
    public static final BasicHeaderValueFormatter DEFAULT = new BasicHeaderValueFormatter();
    public static final BasicHeaderValueFormatter INSTANCE = new BasicHeaderValueFormatter();
    public static final String SEPARATORS = " ;,:@()<>\\\"/[]?={}\t";
    public static final String UNSAFE_CHARS = "\"\\";

    public static String formatElements(HeaderElement[] elems, boolean quote, HeaderValueFormatter formatter) {
        return (formatter != null ? formatter : INSTANCE).formatElements(null, elems, quote).toString();
    }

    @Override
    public CharArrayBuffer formatElements(CharArrayBuffer charBuffer, HeaderElement[] elems, boolean quote) {
        Args.notNull(elems, "Header element array");
        int len = this.estimateElementsLen(elems);
        CharArrayBuffer buffer2 = charBuffer;
        if (buffer2 == null) {
            buffer2 = new CharArrayBuffer(len);
        } else {
            buffer2.ensureCapacity(len);
        }
        for (int i = 0; i < elems.length; ++i) {
            if (i > 0) {
                buffer2.append(", ");
            }
            this.formatHeaderElement(buffer2, elems[i], quote);
        }
        return buffer2;
    }

    protected int estimateElementsLen(HeaderElement[] elems) {
        if (elems == null || elems.length < 1) {
            return 0;
        }
        int result2 = (elems.length - 1) * 2;
        for (HeaderElement elem2 : elems) {
            result2 += this.estimateHeaderElementLen(elem2);
        }
        return result2;
    }

    public static String formatHeaderElement(HeaderElement elem2, boolean quote, HeaderValueFormatter formatter) {
        return (formatter != null ? formatter : INSTANCE).formatHeaderElement(null, elem2, quote).toString();
    }

    @Override
    public CharArrayBuffer formatHeaderElement(CharArrayBuffer charBuffer, HeaderElement elem2, boolean quote) {
        int parcnt;
        Args.notNull(elem2, "Header element");
        int len = this.estimateHeaderElementLen(elem2);
        CharArrayBuffer buffer2 = charBuffer;
        if (buffer2 == null) {
            buffer2 = new CharArrayBuffer(len);
        } else {
            buffer2.ensureCapacity(len);
        }
        buffer2.append(elem2.getName());
        String value2 = elem2.getValue();
        if (value2 != null) {
            buffer2.append('=');
            this.doFormatValue(buffer2, value2, quote);
        }
        if ((parcnt = elem2.getParameterCount()) > 0) {
            for (int i = 0; i < parcnt; ++i) {
                buffer2.append("; ");
                this.formatNameValuePair(buffer2, elem2.getParameter(i), quote);
            }
        }
        return buffer2;
    }

    protected int estimateHeaderElementLen(HeaderElement elem2) {
        int parcnt;
        if (elem2 == null) {
            return 0;
        }
        int result2 = elem2.getName().length();
        String value2 = elem2.getValue();
        if (value2 != null) {
            result2 += 3 + value2.length();
        }
        if ((parcnt = elem2.getParameterCount()) > 0) {
            for (int i = 0; i < parcnt; ++i) {
                result2 += 2 + this.estimateNameValuePairLen(elem2.getParameter(i));
            }
        }
        return result2;
    }

    public static String formatParameters(NameValuePair[] nvps, boolean quote, HeaderValueFormatter formatter) {
        return (formatter != null ? formatter : INSTANCE).formatParameters(null, nvps, quote).toString();
    }

    @Override
    public CharArrayBuffer formatParameters(CharArrayBuffer charBuffer, NameValuePair[] nvps, boolean quote) {
        Args.notNull(nvps, "Header parameter array");
        int len = this.estimateParametersLen(nvps);
        CharArrayBuffer buffer2 = charBuffer;
        if (buffer2 == null) {
            buffer2 = new CharArrayBuffer(len);
        } else {
            buffer2.ensureCapacity(len);
        }
        for (int i = 0; i < nvps.length; ++i) {
            if (i > 0) {
                buffer2.append("; ");
            }
            this.formatNameValuePair(buffer2, nvps[i], quote);
        }
        return buffer2;
    }

    protected int estimateParametersLen(NameValuePair[] nvps) {
        if (nvps == null || nvps.length < 1) {
            return 0;
        }
        int result2 = (nvps.length - 1) * 2;
        for (NameValuePair nvp : nvps) {
            result2 += this.estimateNameValuePairLen(nvp);
        }
        return result2;
    }

    public static String formatNameValuePair(NameValuePair nvp, boolean quote, HeaderValueFormatter formatter) {
        return (formatter != null ? formatter : INSTANCE).formatNameValuePair(null, nvp, quote).toString();
    }

    @Override
    public CharArrayBuffer formatNameValuePair(CharArrayBuffer charBuffer, NameValuePair nvp, boolean quote) {
        Args.notNull(nvp, "Name / value pair");
        int len = this.estimateNameValuePairLen(nvp);
        CharArrayBuffer buffer2 = charBuffer;
        if (buffer2 == null) {
            buffer2 = new CharArrayBuffer(len);
        } else {
            buffer2.ensureCapacity(len);
        }
        buffer2.append(nvp.getName());
        String value2 = nvp.getValue();
        if (value2 != null) {
            buffer2.append('=');
            this.doFormatValue(buffer2, value2, quote);
        }
        return buffer2;
    }

    protected int estimateNameValuePairLen(NameValuePair nvp) {
        if (nvp == null) {
            return 0;
        }
        int result2 = nvp.getName().length();
        String value2 = nvp.getValue();
        if (value2 != null) {
            result2 += 3 + value2.length();
        }
        return result2;
    }

    protected void doFormatValue(CharArrayBuffer buffer2, String value2, boolean quote) {
        int i;
        boolean quoteFlag = quote;
        if (!quoteFlag) {
            for (i = 0; i < value2.length() && !quoteFlag; ++i) {
                quoteFlag = this.isSeparator(value2.charAt(i));
            }
        }
        if (quoteFlag) {
            buffer2.append('\"');
        }
        for (i = 0; i < value2.length(); ++i) {
            char ch = value2.charAt(i);
            if (this.isUnsafe(ch)) {
                buffer2.append('\\');
            }
            buffer2.append(ch);
        }
        if (quoteFlag) {
            buffer2.append('\"');
        }
    }

    protected boolean isSeparator(char ch) {
        return SEPARATORS.indexOf(ch) >= 0;
    }

    protected boolean isUnsafe(char ch) {
        return UNSAFE_CHARS.indexOf(ch) >= 0;
    }
}

