/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.message;

import org.apache.http.HeaderElement;
import org.apache.http.NameValuePair;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.util.Args;
import org.apache.http.util.LangUtils;

@NotThreadSafe
public class BasicHeaderElement
implements HeaderElement,
Cloneable {
    private final String name;
    private final String value;
    private final NameValuePair[] parameters;

    public BasicHeaderElement(String name2, String value2, NameValuePair[] parameters) {
        this.name = Args.notNull(name2, "Name");
        this.value = value2;
        this.parameters = parameters != null ? parameters : new NameValuePair[0];
    }

    public BasicHeaderElement(String name2, String value2) {
        this(name2, value2, null);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public NameValuePair[] getParameters() {
        return (NameValuePair[])this.parameters.clone();
    }

    @Override
    public int getParameterCount() {
        return this.parameters.length;
    }

    @Override
    public NameValuePair getParameter(int index2) {
        return this.parameters[index2];
    }

    @Override
    public NameValuePair getParameterByName(String name2) {
        Args.notNull(name2, "Name");
        NameValuePair found = null;
        for (NameValuePair current : this.parameters) {
            if (!current.getName().equalsIgnoreCase(name2)) continue;
            found = current;
            break;
        }
        return found;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof HeaderElement) {
            BasicHeaderElement that = (BasicHeaderElement)object;
            return this.name.equals(that.name) && LangUtils.equals(this.value, that.value) && LangUtils.equals(this.parameters, that.parameters);
        }
        return false;
    }

    public int hashCode() {
        int hash2 = 17;
        hash2 = LangUtils.hashCode(hash2, this.name);
        hash2 = LangUtils.hashCode(hash2, this.value);
        for (NameValuePair parameter : this.parameters) {
            hash2 = LangUtils.hashCode(hash2, parameter);
        }
        return hash2;
    }

    public String toString() {
        StringBuilder buffer2 = new StringBuilder();
        buffer2.append(this.name);
        if (this.value != null) {
            buffer2.append("=");
            buffer2.append(this.value);
        }
        for (NameValuePair parameter : this.parameters) {
            buffer2.append("; ");
            buffer2.append(parameter);
        }
        return buffer2.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

