/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.cookie;

import java.util.ArrayList;
import java.util.List;
import org.apache.http.FormattedHeader;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.annotation.Obsolete;
import org.apache.http.annotation.ThreadSafe;
import org.apache.http.cookie.CommonCookieAttributeHandler;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.MalformedCookieException;
import org.apache.http.impl.cookie.BasicCommentHandler;
import org.apache.http.impl.cookie.BasicExpiresHandler;
import org.apache.http.impl.cookie.BasicPathHandler;
import org.apache.http.impl.cookie.BasicSecureHandler;
import org.apache.http.impl.cookie.CookieSpecBase;
import org.apache.http.impl.cookie.NetscapeDomainHandler;
import org.apache.http.impl.cookie.NetscapeDraftHeaderParser;
import org.apache.http.message.BufferedHeader;
import org.apache.http.message.ParserCursor;
import org.apache.http.util.Args;
import org.apache.http.util.CharArrayBuffer;

@Obsolete
@ThreadSafe
public class NetscapeDraftSpec
extends CookieSpecBase {
    protected static final String EXPIRES_PATTERN = "EEE, dd-MMM-yy HH:mm:ss z";

    public NetscapeDraftSpec(String[] datepatterns) {
        String[] stringArray;
        CommonCookieAttributeHandler[] commonCookieAttributeHandlerArray = new CommonCookieAttributeHandler[5];
        commonCookieAttributeHandlerArray[0] = new BasicPathHandler();
        commonCookieAttributeHandlerArray[1] = new NetscapeDomainHandler();
        commonCookieAttributeHandlerArray[2] = new BasicSecureHandler();
        commonCookieAttributeHandlerArray[3] = new BasicCommentHandler();
        if (datepatterns != null) {
            stringArray = (String[])datepatterns.clone();
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = EXPIRES_PATTERN;
        }
        commonCookieAttributeHandlerArray[4] = new BasicExpiresHandler(stringArray);
        super(commonCookieAttributeHandlerArray);
    }

    NetscapeDraftSpec(CommonCookieAttributeHandler ... handlers2) {
        super(handlers2);
    }

    public NetscapeDraftSpec() {
        this((String[])null);
    }

    @Override
    public List<Cookie> parse(Header header, CookieOrigin origin2) throws MalformedCookieException {
        ParserCursor cursor;
        CharArrayBuffer buffer2;
        Args.notNull(header, "Header");
        Args.notNull(origin2, "Cookie origin");
        if (!header.getName().equalsIgnoreCase("Set-Cookie")) {
            throw new MalformedCookieException("Unrecognized cookie header '" + header.toString() + "'");
        }
        NetscapeDraftHeaderParser parser = NetscapeDraftHeaderParser.DEFAULT;
        if (header instanceof FormattedHeader) {
            buffer2 = ((FormattedHeader)header).getBuffer();
            cursor = new ParserCursor(((FormattedHeader)header).getValuePos(), buffer2.length());
        } else {
            String s2 = header.getValue();
            if (s2 == null) {
                throw new MalformedCookieException("Header value is null");
            }
            buffer2 = new CharArrayBuffer(s2.length());
            buffer2.append(s2);
            cursor = new ParserCursor(0, buffer2.length());
        }
        return this.parse(new HeaderElement[]{parser.parseHeader(buffer2, cursor)}, origin2);
    }

    @Override
    public List<Header> formatCookies(List<Cookie> cookies) {
        Args.notEmpty(cookies, "List of cookies");
        CharArrayBuffer buffer2 = new CharArrayBuffer(20 * cookies.size());
        buffer2.append("Cookie");
        buffer2.append(": ");
        for (int i = 0; i < cookies.size(); ++i) {
            Cookie cookie = cookies.get(i);
            if (i > 0) {
                buffer2.append("; ");
            }
            buffer2.append(cookie.getName());
            String s2 = cookie.getValue();
            if (s2 == null) continue;
            buffer2.append("=");
            buffer2.append(s2);
        }
        ArrayList<Header> headers = new ArrayList<Header>(1);
        headers.add(new BufferedHeader(buffer2));
        return headers;
    }

    @Override
    public int getVersion() {
        return 0;
    }

    @Override
    public Header getVersionHeader() {
        return null;
    }

    public String toString() {
        return "netscape";
    }
}

