/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.cookie;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.cookie.ClientCookie;
import org.apache.http.cookie.SetCookie;
import org.apache.http.util.Args;

@NotThreadSafe
public class BasicClientCookie
implements SetCookie,
ClientCookie,
Cloneable,
Serializable {
    private static final long serialVersionUID = -3869795591041535538L;
    private final String name;
    private Map<String, String> attribs;
    private String value;
    private String cookieComment;
    private String cookieDomain;
    private Date cookieExpiryDate;
    private String cookiePath;
    private boolean isSecure;
    private int cookieVersion;
    private Date creationDate;

    public BasicClientCookie(String name2, String value2) {
        Args.notNull(name2, "Name");
        this.name = name2;
        this.attribs = new HashMap<String, String>();
        this.value = value2;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String value2) {
        this.value = value2;
    }

    @Override
    public String getComment() {
        return this.cookieComment;
    }

    @Override
    public void setComment(String comment2) {
        this.cookieComment = comment2;
    }

    @Override
    public String getCommentURL() {
        return null;
    }

    @Override
    public Date getExpiryDate() {
        return this.cookieExpiryDate;
    }

    @Override
    public void setExpiryDate(Date expiryDate) {
        this.cookieExpiryDate = expiryDate;
    }

    @Override
    public boolean isPersistent() {
        return null != this.cookieExpiryDate;
    }

    @Override
    public String getDomain() {
        return this.cookieDomain;
    }

    @Override
    public void setDomain(String domain) {
        this.cookieDomain = domain != null ? domain.toLowerCase(Locale.ROOT) : null;
    }

    @Override
    public String getPath() {
        return this.cookiePath;
    }

    @Override
    public void setPath(String path) {
        this.cookiePath = path;
    }

    @Override
    public boolean isSecure() {
        return this.isSecure;
    }

    @Override
    public void setSecure(boolean secure) {
        this.isSecure = secure;
    }

    @Override
    public int[] getPorts() {
        return null;
    }

    @Override
    public int getVersion() {
        return this.cookieVersion;
    }

    @Override
    public void setVersion(int version) {
        this.cookieVersion = version;
    }

    @Override
    public boolean isExpired(Date date) {
        Args.notNull(date, "Date");
        return this.cookieExpiryDate != null && this.cookieExpiryDate.getTime() <= date.getTime();
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public void setAttribute(String name2, String value2) {
        this.attribs.put(name2, value2);
    }

    @Override
    public String getAttribute(String name2) {
        return this.attribs.get(name2);
    }

    @Override
    public boolean containsAttribute(String name2) {
        return this.attribs.containsKey(name2);
    }

    public boolean removeAttribute(String name2) {
        return this.attribs.remove(name2) != null;
    }

    public Object clone() throws CloneNotSupportedException {
        BasicClientCookie clone2 = (BasicClientCookie)super.clone();
        clone2.attribs = new HashMap<String, String>(this.attribs);
        return clone2;
    }

    public String toString() {
        StringBuilder buffer2 = new StringBuilder();
        buffer2.append("[version: ");
        buffer2.append(Integer.toString(this.cookieVersion));
        buffer2.append("]");
        buffer2.append("[name: ");
        buffer2.append(this.name);
        buffer2.append("]");
        buffer2.append("[value: ");
        buffer2.append(this.value);
        buffer2.append("]");
        buffer2.append("[domain: ");
        buffer2.append(this.cookieDomain);
        buffer2.append("]");
        buffer2.append("[path: ");
        buffer2.append(this.cookiePath);
        buffer2.append("]");
        buffer2.append("[expiry: ");
        buffer2.append(this.cookieExpiryDate);
        buffer2.append("]");
        return buffer2.toString();
    }
}

