/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging.impl;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogConfigurationException;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.SLF4JLocationAwareLog;
import org.apache.commons.logging.impl.SLF4JLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.spi.LocationAwareLogger;

public class SLF4JLogFactory
extends LogFactory {
    ConcurrentMap<String, Log> loggerMap;
    public static final String LOG_PROPERTY = "org.apache.commons.logging.Log";
    protected Hashtable attributes = new Hashtable();

    public SLF4JLogFactory() {
        this.loggerMap = new ConcurrentHashMap<String, Log>();
    }

    public Object getAttribute(String name2) {
        return this.attributes.get(name2);
    }

    public String[] getAttributeNames() {
        ArrayList<String> names2 = new ArrayList<String>();
        Enumeration keys2 = this.attributes.keys();
        while (keys2.hasMoreElements()) {
            names2.add((String)keys2.nextElement());
        }
        String[] results2 = new String[names2.size()];
        for (int i = 0; i < results2.length; ++i) {
            results2[i] = (String)names2.get(i);
        }
        return results2;
    }

    public Log getInstance(Class clazz2) throws LogConfigurationException {
        return this.getInstance(clazz2.getName());
    }

    public Log getInstance(String name2) throws LogConfigurationException {
        Log instance2 = (Log)this.loggerMap.get(name2);
        if (instance2 != null) {
            return instance2;
        }
        Logger slf4jLogger = LoggerFactory.getLogger(name2);
        Log newInstance = slf4jLogger instanceof LocationAwareLogger ? new SLF4JLocationAwareLog((LocationAwareLogger)slf4jLogger) : new SLF4JLog(slf4jLogger);
        Log oldInstance = this.loggerMap.putIfAbsent(name2, newInstance);
        return oldInstance == null ? newInstance : oldInstance;
    }

    public void release() {
        System.out.println("WARN: The method " + SLF4JLogFactory.class + "#release() was invoked.");
        System.out.println("WARN: Please see http://www.slf4j.org/codes.html#release for an explanation.");
        System.out.flush();
    }

    public void removeAttribute(String name2) {
        this.attributes.remove(name2);
    }

    public void setAttribute(String name2, Object value2) {
        if (value2 == null) {
            this.attributes.remove(name2);
        } else {
            this.attributes.put(name2, value2);
        }
    }
}

