/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.util.zip.ZipException;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;

public class UnsupportedZipFeatureException
extends ZipException {
    private final Feature reason;
    private final ZipArchiveEntry entry;
    private static final long serialVersionUID = 4430521921766595597L;

    public UnsupportedZipFeatureException(Feature reason, ZipArchiveEntry entry2) {
        super("unsupported feature " + reason + " used in entry " + entry2.getName());
        this.reason = reason;
        this.entry = entry2;
    }

    public Feature getFeature() {
        return this.reason;
    }

    public ZipArchiveEntry getEntry() {
        return this.entry;
    }

    public static class Feature {
        public static final Feature ENCRYPTION = new Feature("encryption");
        public static final Feature METHOD = new Feature("compression method");
        public static final Feature DATA_DESCRIPTOR = new Feature("data descriptor");
        private final String name;

        private Feature(String name2) {
            this.name = name2;
        }

        public String toString() {
            return this.name;
        }
    }
}

