/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.list;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.apache.commons.collections.OrderedIterator;

public abstract class AbstractLinkedList
implements List {
    protected transient Node header;
    protected transient int size;
    protected transient int modCount;

    protected AbstractLinkedList() {
    }

    protected AbstractLinkedList(Collection coll) {
        this.init();
        this.addAll(coll);
    }

    protected void init() {
        this.header = this.createHeaderNode();
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Object get(int index2) {
        Node node = this.getNode(index2, false);
        return node.getValue();
    }

    public Iterator iterator() {
        return this.listIterator();
    }

    public ListIterator listIterator() {
        return new LinkedListIterator(this, 0);
    }

    public ListIterator listIterator(int fromIndex) {
        return new LinkedListIterator(this, fromIndex);
    }

    public int indexOf(Object value2) {
        int i = 0;
        Node node = this.header.next;
        while (node != this.header) {
            if (this.isEqualValue(node.getValue(), value2)) {
                return i;
            }
            ++i;
            node = node.next;
        }
        return -1;
    }

    public int lastIndexOf(Object value2) {
        int i = this.size - 1;
        Node node = this.header.previous;
        while (node != this.header) {
            if (this.isEqualValue(node.getValue(), value2)) {
                return i;
            }
            --i;
            node = node.previous;
        }
        return -1;
    }

    public boolean contains(Object value2) {
        return this.indexOf(value2) != -1;
    }

    public boolean containsAll(Collection coll) {
        Iterator it = coll.iterator();
        while (it.hasNext()) {
            if (this.contains(it.next())) continue;
            return false;
        }
        return true;
    }

    public Object[] toArray() {
        return this.toArray(new Object[this.size]);
    }

    public Object[] toArray(Object[] array2) {
        if (array2.length < this.size) {
            Class<?> componentType = array2.getClass().getComponentType();
            array2 = (Object[])Array.newInstance(componentType, this.size);
        }
        int i = 0;
        Node node = this.header.next;
        while (node != this.header) {
            array2[i] = node.getValue();
            node = node.next;
            ++i;
        }
        if (array2.length > this.size) {
            array2[this.size] = null;
        }
        return array2;
    }

    public List subList(int fromIndexInclusive, int toIndexExclusive) {
        return new LinkedSubList(this, fromIndexInclusive, toIndexExclusive);
    }

    public boolean add(Object value2) {
        this.addLast(value2);
        return true;
    }

    public void add(int index2, Object value2) {
        Node node = this.getNode(index2, true);
        this.addNodeBefore(node, value2);
    }

    public boolean addAll(Collection coll) {
        return this.addAll(this.size, coll);
    }

    public boolean addAll(int index2, Collection coll) {
        Node node = this.getNode(index2, true);
        Iterator itr = coll.iterator();
        while (itr.hasNext()) {
            Object value2 = itr.next();
            this.addNodeBefore(node, value2);
        }
        return true;
    }

    public Object remove(int index2) {
        Node node = this.getNode(index2, false);
        Object oldValue = node.getValue();
        this.removeNode(node);
        return oldValue;
    }

    public boolean remove(Object value2) {
        Node node = this.header.next;
        while (node != this.header) {
            if (this.isEqualValue(node.getValue(), value2)) {
                this.removeNode(node);
                return true;
            }
            node = node.next;
        }
        return false;
    }

    public boolean removeAll(Collection coll) {
        boolean modified = false;
        Iterator it = this.iterator();
        while (it.hasNext()) {
            if (!coll.contains(it.next())) continue;
            it.remove();
            modified = true;
        }
        return modified;
    }

    public boolean retainAll(Collection coll) {
        boolean modified = false;
        Iterator it = this.iterator();
        while (it.hasNext()) {
            if (coll.contains(it.next())) continue;
            it.remove();
            modified = true;
        }
        return modified;
    }

    public Object set(int index2, Object value2) {
        Node node = this.getNode(index2, false);
        Object oldValue = node.getValue();
        this.updateNode(node, value2);
        return oldValue;
    }

    public void clear() {
        this.removeAllNodes();
    }

    public Object getFirst() {
        Node node = this.header.next;
        if (node == this.header) {
            throw new NoSuchElementException();
        }
        return node.getValue();
    }

    public Object getLast() {
        Node node = this.header.previous;
        if (node == this.header) {
            throw new NoSuchElementException();
        }
        return node.getValue();
    }

    public boolean addFirst(Object o) {
        this.addNodeAfter(this.header, o);
        return true;
    }

    public boolean addLast(Object o) {
        this.addNodeBefore(this.header, o);
        return true;
    }

    public Object removeFirst() {
        Node node = this.header.next;
        if (node == this.header) {
            throw new NoSuchElementException();
        }
        Object oldValue = node.getValue();
        this.removeNode(node);
        return oldValue;
    }

    public Object removeLast() {
        Node node = this.header.previous;
        if (node == this.header) {
            throw new NoSuchElementException();
        }
        Object oldValue = node.getValue();
        this.removeNode(node);
        return oldValue;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof List)) {
            return false;
        }
        List other = (List)obj;
        if (other.size() != this.size()) {
            return false;
        }
        ListIterator it1 = this.listIterator();
        ListIterator it2 = other.listIterator();
        while (it1.hasNext() && it2.hasNext()) {
            Object o1 = it1.next();
            Object o2 = it2.next();
            if (o1 != null ? o1.equals(o2) : o2 == null) continue;
            return false;
        }
        return !it1.hasNext() && !it2.hasNext();
    }

    public int hashCode() {
        int hashCode = 1;
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            hashCode = 31 * hashCode + (obj == null ? 0 : obj.hashCode());
        }
        return hashCode;
    }

    public String toString() {
        if (this.size() == 0) {
            return "[]";
        }
        StringBuffer buf = new StringBuffer(16 * this.size());
        buf.append("[");
        Iterator it = this.iterator();
        boolean hasNext = it.hasNext();
        while (hasNext) {
            Object value2 = it.next();
            buf.append((Object)(value2 == this ? "(this Collection)" : value2));
            hasNext = it.hasNext();
            if (!hasNext) continue;
            buf.append(", ");
        }
        buf.append("]");
        return buf.toString();
    }

    protected boolean isEqualValue(Object value1, Object value2) {
        return value1 == value2 || value1 != null && value1.equals(value2);
    }

    protected void updateNode(Node node, Object value2) {
        node.setValue(value2);
    }

    protected Node createHeaderNode() {
        return new Node();
    }

    protected Node createNode(Object value2) {
        return new Node(value2);
    }

    protected void addNodeBefore(Node node, Object value2) {
        Node newNode = this.createNode(value2);
        this.addNode(newNode, node);
    }

    protected void addNodeAfter(Node node, Object value2) {
        Node newNode = this.createNode(value2);
        this.addNode(newNode, node.next);
    }

    protected void addNode(Node nodeToInsert, Node insertBeforeNode) {
        nodeToInsert.next = insertBeforeNode;
        nodeToInsert.previous = insertBeforeNode.previous;
        insertBeforeNode.previous.next = nodeToInsert;
        insertBeforeNode.previous = nodeToInsert;
        ++this.size;
        ++this.modCount;
    }

    protected void removeNode(Node node) {
        node.previous.next = node.next;
        node.next.previous = node.previous;
        --this.size;
        ++this.modCount;
    }

    protected void removeAllNodes() {
        this.header.next = this.header;
        this.header.previous = this.header;
        this.size = 0;
        ++this.modCount;
    }

    protected Node getNode(int index2, boolean endMarkerAllowed) throws IndexOutOfBoundsException {
        Node node;
        if (index2 < 0) {
            throw new IndexOutOfBoundsException("Couldn't get the node: index (" + index2 + ") less than zero.");
        }
        if (!endMarkerAllowed && index2 == this.size) {
            throw new IndexOutOfBoundsException("Couldn't get the node: index (" + index2 + ") is the size of the list.");
        }
        if (index2 > this.size) {
            throw new IndexOutOfBoundsException("Couldn't get the node: index (" + index2 + ") greater than the size of the " + "list (" + this.size + ").");
        }
        if (index2 < this.size / 2) {
            node = this.header.next;
            for (int currentIndex = 0; currentIndex < index2; ++currentIndex) {
                node = node.next;
            }
        } else {
            node = this.header;
            for (int currentIndex = this.size; currentIndex > index2; --currentIndex) {
                node = node.previous;
            }
        }
        return node;
    }

    protected Iterator createSubListIterator(LinkedSubList subList) {
        return this.createSubListListIterator(subList, 0);
    }

    protected ListIterator createSubListListIterator(LinkedSubList subList, int fromIndex) {
        return new LinkedSubListIterator(subList, fromIndex);
    }

    protected void doWriteObject(ObjectOutputStream outputStream) throws IOException {
        outputStream.writeInt(this.size());
        Iterator itr = this.iterator();
        while (itr.hasNext()) {
            outputStream.writeObject(itr.next());
        }
    }

    protected void doReadObject(ObjectInputStream inputStream) throws IOException, ClassNotFoundException {
        this.init();
        int size2 = inputStream.readInt();
        for (int i = 0; i < size2; ++i) {
            this.add(inputStream.readObject());
        }
    }

    protected static class LinkedSubList
    extends AbstractList {
        AbstractLinkedList parent;
        int offset;
        int size;
        int expectedModCount;

        protected LinkedSubList(AbstractLinkedList parent, int fromIndex, int toIndex) {
            if (fromIndex < 0) {
                throw new IndexOutOfBoundsException("fromIndex = " + fromIndex);
            }
            if (toIndex > parent.size()) {
                throw new IndexOutOfBoundsException("toIndex = " + toIndex);
            }
            if (fromIndex > toIndex) {
                throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
            }
            this.parent = parent;
            this.offset = fromIndex;
            this.size = toIndex - fromIndex;
            this.expectedModCount = parent.modCount;
        }

        public int size() {
            this.checkModCount();
            return this.size;
        }

        public Object get(int index2) {
            this.rangeCheck(index2, this.size);
            this.checkModCount();
            return this.parent.get(index2 + this.offset);
        }

        public void add(int index2, Object obj) {
            this.rangeCheck(index2, this.size + 1);
            this.checkModCount();
            this.parent.add(index2 + this.offset, obj);
            this.expectedModCount = this.parent.modCount;
            ++this.size;
            ++this.modCount;
        }

        public Object remove(int index2) {
            this.rangeCheck(index2, this.size);
            this.checkModCount();
            Object result2 = this.parent.remove(index2 + this.offset);
            this.expectedModCount = this.parent.modCount;
            --this.size;
            ++this.modCount;
            return result2;
        }

        public boolean addAll(Collection coll) {
            return this.addAll(this.size, coll);
        }

        public boolean addAll(int index2, Collection coll) {
            this.rangeCheck(index2, this.size + 1);
            int cSize = coll.size();
            if (cSize == 0) {
                return false;
            }
            this.checkModCount();
            this.parent.addAll(this.offset + index2, coll);
            this.expectedModCount = this.parent.modCount;
            this.size += cSize;
            ++this.modCount;
            return true;
        }

        public Object set(int index2, Object obj) {
            this.rangeCheck(index2, this.size);
            this.checkModCount();
            return this.parent.set(index2 + this.offset, obj);
        }

        public void clear() {
            this.checkModCount();
            Iterator it = this.iterator();
            while (it.hasNext()) {
                it.next();
                it.remove();
            }
        }

        public Iterator iterator() {
            this.checkModCount();
            return this.parent.createSubListIterator(this);
        }

        public ListIterator listIterator(int index2) {
            this.rangeCheck(index2, this.size + 1);
            this.checkModCount();
            return this.parent.createSubListListIterator(this, index2);
        }

        public List subList(int fromIndexInclusive, int toIndexExclusive) {
            return new LinkedSubList(this.parent, fromIndexInclusive + this.offset, toIndexExclusive + this.offset);
        }

        protected void rangeCheck(int index2, int beyond) {
            if (index2 < 0 || index2 >= beyond) {
                throw new IndexOutOfBoundsException("Index '" + index2 + "' out of bounds for size '" + this.size + "'");
            }
        }

        protected void checkModCount() {
            if (this.parent.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }

    protected static class LinkedSubListIterator
    extends LinkedListIterator {
        protected final LinkedSubList sub;

        protected LinkedSubListIterator(LinkedSubList sub, int startIndex) {
            super(sub.parent, startIndex + sub.offset);
            this.sub = sub;
        }

        public boolean hasNext() {
            return this.nextIndex() < this.sub.size;
        }

        public boolean hasPrevious() {
            return this.previousIndex() >= 0;
        }

        public int nextIndex() {
            return super.nextIndex() - this.sub.offset;
        }

        public void add(Object obj) {
            super.add(obj);
            this.sub.expectedModCount = this.parent.modCount;
            ++this.sub.size;
        }

        public void remove() {
            super.remove();
            this.sub.expectedModCount = this.parent.modCount;
            --this.sub.size;
        }
    }

    protected static class LinkedListIterator
    implements ListIterator,
    OrderedIterator {
        protected final AbstractLinkedList parent;
        protected Node next;
        protected int nextIndex;
        protected Node current;
        protected int expectedModCount;

        protected LinkedListIterator(AbstractLinkedList parent, int fromIndex) throws IndexOutOfBoundsException {
            this.parent = parent;
            this.expectedModCount = parent.modCount;
            this.next = parent.getNode(fromIndex, true);
            this.nextIndex = fromIndex;
        }

        protected void checkModCount() {
            if (this.parent.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }

        protected Node getLastNodeReturned() throws IllegalStateException {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            return this.current;
        }

        public boolean hasNext() {
            return this.next != this.parent.header;
        }

        public Object next() {
            this.checkModCount();
            if (!this.hasNext()) {
                throw new NoSuchElementException("No element at index " + this.nextIndex + ".");
            }
            Object value2 = this.next.getValue();
            this.current = this.next;
            this.next = this.next.next;
            ++this.nextIndex;
            return value2;
        }

        public boolean hasPrevious() {
            return this.next.previous != this.parent.header;
        }

        public Object previous() {
            this.checkModCount();
            if (!this.hasPrevious()) {
                throw new NoSuchElementException("Already at start of list.");
            }
            this.next = this.next.previous;
            Object value2 = this.next.getValue();
            this.current = this.next;
            --this.nextIndex;
            return value2;
        }

        public int nextIndex() {
            return this.nextIndex;
        }

        public int previousIndex() {
            return this.nextIndex() - 1;
        }

        public void remove() {
            this.checkModCount();
            if (this.current == this.next) {
                this.next = this.next.next;
                this.parent.removeNode(this.getLastNodeReturned());
            } else {
                this.parent.removeNode(this.getLastNodeReturned());
                --this.nextIndex;
            }
            this.current = null;
            ++this.expectedModCount;
        }

        public void set(Object obj) {
            this.checkModCount();
            this.getLastNodeReturned().setValue(obj);
        }

        public void add(Object obj) {
            this.checkModCount();
            this.parent.addNodeBefore(this.next, obj);
            this.current = null;
            ++this.nextIndex;
            ++this.expectedModCount;
        }
    }

    protected static class Node {
        protected Node previous;
        protected Node next;
        protected Object value;

        protected Node() {
            this.previous = this;
            this.next = this;
        }

        protected Node(Object value2) {
            this.value = value2;
        }

        protected Node(Node previous, Node next2, Object value2) {
            this.previous = previous;
            this.next = next2;
            this.value = value2;
        }

        protected Object getValue() {
            return this.value;
        }

        protected void setValue(Object value2) {
            this.value = value2;
        }

        protected Node getPreviousNode() {
            return this.previous;
        }

        protected void setPreviousNode(Node previous) {
            this.previous = previous;
        }

        protected Node getNextNode() {
            return this.next;
        }

        protected void setNextNode(Node next2) {
            this.next = next2;
        }
    }
}

