/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import org.apache.commons.collections.ArrayStack;
import org.apache.commons.collections.Buffer;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.buffer.BlockingBuffer;
import org.apache.commons.collections.buffer.BoundedBuffer;
import org.apache.commons.collections.buffer.PredicatedBuffer;
import org.apache.commons.collections.buffer.SynchronizedBuffer;
import org.apache.commons.collections.buffer.TransformedBuffer;
import org.apache.commons.collections.buffer.TypedBuffer;
import org.apache.commons.collections.buffer.UnmodifiableBuffer;

public class BufferUtils {
    public static final Buffer EMPTY_BUFFER = UnmodifiableBuffer.decorate(new ArrayStack(1));

    public static Buffer synchronizedBuffer(Buffer buffer2) {
        return SynchronizedBuffer.decorate(buffer2);
    }

    public static Buffer blockingBuffer(Buffer buffer2) {
        return BlockingBuffer.decorate(buffer2);
    }

    public static Buffer blockingBuffer(Buffer buffer2, long timeoutMillis) {
        return BlockingBuffer.decorate(buffer2, timeoutMillis);
    }

    public static Buffer boundedBuffer(Buffer buffer2, int maximumSize) {
        return BoundedBuffer.decorate(buffer2, maximumSize);
    }

    public static Buffer boundedBuffer(Buffer buffer2, int maximumSize, long timeoutMillis) {
        return BoundedBuffer.decorate(buffer2, maximumSize, timeoutMillis);
    }

    public static Buffer unmodifiableBuffer(Buffer buffer2) {
        return UnmodifiableBuffer.decorate(buffer2);
    }

    public static Buffer predicatedBuffer(Buffer buffer2, Predicate predicate) {
        return PredicatedBuffer.decorate(buffer2, predicate);
    }

    public static Buffer typedBuffer(Buffer buffer2, Class type) {
        return TypedBuffer.decorate(buffer2, type);
    }

    public static Buffer transformedBuffer(Buffer buffer2, Transformer transformer) {
        return TransformedBuffer.decorate(buffer2, transformer);
    }
}

