/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.digest;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.binary.StringUtils;

public class DigestUtils {
    private static final int STREAM_BUFFER_LENGTH = 1024;
    private final MessageDigest messageDigest;

    public static byte[] digest(MessageDigest messageDigest, byte[] data2) {
        return messageDigest.digest(data2);
    }

    public static byte[] digest(MessageDigest messageDigest, ByteBuffer data2) {
        messageDigest.update(data2);
        return messageDigest.digest();
    }

    public static byte[] digest(MessageDigest messageDigest, File data2) throws IOException {
        return DigestUtils.updateDigest(messageDigest, data2).digest();
    }

    public static byte[] digest(MessageDigest messageDigest, InputStream data2) throws IOException {
        return DigestUtils.updateDigest(messageDigest, data2).digest();
    }

    public static byte[] digest(MessageDigest messageDigest, Path data2, OpenOption ... options) throws IOException {
        return DigestUtils.updateDigest(messageDigest, data2, options).digest();
    }

    public static byte[] digest(MessageDigest messageDigest, RandomAccessFile data2) throws IOException {
        return DigestUtils.updateDigest(messageDigest, data2).digest();
    }

    public static MessageDigest getDigest(String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static MessageDigest getDigest(String algorithm, MessageDigest defaultMessageDigest) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (Exception e) {
            return defaultMessageDigest;
        }
    }

    public static MessageDigest getMd2Digest() {
        return DigestUtils.getDigest("MD2");
    }

    public static MessageDigest getMd5Digest() {
        return DigestUtils.getDigest("MD5");
    }

    public static MessageDigest getSha1Digest() {
        return DigestUtils.getDigest("SHA-1");
    }

    public static MessageDigest getSha256Digest() {
        return DigestUtils.getDigest("SHA-256");
    }

    public static MessageDigest getSha3_224Digest() {
        return DigestUtils.getDigest("SHA3-224");
    }

    public static MessageDigest getSha3_256Digest() {
        return DigestUtils.getDigest("SHA3-256");
    }

    public static MessageDigest getSha3_384Digest() {
        return DigestUtils.getDigest("SHA3-384");
    }

    public static MessageDigest getSha3_512Digest() {
        return DigestUtils.getDigest("SHA3-512");
    }

    public static MessageDigest getSha384Digest() {
        return DigestUtils.getDigest("SHA-384");
    }

    public static MessageDigest getSha512_224Digest() {
        return DigestUtils.getDigest("SHA-512/224");
    }

    public static MessageDigest getSha512_256Digest() {
        return DigestUtils.getDigest("SHA-512/256");
    }

    public static MessageDigest getSha512Digest() {
        return DigestUtils.getDigest("SHA-512");
    }

    @Deprecated
    public static MessageDigest getShaDigest() {
        return DigestUtils.getSha1Digest();
    }

    public static boolean isAvailable(String messageDigestAlgorithm) {
        return DigestUtils.getDigest(messageDigestAlgorithm, null) != null;
    }

    public static byte[] md2(byte[] data2) {
        return DigestUtils.getMd2Digest().digest(data2);
    }

    public static byte[] md2(InputStream data2) throws IOException {
        return DigestUtils.digest(DigestUtils.getMd2Digest(), data2);
    }

    public static byte[] md2(String data2) {
        return DigestUtils.md2(StringUtils.getBytesUtf8(data2));
    }

    public static String md2Hex(byte[] data2) {
        return Hex.encodeHexString(DigestUtils.md2(data2));
    }

    public static String md2Hex(InputStream data2) throws IOException {
        return Hex.encodeHexString(DigestUtils.md2(data2));
    }

    public static String md2Hex(String data2) {
        return Hex.encodeHexString(DigestUtils.md2(data2));
    }

    public static byte[] md5(byte[] data2) {
        return DigestUtils.getMd5Digest().digest(data2);
    }

    public static byte[] md5(InputStream data2) throws IOException {
        return DigestUtils.digest(DigestUtils.getMd5Digest(), data2);
    }

    public static byte[] md5(String data2) {
        return DigestUtils.md5(StringUtils.getBytesUtf8(data2));
    }

    public static String md5Hex(byte[] data2) {
        return Hex.encodeHexString(DigestUtils.md5(data2));
    }

    public static String md5Hex(InputStream data2) throws IOException {
        return Hex.encodeHexString(DigestUtils.md5(data2));
    }

    public static String md5Hex(String data2) {
        return Hex.encodeHexString(DigestUtils.md5(data2));
    }

    @Deprecated
    public static byte[] sha(byte[] data2) {
        return DigestUtils.sha1(data2);
    }

    @Deprecated
    public static byte[] sha(InputStream data2) throws IOException {
        return DigestUtils.sha1(data2);
    }

    @Deprecated
    public static byte[] sha(String data2) {
        return DigestUtils.sha1(data2);
    }

    public static byte[] sha1(byte[] data2) {
        return DigestUtils.getSha1Digest().digest(data2);
    }

    public static byte[] sha1(InputStream data2) throws IOException {
        return DigestUtils.digest(DigestUtils.getSha1Digest(), data2);
    }

    public static byte[] sha1(String data2) {
        return DigestUtils.sha1(StringUtils.getBytesUtf8(data2));
    }

    public static String sha1Hex(byte[] data2) {
        return Hex.encodeHexString(DigestUtils.sha1(data2));
    }

    public static String sha1Hex(InputStream data2) throws IOException {
        return Hex.encodeHexString(DigestUtils.sha1(data2));
    }

    public static String sha1Hex(String data2) {
        return Hex.encodeHexString(DigestUtils.sha1(data2));
    }

    public static byte[] sha256(byte[] data2) {
        return DigestUtils.getSha256Digest().digest(data2);
    }

    public static byte[] sha256(InputStream data2) throws IOException {
        return DigestUtils.digest(DigestUtils.getSha256Digest(), data2);
    }

    public static byte[] sha256(String data2) {
        return DigestUtils.sha256(StringUtils.getBytesUtf8(data2));
    }

    public static String sha256Hex(byte[] data2) {
        return Hex.encodeHexString(DigestUtils.sha256(data2));
    }

    public static String sha256Hex(InputStream data2) throws IOException {
        return Hex.encodeHexString(DigestUtils.sha256(data2));
    }

    public static String sha256Hex(String data2) {
        return Hex.encodeHexString(DigestUtils.sha256(data2));
    }

    public static byte[] sha3_224(byte[] data2) {
        return DigestUtils.getSha3_224Digest().digest(data2);
    }

    public static byte[] sha3_224(InputStream data2) throws IOException {
        return DigestUtils.digest(DigestUtils.getSha3_224Digest(), data2);
    }

    public static byte[] sha3_224(String data2) {
        return DigestUtils.sha3_224(StringUtils.getBytesUtf8(data2));
    }

    public static String sha3_224Hex(byte[] data2) {
        return Hex.encodeHexString(DigestUtils.sha3_224(data2));
    }

    public static String sha3_224Hex(InputStream data2) throws IOException {
        return Hex.encodeHexString(DigestUtils.sha3_224(data2));
    }

    public static String sha3_224Hex(String data2) {
        return Hex.encodeHexString(DigestUtils.sha3_224(data2));
    }

    public static byte[] sha3_256(byte[] data2) {
        return DigestUtils.getSha3_256Digest().digest(data2);
    }

    public static byte[] sha3_256(InputStream data2) throws IOException {
        return DigestUtils.digest(DigestUtils.getSha3_256Digest(), data2);
    }

    public static byte[] sha3_256(String data2) {
        return DigestUtils.sha3_256(StringUtils.getBytesUtf8(data2));
    }

    public static String sha3_256Hex(byte[] data2) {
        return Hex.encodeHexString(DigestUtils.sha3_256(data2));
    }

    public static String sha3_256Hex(InputStream data2) throws IOException {
        return Hex.encodeHexString(DigestUtils.sha3_256(data2));
    }

    public static String sha3_256Hex(String data2) {
        return Hex.encodeHexString(DigestUtils.sha3_256(data2));
    }

    public static byte[] sha3_384(byte[] data2) {
        return DigestUtils.getSha3_384Digest().digest(data2);
    }

    public static byte[] sha3_384(InputStream data2) throws IOException {
        return DigestUtils.digest(DigestUtils.getSha3_384Digest(), data2);
    }

    public static byte[] sha3_384(String data2) {
        return DigestUtils.sha3_384(StringUtils.getBytesUtf8(data2));
    }

    public static String sha3_384Hex(byte[] data2) {
        return Hex.encodeHexString(DigestUtils.sha3_384(data2));
    }

    public static String sha3_384Hex(InputStream data2) throws IOException {
        return Hex.encodeHexString(DigestUtils.sha3_384(data2));
    }

    public static String sha3_384Hex(String data2) {
        return Hex.encodeHexString(DigestUtils.sha3_384(data2));
    }

    public static byte[] sha3_512(byte[] data2) {
        return DigestUtils.getSha3_512Digest().digest(data2);
    }

    public static byte[] sha3_512(InputStream data2) throws IOException {
        return DigestUtils.digest(DigestUtils.getSha3_512Digest(), data2);
    }

    public static byte[] sha3_512(String data2) {
        return DigestUtils.sha3_512(StringUtils.getBytesUtf8(data2));
    }

    public static String sha3_512Hex(byte[] data2) {
        return Hex.encodeHexString(DigestUtils.sha3_512(data2));
    }

    public static String sha3_512Hex(InputStream data2) throws IOException {
        return Hex.encodeHexString(DigestUtils.sha3_512(data2));
    }

    public static String sha3_512Hex(String data2) {
        return Hex.encodeHexString(DigestUtils.sha3_512(data2));
    }

    public static byte[] sha384(byte[] data2) {
        return DigestUtils.getSha384Digest().digest(data2);
    }

    public static byte[] sha384(InputStream data2) throws IOException {
        return DigestUtils.digest(DigestUtils.getSha384Digest(), data2);
    }

    public static byte[] sha384(String data2) {
        return DigestUtils.sha384(StringUtils.getBytesUtf8(data2));
    }

    public static String sha384Hex(byte[] data2) {
        return Hex.encodeHexString(DigestUtils.sha384(data2));
    }

    public static String sha384Hex(InputStream data2) throws IOException {
        return Hex.encodeHexString(DigestUtils.sha384(data2));
    }

    public static String sha384Hex(String data2) {
        return Hex.encodeHexString(DigestUtils.sha384(data2));
    }

    public static byte[] sha512(byte[] data2) {
        return DigestUtils.getSha512Digest().digest(data2);
    }

    public static byte[] sha512(InputStream data2) throws IOException {
        return DigestUtils.digest(DigestUtils.getSha512Digest(), data2);
    }

    public static byte[] sha512(String data2) {
        return DigestUtils.sha512(StringUtils.getBytesUtf8(data2));
    }

    public static byte[] sha512_224(byte[] data2) {
        return DigestUtils.getSha512_224Digest().digest(data2);
    }

    public static byte[] sha512_224(InputStream data2) throws IOException {
        return DigestUtils.digest(DigestUtils.getSha512_224Digest(), data2);
    }

    public static byte[] sha512_224(String data2) {
        return DigestUtils.sha512_224(StringUtils.getBytesUtf8(data2));
    }

    public static String sha512_224Hex(byte[] data2) {
        return Hex.encodeHexString(DigestUtils.sha512_224(data2));
    }

    public static String sha512_224Hex(InputStream data2) throws IOException {
        return Hex.encodeHexString(DigestUtils.sha512_224(data2));
    }

    public static String sha512_224Hex(String data2) {
        return Hex.encodeHexString(DigestUtils.sha512_224(data2));
    }

    public static byte[] sha512_256(byte[] data2) {
        return DigestUtils.getSha512_256Digest().digest(data2);
    }

    public static byte[] sha512_256(InputStream data2) throws IOException {
        return DigestUtils.digest(DigestUtils.getSha512_256Digest(), data2);
    }

    public static byte[] sha512_256(String data2) {
        return DigestUtils.sha512_256(StringUtils.getBytesUtf8(data2));
    }

    public static String sha512_256Hex(byte[] data2) {
        return Hex.encodeHexString(DigestUtils.sha512_256(data2));
    }

    public static String sha512_256Hex(InputStream data2) throws IOException {
        return Hex.encodeHexString(DigestUtils.sha512_256(data2));
    }

    public static String sha512_256Hex(String data2) {
        return Hex.encodeHexString(DigestUtils.sha512_256(data2));
    }

    public static String sha512Hex(byte[] data2) {
        return Hex.encodeHexString(DigestUtils.sha512(data2));
    }

    public static String sha512Hex(InputStream data2) throws IOException {
        return Hex.encodeHexString(DigestUtils.sha512(data2));
    }

    public static String sha512Hex(String data2) {
        return Hex.encodeHexString(DigestUtils.sha512(data2));
    }

    @Deprecated
    public static String shaHex(byte[] data2) {
        return DigestUtils.sha1Hex(data2);
    }

    @Deprecated
    public static String shaHex(InputStream data2) throws IOException {
        return DigestUtils.sha1Hex(data2);
    }

    @Deprecated
    public static String shaHex(String data2) {
        return DigestUtils.sha1Hex(data2);
    }

    public static MessageDigest updateDigest(MessageDigest messageDigest, byte[] valueToDigest) {
        messageDigest.update(valueToDigest);
        return messageDigest;
    }

    public static MessageDigest updateDigest(MessageDigest messageDigest, ByteBuffer valueToDigest) {
        messageDigest.update(valueToDigest);
        return messageDigest;
    }

    public static MessageDigest updateDigest(MessageDigest digest, File data2) throws IOException {
        try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(data2));){
            MessageDigest messageDigest = DigestUtils.updateDigest(digest, inputStream);
            return messageDigest;
        }
    }

    private static MessageDigest updateDigest(MessageDigest digest, FileChannel data2) throws IOException {
        ByteBuffer buffer2 = ByteBuffer.allocate(1024);
        while (data2.read(buffer2) > 0) {
            buffer2.flip();
            digest.update(buffer2);
            buffer2.clear();
        }
        return digest;
    }

    public static MessageDigest updateDigest(MessageDigest digest, InputStream inputStream) throws IOException {
        byte[] buffer2 = new byte[1024];
        int read2 = inputStream.read(buffer2, 0, 1024);
        while (read2 > -1) {
            digest.update(buffer2, 0, read2);
            read2 = inputStream.read(buffer2, 0, 1024);
        }
        return digest;
    }

    public static MessageDigest updateDigest(MessageDigest digest, Path path, OpenOption ... options) throws IOException {
        try (BufferedInputStream inputStream = new BufferedInputStream(Files.newInputStream(path, options));){
            MessageDigest messageDigest = DigestUtils.updateDigest(digest, inputStream);
            return messageDigest;
        }
    }

    public static MessageDigest updateDigest(MessageDigest digest, RandomAccessFile data2) throws IOException {
        return DigestUtils.updateDigest(digest, data2.getChannel());
    }

    public static MessageDigest updateDigest(MessageDigest messageDigest, String valueToDigest) {
        messageDigest.update(StringUtils.getBytesUtf8(valueToDigest));
        return messageDigest;
    }

    @Deprecated
    public DigestUtils() {
        this.messageDigest = null;
    }

    public DigestUtils(MessageDigest digest) {
        this.messageDigest = digest;
    }

    public DigestUtils(String name2) {
        this(DigestUtils.getDigest(name2));
    }

    public byte[] digest(byte[] data2) {
        return DigestUtils.updateDigest(this.messageDigest, data2).digest();
    }

    public byte[] digest(ByteBuffer data2) {
        return DigestUtils.updateDigest(this.messageDigest, data2).digest();
    }

    public byte[] digest(File data2) throws IOException {
        return DigestUtils.updateDigest(this.messageDigest, data2).digest();
    }

    public byte[] digest(InputStream data2) throws IOException {
        return DigestUtils.updateDigest(this.messageDigest, data2).digest();
    }

    public byte[] digest(Path data2, OpenOption ... options) throws IOException {
        return DigestUtils.updateDigest(this.messageDigest, data2, options).digest();
    }

    public byte[] digest(String data2) {
        return DigestUtils.updateDigest(this.messageDigest, data2).digest();
    }

    public String digestAsHex(byte[] data2) {
        return Hex.encodeHexString(this.digest(data2));
    }

    public String digestAsHex(ByteBuffer data2) {
        return Hex.encodeHexString(this.digest(data2));
    }

    public String digestAsHex(File data2) throws IOException {
        return Hex.encodeHexString(this.digest(data2));
    }

    public String digestAsHex(InputStream data2) throws IOException {
        return Hex.encodeHexString(this.digest(data2));
    }

    public String digestAsHex(Path data2, OpenOption ... options) throws IOException {
        return Hex.encodeHexString(this.digest(data2, options));
    }

    public String digestAsHex(String data2) {
        return Hex.encodeHexString(this.digest(data2));
    }

    public MessageDigest getMessageDigest() {
        return this.messageDigest;
    }
}

