/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.util;

import java.nio.charset.Charset;
import org.apache.avro.io.BinaryData;

public class Utf8
implements Comparable<Utf8>,
CharSequence {
    private static final byte[] EMPTY = new byte[0];
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private byte[] bytes = EMPTY;
    private int length;
    private String string;

    public Utf8() {
    }

    public Utf8(String string2) {
        this.bytes = Utf8.getBytesFor(string2);
        this.length = this.bytes.length;
        this.string = string2;
    }

    public Utf8(Utf8 other) {
        this.length = other.length;
        this.bytes = new byte[other.length];
        System.arraycopy(other.bytes, 0, this.bytes, 0, this.length);
        this.string = other.string;
    }

    public Utf8(byte[] bytes2) {
        this.bytes = bytes2;
        this.length = bytes2.length;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public int getLength() {
        return this.length;
    }

    public int getByteLength() {
        return this.length;
    }

    public Utf8 setLength(int newLength) {
        return this.setByteLength(newLength);
    }

    public Utf8 setByteLength(int newLength) {
        if (this.bytes.length < newLength) {
            byte[] newBytes = new byte[newLength];
            System.arraycopy(this.bytes, 0, newBytes, 0, this.length);
            this.bytes = newBytes;
        }
        this.length = newLength;
        this.string = null;
        return this;
    }

    public Utf8 set(String string2) {
        this.bytes = Utf8.getBytesFor(string2);
        this.length = this.bytes.length;
        this.string = string2;
        return this;
    }

    @Override
    public String toString() {
        if (this.length == 0) {
            return "";
        }
        if (this.string == null) {
            this.string = new String(this.bytes, 0, this.length, UTF8);
        }
        return this.string;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Utf8)) {
            return false;
        }
        Utf8 that = (Utf8)o;
        if (this.length != that.length) {
            return false;
        }
        byte[] thatBytes = that.bytes;
        for (int i = 0; i < this.length; ++i) {
            if (this.bytes[i] == thatBytes[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash2 = 0;
        for (int i = 0; i < this.length; ++i) {
            hash2 = hash2 * 31 + this.bytes[i];
        }
        return hash2;
    }

    @Override
    public int compareTo(Utf8 that) {
        return BinaryData.compareBytes(this.bytes, 0, this.length, that.bytes, 0, that.length);
    }

    @Override
    public char charAt(int index2) {
        return this.toString().charAt(index2);
    }

    @Override
    public int length() {
        return this.toString().length();
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.toString().subSequence(start, end);
    }

    public static final byte[] getBytesFor(String str) {
        return str.getBytes(UTF8);
    }
}

