/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.util;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;

public class ByteBufferOutputStream
extends OutputStream {
    public static final int BUFFER_SIZE = 8192;
    private List<ByteBuffer> buffers;

    public ByteBufferOutputStream() {
        this.reset();
    }

    public List<ByteBuffer> getBufferList() {
        List<ByteBuffer> result2 = this.buffers;
        this.reset();
        for (ByteBuffer buffer2 : result2) {
            buffer2.flip();
        }
        return result2;
    }

    public void prepend(List<ByteBuffer> lists) {
        for (ByteBuffer buffer2 : lists) {
            buffer2.position(buffer2.limit());
        }
        this.buffers.addAll(0, lists);
    }

    public void append(List<ByteBuffer> lists) {
        for (ByteBuffer buffer2 : lists) {
            buffer2.position(buffer2.limit());
        }
        this.buffers.addAll(lists);
    }

    public void reset() {
        this.buffers = new LinkedList<ByteBuffer>();
        this.buffers.add(ByteBuffer.allocate(8192));
    }

    public void write(ByteBuffer buffer2) {
        this.buffers.add(buffer2);
    }

    @Override
    public void write(int b) {
        ByteBuffer buffer2 = this.buffers.get(this.buffers.size() - 1);
        if (buffer2.remaining() < 1) {
            buffer2 = ByteBuffer.allocate(8192);
            this.buffers.add(buffer2);
        }
        buffer2.put((byte)b);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        ByteBuffer buffer2 = this.buffers.get(this.buffers.size() - 1);
        int remaining = buffer2.remaining();
        while (len > remaining) {
            buffer2.put(b, off, remaining);
            len -= remaining;
            off += remaining;
            buffer2 = ByteBuffer.allocate(8192);
            this.buffers.add(buffer2);
            remaining = buffer2.remaining();
        }
        buffer2.put(b, off, len);
    }

    public void writeBuffer(ByteBuffer buffer2) throws IOException {
        if (buffer2.remaining() < 8192) {
            this.write(buffer2.array(), buffer2.position(), buffer2.remaining());
        } else {
            ByteBuffer dup = buffer2.duplicate();
            dup.position(buffer2.limit());
            this.buffers.add(dup);
        }
    }
}

