/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.specific;

import java.util.ArrayList;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.TestSchema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.avro.test.Kind;
import org.apache.avro.test.MD5;
import org.apache.avro.test.TestRecord;
import org.junit.Assert;
import org.junit.Test;

public class TestSpecificData {
    @Test
    public void testHashCode() {
        new TestRecord().hashCode();
        SpecificData.get().hashCode(null, TestRecord.SCHEMA$);
    }

    @Test
    public void testToString() {
        new TestRecord().toString();
    }

    @Test
    public void testGetMapSchema() throws Exception {
        SpecificData.get().getSchema(X.class.getField("map").getGenericType());
    }

    @Test
    public void testSpecificWithinGeneric() throws Exception {
        Schema schema = Schema.createRecord("Foo", "", "x.y.z", false);
        ArrayList<Schema.Field> fields2 = new ArrayList<Schema.Field>();
        fields2.add(new Schema.Field("f", TestRecord.SCHEMA$, "", null));
        schema.setFields(fields2);
        TestRecord nested = new TestRecord();
        nested.setName("foo");
        nested.setKind(Kind.BAR);
        nested.setHash(new MD5(new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5}));
        GenericData.Record record2 = new GenericData.Record(schema);
        record2.put("f", (Object)nested);
        TestSchema.checkBinary(schema, record2, new SpecificDatumWriter<Object>(), new SpecificDatumReader<Object>());
        TestSchema.checkDirectBinary(schema, record2, new SpecificDatumWriter<Object>(), new SpecificDatumReader<Object>());
        TestSchema.checkBlockingBinary(schema, record2, new SpecificDatumWriter<Object>(), new SpecificDatumReader<Object>());
    }

    @Test
    public void testGetClassSchema() throws Exception {
        Assert.assertEquals((Object)TestRecord.getClassSchema(), (Object)TestRecord.SCHEMA$);
        Assert.assertEquals((Object)MD5.getClassSchema(), (Object)MD5.SCHEMA$);
        Assert.assertEquals((Object)Kind.getClassSchema(), (Object)Kind.SCHEMA$);
    }

    private static class X {
        public Map<String, String> map;

        private X() {
        }
    }
}

