/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.specific;

import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;

public class SpecificDatumReader<T>
extends GenericDatumReader<T> {
    public SpecificDatumReader() {
        this(null, null, SpecificData.get());
    }

    public SpecificDatumReader(Class<T> c) {
        this(new SpecificData(c.getClassLoader()));
        this.setSchema(this.getSpecificData().getSchema(c));
    }

    public SpecificDatumReader(Schema schema) {
        this(schema, schema, SpecificData.get());
    }

    public SpecificDatumReader(Schema writer, Schema reader) {
        this(writer, reader, SpecificData.get());
    }

    public SpecificDatumReader(Schema writer, Schema reader, SpecificData data2) {
        super(writer, reader, data2);
    }

    public SpecificDatumReader(SpecificData data2) {
        super(data2);
    }

    public SpecificData getSpecificData() {
        return (SpecificData)this.getData();
    }

    @Override
    public void setSchema(Schema actual) {
        SpecificData data2;
        Class c;
        if (this.getExpected() == null && actual != null && actual.getType() == Schema.Type.RECORD && (c = (data2 = this.getSpecificData()).getClass(actual)) != null && SpecificRecord.class.isAssignableFrom(c)) {
            this.setExpected(data2.getSchema(c));
        }
        super.setSchema(actual);
    }

    @Override
    protected Object createEnum(String symbol, Schema schema) {
        Class c = this.getSpecificData().getClass(schema);
        if (c == null) {
            return super.createEnum(symbol, schema);
        }
        return Enum.valueOf(c, symbol);
    }
}

