/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.reflect;

import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.io.Decoder;
import org.apache.avro.reflect.ReflectData;
import org.apache.avro.specific.SpecificDatumReader;

public class ReflectDatumReader<T>
extends SpecificDatumReader<T> {
    public ReflectDatumReader() {
        this(null, null, ReflectData.get());
    }

    public ReflectDatumReader(Class<T> c) {
        this(new ReflectData(c.getClassLoader()));
        this.setSchema(this.getSpecificData().getSchema(c));
    }

    public ReflectDatumReader(Schema root2) {
        this(root2, root2, ReflectData.get());
    }

    public ReflectDatumReader(Schema writer, Schema reader) {
        this(writer, reader, ReflectData.get());
    }

    public ReflectDatumReader(Schema writer, Schema reader, ReflectData data2) {
        super(writer, reader, data2);
    }

    public ReflectDatumReader(ReflectData data2) {
        super(data2);
    }

    @Override
    protected Object newArray(Object old, int size2, Schema schema) {
        Class collectionClass = ReflectData.getClassProp(schema, "java-class");
        Class elementClass = ReflectData.getClassProp(schema, "java-element-class");
        if (collectionClass == null && elementClass == null) {
            return super.newArray(old, size2, schema);
        }
        ReflectData data2 = (ReflectData)this.getData();
        if (collectionClass != null && !collectionClass.isArray()) {
            if (old instanceof Collection) {
                ((Collection)old).clear();
                return old;
            }
            if (collectionClass.isAssignableFrom(ArrayList.class)) {
                return new ArrayList();
            }
            return ReflectData.newInstance(collectionClass, schema);
        }
        if (elementClass == null) {
            elementClass = data2.getClass(schema.getElementType());
        }
        return Array.newInstance(elementClass, size2);
    }

    @Override
    protected Object peekArray(Object array2) {
        return null;
    }

    @Override
    protected void addToArray(Object array2, long pos, Object e) {
        if (array2 instanceof Collection) {
            ((Collection)array2).add(e);
        } else {
            Array.set(array2, (int)pos, e);
        }
    }

    @Override
    protected Object readMapKey(Object old, Schema s2, Decoder in) throws IOException {
        Class c = ReflectData.getClassProp(s2, "java-key-class");
        return this.readString(in, c);
    }

    @Override
    protected Object readString(Object old, Schema s2, Decoder in) throws IOException {
        Class c = ReflectData.getClassProp(s2, "java-class");
        return this.readString(in, c);
    }

    private Object readString(Decoder in, Class c) throws IOException {
        String value2 = (String)this.readString(null, in);
        if (c != null) {
            try {
                return c.getConstructor(String.class).newInstance(value2);
            }
            catch (NoSuchMethodException e) {
                throw new AvroRuntimeException(e);
            }
            catch (InstantiationException e) {
                throw new AvroRuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new AvroRuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new AvroRuntimeException(e);
            }
        }
        return value2;
    }

    @Override
    protected Object readString(Object old, Decoder in) throws IOException {
        return super.readString(null, in).toString();
    }

    @Override
    protected Object createString(String value2) {
        return value2;
    }

    @Override
    protected Object readBytes(Object old, Schema s2, Decoder in) throws IOException {
        ByteBuffer bytes2 = in.readBytes(null);
        Class c = ReflectData.getClassProp(s2, "java-class");
        if (c != null && c.isArray()) {
            byte[] result2 = new byte[bytes2.remaining()];
            bytes2.get(result2);
            return result2;
        }
        return bytes2;
    }

    @Override
    protected Object readInt(Object old, Schema expected, Decoder in) throws IOException {
        Number value2 = in.readInt();
        String intClass = expected.getProp("java-class");
        if (Byte.class.getName().equals(intClass)) {
            value2 = ((Integer)value2).byteValue();
        } else if (Short.class.getName().equals(intClass)) {
            value2 = ((Integer)value2).shortValue();
        }
        return value2;
    }
}

