/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.mapreduce;

import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.avro.hadoop.io.AvroSequenceFile;
import org.apache.avro.mapreduce.AvroJob;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;

public class AvroSequenceFileInputFormat<K, V>
extends SequenceFileInputFormat<K, V> {
    public RecordReader<K, V> createRecordReader(InputSplit inputSplit, TaskAttemptContext context) throws IOException {
        return new AvroSequenceFileRecordReader();
    }

    protected class AvroSequenceFileRecordReader
    extends RecordReader<K, V> {
        private SequenceFile.Reader mReader;
        private long mStart;
        private long mEnd;
        private boolean mHasMoreData;
        private K mCurrentKey;
        private V mCurrentValue;

        protected AvroSequenceFileRecordReader() {
        }

        public void initialize(InputSplit split2, TaskAttemptContext context) throws IOException, InterruptedException {
            Schema valueSchema;
            FileSplit fileSplit = (FileSplit)split2;
            Configuration conf = context.getConfiguration();
            Path path = fileSplit.getPath();
            FileSystem fs = path.getFileSystem(conf);
            AvroSequenceFile.Reader.Options options = new AvroSequenceFile.Reader.Options().withFileSystem(fs).withInputPath(path).withConfiguration(conf);
            Schema keySchema = AvroJob.getInputKeySchema(conf);
            if (null != keySchema) {
                options.withKeySchema(keySchema);
            }
            if (null != (valueSchema = AvroJob.getInputValueSchema(conf))) {
                options.withValueSchema(valueSchema);
            }
            this.mReader = new AvroSequenceFile.Reader(options);
            this.mEnd = fileSplit.getStart() + fileSplit.getLength();
            if (fileSplit.getStart() > this.mReader.getPosition()) {
                this.mReader.sync(fileSplit.getStart());
            }
            this.mStart = this.mReader.getPosition();
            this.mHasMoreData = this.mStart < this.mEnd;
        }

        public boolean nextKeyValue() throws IOException, InterruptedException {
            if (!this.mHasMoreData) {
                return false;
            }
            long pos = this.mReader.getPosition();
            this.mCurrentKey = this.mReader.next(this.mCurrentKey);
            if (null == this.mCurrentKey || pos >= this.mEnd && this.mReader.syncSeen()) {
                this.mHasMoreData = false;
                this.mCurrentKey = null;
                this.mCurrentValue = null;
            } else {
                this.mCurrentValue = this.mReader.getCurrentValue(this.mCurrentValue);
            }
            return this.mHasMoreData;
        }

        public K getCurrentKey() {
            return this.mCurrentKey;
        }

        public V getCurrentValue() {
            return this.mCurrentValue;
        }

        public float getProgress() throws IOException {
            if (this.mEnd == this.mStart) {
                return 0.0f;
            }
            return Math.min(1.0f, (float)(this.mReader.getPosition() - this.mStart) / (float)(this.mEnd - this.mStart));
        }

        public synchronized void close() throws IOException {
            this.mReader.close();
        }
    }
}

