/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.mapreduce;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.avro.Schema;
import org.apache.avro.file.CodecFactory;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.hadoop.io.AvroDatumConverter;
import org.apache.avro.hadoop.io.AvroKeyValue;
import org.apache.avro.reflect.ReflectDatumWriter;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class AvroKeyValueRecordWriter<K, V>
extends RecordWriter<K, V> {
    private final DataFileWriter<GenericRecord> mAvroFileWriter;
    private final Schema mKeyValuePairSchema;
    private final AvroKeyValue<Object, Object> mOutputRecord;
    private final AvroDatumConverter<K, ?> mKeyConverter;
    private final AvroDatumConverter<V, ?> mValueConverter;

    public AvroKeyValueRecordWriter(AvroDatumConverter<K, ?> keyConverter2, AvroDatumConverter<V, ?> valueConverter2, CodecFactory compressionCodec, OutputStream outputStream) throws IOException {
        this.mKeyValuePairSchema = AvroKeyValue.getSchema(keyConverter2.getWriterSchema(), valueConverter2.getWriterSchema());
        this.mAvroFileWriter = new DataFileWriter(new ReflectDatumWriter(this.mKeyValuePairSchema));
        this.mAvroFileWriter.setCodec(compressionCodec);
        this.mAvroFileWriter.create(this.mKeyValuePairSchema, outputStream);
        this.mKeyConverter = keyConverter2;
        this.mValueConverter = valueConverter2;
        this.mOutputRecord = new AvroKeyValue(new GenericData.Record(this.mKeyValuePairSchema));
    }

    public Schema getWriterSchema() {
        return this.mKeyValuePairSchema;
    }

    public void write(K key, V value2) throws IOException {
        this.mOutputRecord.setKey(this.mKeyConverter.convert(key));
        this.mOutputRecord.setValue(this.mValueConverter.convert(value2));
        this.mAvroFileWriter.append(this.mOutputRecord.get());
    }

    public void close(TaskAttemptContext context) throws IOException {
        this.mAvroFileWriter.close();
    }
}

