/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.mapred.tether;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.avro.Schema;
import org.apache.avro.file.CodecFactory;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.mapred.AvroJob;
import org.apache.avro.mapred.tether.TetherData;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.Progressable;

class TetherOutputFormat
extends FileOutputFormat<TetherData, NullWritable> {
    TetherOutputFormat() {
    }

    public static void setDeflateLevel(JobConf job, int level) {
        FileOutputFormat.setCompressOutput((JobConf)job, (boolean)true);
        job.setInt("avro.mapred.deflate.level", level);
    }

    public RecordWriter<TetherData, NullWritable> getRecordWriter(FileSystem ignore, JobConf job, String name2, Progressable prog) throws IOException {
        Schema schema = AvroJob.getOutputSchema((Configuration)job);
        final DataFileWriter writer = new DataFileWriter(new GenericDatumWriter());
        if (FileOutputFormat.getCompressOutput((JobConf)job)) {
            int level = job.getInt("avro.mapred.deflate.level", 1);
            writer.setCodec(CodecFactory.deflateCodec(level));
        }
        Path path = FileOutputFormat.getTaskOutputPath((JobConf)job, (String)(name2 + ".avro"));
        writer.create(schema, (OutputStream)path.getFileSystem((Configuration)job).create(path));
        return new RecordWriter<TetherData, NullWritable>(){

            public void write(TetherData datum, NullWritable ignore) throws IOException {
                writer.appendEncoded(datum.buffer());
            }

            public void close(Reporter reporter) throws IOException {
                writer.close();
            }
        };
    }
}

