/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.mapred;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericContainer;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.IndexedRecord;
import org.apache.avro.reflect.ReflectData;
import org.apache.avro.specific.SpecificData;

public class Pair<K, V>
implements IndexedRecord,
Comparable<Pair>,
SpecificData.SchemaConstructable {
    private static final String PAIR = Pair.class.getName();
    private static final String KEY = "key";
    private static final String VALUE = "value";
    private Schema schema;
    private K key;
    private V value;
    private static final Map<Schema, Map<Schema, Schema>> SCHEMA_CACHE = new WeakHashMap<Schema, Map<Schema, Schema>>();
    private static final Schema STRING_SCHEMA = Schema.create(Schema.Type.STRING);
    private static final Schema BYTES_SCHEMA = Schema.create(Schema.Type.BYTES);
    private static final Schema INT_SCHEMA = Schema.create(Schema.Type.INT);
    private static final Schema LONG_SCHEMA = Schema.create(Schema.Type.LONG);
    private static final Schema FLOAT_SCHEMA = Schema.create(Schema.Type.FLOAT);
    private static final Schema DOUBLE_SCHEMA = Schema.create(Schema.Type.DOUBLE);
    private static final Schema NULL_SCHEMA = Schema.create(Schema.Type.NULL);

    public Pair(Schema schema) {
        Pair.checkIsPairSchema(schema);
        this.schema = schema;
    }

    public Pair(K key, Schema keySchema, V value2, Schema valueSchema) {
        this.schema = Pair.getPairSchema(keySchema, valueSchema);
        this.key = key;
        this.value = value2;
    }

    private static void checkIsPairSchema(Schema schema) {
        if (!PAIR.equals(schema.getFullName())) {
            throw new IllegalArgumentException("Not a Pair schema: " + schema);
        }
    }

    public static Schema getKeySchema(Schema pair2) {
        Pair.checkIsPairSchema(pair2);
        return pair2.getField(KEY).schema();
    }

    public static Schema getValueSchema(Schema pair2) {
        Pair.checkIsPairSchema(pair2);
        return pair2.getField(VALUE).schema();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Schema getPairSchema(Schema key, Schema value2) {
        Map<Schema, Map<Schema, Schema>> map2 = SCHEMA_CACHE;
        synchronized (map2) {
            Schema result2;
            Map<Schema, Schema> valueSchemas = SCHEMA_CACHE.get(key);
            if (valueSchemas == null) {
                valueSchemas = new WeakHashMap<Schema, Schema>();
                SCHEMA_CACHE.put(key, valueSchemas);
            }
            if ((result2 = valueSchemas.get(value2)) == null) {
                result2 = Pair.makePairSchema(key, value2);
                valueSchemas.put(value2, result2);
            }
            return result2;
        }
    }

    private static Schema makePairSchema(Schema key, Schema value2) {
        Schema pair2 = Schema.createRecord(PAIR, null, null, false);
        ArrayList<Schema.Field> fields2 = new ArrayList<Schema.Field>();
        fields2.add(new Schema.Field(KEY, key, "", null));
        fields2.add(new Schema.Field(VALUE, value2, "", null, Schema.Field.Order.IGNORE));
        pair2.setFields(fields2);
        return pair2;
    }

    @Override
    public Schema getSchema() {
        return this.schema;
    }

    public K key() {
        return this.key;
    }

    public void key(K key) {
        this.key = key;
    }

    public V value() {
        return this.value;
    }

    public void value(V value2) {
        this.value = value2;
    }

    public void set(K key, V value2) {
        this.key = key;
        this.value = value2;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Pair)) {
            return false;
        }
        Pair that = (Pair)o;
        if (!this.schema.equals(that.schema)) {
            return false;
        }
        return this.compareTo(that) == 0;
    }

    public int hashCode() {
        return GenericData.get().hashCode(this, this.schema);
    }

    @Override
    public int compareTo(Pair that) {
        return GenericData.get().compare(this, that, this.schema);
    }

    public String toString() {
        return GenericData.get().toString(this);
    }

    @Override
    public Object get(int i) {
        switch (i) {
            case 0: {
                return this.key;
            }
            case 1: {
                return this.value;
            }
        }
        throw new AvroRuntimeException("Bad index: " + i);
    }

    @Override
    public void put(int i, Object o) {
        switch (i) {
            case 0: {
                this.key = o;
                break;
            }
            case 1: {
                this.value = o;
                break;
            }
            default: {
                throw new AvroRuntimeException("Bad index: " + i);
            }
        }
    }

    public Pair(Object key, Object value2) {
        this(key, Pair.getSchema(key), value2, Pair.getSchema(value2));
    }

    public Pair(Object key, GenericContainer value2) {
        this(key, Pair.getSchema(key), value2, value2.getSchema());
    }

    public Pair(Object key, CharSequence value2) {
        this(key, Pair.getSchema(key), value2, STRING_SCHEMA);
    }

    public Pair(Object key, ByteBuffer value2) {
        this(key, Pair.getSchema(key), value2, BYTES_SCHEMA);
    }

    public Pair(Object key, Integer value2) {
        this(key, Pair.getSchema(key), value2, INT_SCHEMA);
    }

    public Pair(Object key, Long value2) {
        this(key, Pair.getSchema(key), value2, LONG_SCHEMA);
    }

    public Pair(Object key, Float value2) {
        this(key, Pair.getSchema(key), value2, FLOAT_SCHEMA);
    }

    public Pair(Object key, Double value2) {
        this(key, Pair.getSchema(key), value2, DOUBLE_SCHEMA);
    }

    public Pair(Object key, Void value2) {
        this(key, Pair.getSchema(key), value2, NULL_SCHEMA);
    }

    public Pair(GenericContainer key, Object value2) {
        this(key, key.getSchema(), value2, Pair.getSchema(value2));
    }

    public Pair(GenericContainer key, GenericContainer value2) {
        this(key, key.getSchema(), value2, value2.getSchema());
    }

    public Pair(GenericContainer key, CharSequence value2) {
        this(key, key.getSchema(), value2, STRING_SCHEMA);
    }

    public Pair(GenericContainer key, ByteBuffer value2) {
        this(key, key.getSchema(), value2, BYTES_SCHEMA);
    }

    public Pair(GenericContainer key, Integer value2) {
        this(key, key.getSchema(), value2, INT_SCHEMA);
    }

    public Pair(GenericContainer key, Long value2) {
        this(key, key.getSchema(), value2, LONG_SCHEMA);
    }

    public Pair(GenericContainer key, Float value2) {
        this(key, key.getSchema(), value2, FLOAT_SCHEMA);
    }

    public Pair(GenericContainer key, Double value2) {
        this(key, key.getSchema(), value2, DOUBLE_SCHEMA);
    }

    public Pair(GenericContainer key, Void value2) {
        this(key, key.getSchema(), value2, NULL_SCHEMA);
    }

    public Pair(CharSequence key, Object value2) {
        this(key, STRING_SCHEMA, value2, Pair.getSchema(value2));
    }

    public Pair(CharSequence key, GenericContainer value2) {
        this(key, STRING_SCHEMA, value2, value2.getSchema());
    }

    public Pair(CharSequence key, CharSequence value2) {
        this(key, STRING_SCHEMA, value2, STRING_SCHEMA);
    }

    public Pair(CharSequence key, ByteBuffer value2) {
        this(key, STRING_SCHEMA, value2, BYTES_SCHEMA);
    }

    public Pair(CharSequence key, Integer value2) {
        this(key, STRING_SCHEMA, value2, INT_SCHEMA);
    }

    public Pair(CharSequence key, Long value2) {
        this(key, STRING_SCHEMA, value2, LONG_SCHEMA);
    }

    public Pair(CharSequence key, Float value2) {
        this(key, STRING_SCHEMA, value2, FLOAT_SCHEMA);
    }

    public Pair(CharSequence key, Double value2) {
        this(key, STRING_SCHEMA, value2, DOUBLE_SCHEMA);
    }

    public Pair(CharSequence key, Void value2) {
        this(key, STRING_SCHEMA, value2, NULL_SCHEMA);
    }

    public Pair(ByteBuffer key, Object value2) {
        this(key, BYTES_SCHEMA, value2, Pair.getSchema(value2));
    }

    public Pair(ByteBuffer key, GenericContainer value2) {
        this(key, BYTES_SCHEMA, value2, value2.getSchema());
    }

    public Pair(ByteBuffer key, CharSequence value2) {
        this(key, BYTES_SCHEMA, value2, STRING_SCHEMA);
    }

    public Pair(ByteBuffer key, ByteBuffer value2) {
        this(key, BYTES_SCHEMA, value2, BYTES_SCHEMA);
    }

    public Pair(ByteBuffer key, Integer value2) {
        this(key, BYTES_SCHEMA, value2, INT_SCHEMA);
    }

    public Pair(ByteBuffer key, Long value2) {
        this(key, BYTES_SCHEMA, value2, LONG_SCHEMA);
    }

    public Pair(ByteBuffer key, Float value2) {
        this(key, BYTES_SCHEMA, value2, FLOAT_SCHEMA);
    }

    public Pair(ByteBuffer key, Double value2) {
        this(key, BYTES_SCHEMA, value2, DOUBLE_SCHEMA);
    }

    public Pair(ByteBuffer key, Void value2) {
        this(key, BYTES_SCHEMA, value2, NULL_SCHEMA);
    }

    public Pair(Integer key, Object value2) {
        this(key, INT_SCHEMA, value2, Pair.getSchema(value2));
    }

    public Pair(Integer key, GenericContainer value2) {
        this(key, INT_SCHEMA, value2, value2.getSchema());
    }

    public Pair(Integer key, CharSequence value2) {
        this(key, INT_SCHEMA, value2, STRING_SCHEMA);
    }

    public Pair(Integer key, ByteBuffer value2) {
        this(key, INT_SCHEMA, value2, BYTES_SCHEMA);
    }

    public Pair(Integer key, Integer value2) {
        this(key, INT_SCHEMA, value2, INT_SCHEMA);
    }

    public Pair(Integer key, Long value2) {
        this(key, INT_SCHEMA, value2, LONG_SCHEMA);
    }

    public Pair(Integer key, Float value2) {
        this(key, INT_SCHEMA, value2, FLOAT_SCHEMA);
    }

    public Pair(Integer key, Double value2) {
        this(key, INT_SCHEMA, value2, DOUBLE_SCHEMA);
    }

    public Pair(Integer key, Void value2) {
        this(key, INT_SCHEMA, value2, NULL_SCHEMA);
    }

    public Pair(Long key, Object value2) {
        this(key, LONG_SCHEMA, value2, Pair.getSchema(value2));
    }

    public Pair(Long key, GenericContainer value2) {
        this(key, LONG_SCHEMA, value2, value2.getSchema());
    }

    public Pair(Long key, CharSequence value2) {
        this(key, LONG_SCHEMA, value2, STRING_SCHEMA);
    }

    public Pair(Long key, ByteBuffer value2) {
        this(key, LONG_SCHEMA, value2, BYTES_SCHEMA);
    }

    public Pair(Long key, Integer value2) {
        this(key, LONG_SCHEMA, value2, INT_SCHEMA);
    }

    public Pair(Long key, Long value2) {
        this(key, LONG_SCHEMA, value2, LONG_SCHEMA);
    }

    public Pair(Long key, Float value2) {
        this(key, LONG_SCHEMA, value2, FLOAT_SCHEMA);
    }

    public Pair(Long key, Double value2) {
        this(key, LONG_SCHEMA, value2, DOUBLE_SCHEMA);
    }

    public Pair(Long key, Void value2) {
        this(key, LONG_SCHEMA, value2, NULL_SCHEMA);
    }

    public Pair(Float key, Object value2) {
        this(key, FLOAT_SCHEMA, value2, Pair.getSchema(value2));
    }

    public Pair(Float key, GenericContainer value2) {
        this(key, FLOAT_SCHEMA, value2, value2.getSchema());
    }

    public Pair(Float key, CharSequence value2) {
        this(key, FLOAT_SCHEMA, value2, STRING_SCHEMA);
    }

    public Pair(Float key, ByteBuffer value2) {
        this(key, FLOAT_SCHEMA, value2, BYTES_SCHEMA);
    }

    public Pair(Float key, Integer value2) {
        this(key, FLOAT_SCHEMA, value2, INT_SCHEMA);
    }

    public Pair(Float key, Long value2) {
        this(key, FLOAT_SCHEMA, value2, LONG_SCHEMA);
    }

    public Pair(Float key, Float value2) {
        this(key, FLOAT_SCHEMA, value2, FLOAT_SCHEMA);
    }

    public Pair(Float key, Double value2) {
        this(key, FLOAT_SCHEMA, value2, DOUBLE_SCHEMA);
    }

    public Pair(Float key, Void value2) {
        this(key, FLOAT_SCHEMA, value2, NULL_SCHEMA);
    }

    public Pair(Double key, Object value2) {
        this(key, DOUBLE_SCHEMA, value2, Pair.getSchema(value2));
    }

    public Pair(Double key, GenericContainer value2) {
        this(key, DOUBLE_SCHEMA, value2, value2.getSchema());
    }

    public Pair(Double key, CharSequence value2) {
        this(key, DOUBLE_SCHEMA, value2, STRING_SCHEMA);
    }

    public Pair(Double key, ByteBuffer value2) {
        this(key, DOUBLE_SCHEMA, value2, BYTES_SCHEMA);
    }

    public Pair(Double key, Integer value2) {
        this(key, DOUBLE_SCHEMA, value2, INT_SCHEMA);
    }

    public Pair(Double key, Long value2) {
        this(key, DOUBLE_SCHEMA, value2, LONG_SCHEMA);
    }

    public Pair(Double key, Float value2) {
        this(key, DOUBLE_SCHEMA, value2, FLOAT_SCHEMA);
    }

    public Pair(Double key, Double value2) {
        this(key, DOUBLE_SCHEMA, value2, DOUBLE_SCHEMA);
    }

    public Pair(Double key, Void value2) {
        this(key, DOUBLE_SCHEMA, value2, NULL_SCHEMA);
    }

    public Pair(Void key, Object value2) {
        this(key, NULL_SCHEMA, value2, Pair.getSchema(value2));
    }

    public Pair(Void key, GenericContainer value2) {
        this(key, NULL_SCHEMA, value2, value2.getSchema());
    }

    public Pair(Void key, CharSequence value2) {
        this(key, NULL_SCHEMA, value2, STRING_SCHEMA);
    }

    public Pair(Void key, ByteBuffer value2) {
        this(key, NULL_SCHEMA, value2, BYTES_SCHEMA);
    }

    public Pair(Void key, Integer value2) {
        this(key, NULL_SCHEMA, value2, INT_SCHEMA);
    }

    public Pair(Void key, Long value2) {
        this(key, NULL_SCHEMA, value2, LONG_SCHEMA);
    }

    public Pair(Void key, Float value2) {
        this(key, NULL_SCHEMA, value2, FLOAT_SCHEMA);
    }

    public Pair(Void key, Double value2) {
        this(key, NULL_SCHEMA, value2, DOUBLE_SCHEMA);
    }

    public Pair(Void key, Void value2) {
        this(key, NULL_SCHEMA, value2, NULL_SCHEMA);
    }

    private static Schema getSchema(Object o) {
        try {
            return ReflectData.get().getSchema(o.getClass());
        }
        catch (AvroRuntimeException e) {
            throw new AvroRuntimeException("Cannot infer schema for : " + o.getClass() + ".  Must create Pair with explicit key and value schemas.", e);
        }
    }
}

