/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.mapred;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.mapred.AvroOutputFormat;
import org.apache.avro.reflect.ReflectDatumWriter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.Progressable;

public class AvroTextOutputFormat<K, V>
extends FileOutputFormat<K, V> {
    private static final String UTF8 = "UTF-8";

    public RecordWriter<K, V> getRecordWriter(FileSystem ignore, JobConf job, String name2, Progressable prog) throws IOException {
        Schema schema = Schema.create(Schema.Type.BYTES);
        byte[] keyValueSeparator = job.get("mapreduce.output.textoutputformat.separator", "\t").getBytes(UTF8);
        DataFileWriter<ByteBuffer> writer = new DataFileWriter<ByteBuffer>(new ReflectDatumWriter());
        AvroOutputFormat.configureDataFileWriter(writer, job);
        Path path = FileOutputFormat.getTaskOutputPath((JobConf)job, (String)(name2 + ".avro"));
        writer.create(schema, (OutputStream)path.getFileSystem((Configuration)job).create(path));
        return new AvroTextRecordWriter(writer, keyValueSeparator);
    }

    class AvroTextRecordWriter
    implements RecordWriter<K, V> {
        private final DataFileWriter<ByteBuffer> writer;
        private final byte[] keyValueSeparator;

        public AvroTextRecordWriter(DataFileWriter<ByteBuffer> writer, byte[] keyValueSeparator) {
            this.writer = writer;
            this.keyValueSeparator = keyValueSeparator;
        }

        public void write(K key, V value2) throws IOException {
            boolean nullValue;
            boolean nullKey = key == null || key instanceof NullWritable;
            boolean bl = nullValue = value2 == null || value2 instanceof NullWritable;
            if (nullKey && nullValue) {
                return;
            }
            if (!nullKey && nullValue) {
                this.writer.append(this.toByteBuffer(key));
            } else if (nullKey && !nullValue) {
                this.writer.append(this.toByteBuffer(value2));
            } else {
                this.writer.append(this.toByteBuffer(key, this.keyValueSeparator, value2));
            }
        }

        public void close(Reporter reporter) throws IOException {
            this.writer.close();
        }

        private ByteBuffer toByteBuffer(Object o) throws IOException {
            if (o instanceof Text) {
                Text to2 = (Text)o;
                return ByteBuffer.wrap(to2.getBytes(), 0, to2.getLength());
            }
            return ByteBuffer.wrap(o.toString().getBytes(AvroTextOutputFormat.UTF8));
        }

        private ByteBuffer toByteBuffer(Object key, byte[] sep, Object value2) throws IOException {
            int valLength;
            byte[] valBytes;
            int keyLength;
            byte[] keyBytes;
            if (key instanceof Text) {
                Text tkey = (Text)key;
                keyBytes = tkey.getBytes();
                keyLength = tkey.getLength();
            } else {
                keyBytes = key.toString().getBytes(AvroTextOutputFormat.UTF8);
                keyLength = keyBytes.length;
            }
            if (value2 instanceof Text) {
                Text tval = (Text)value2;
                valBytes = tval.getBytes();
                valLength = tval.getLength();
            } else {
                valBytes = value2.toString().getBytes(AvroTextOutputFormat.UTF8);
                valLength = valBytes.length;
            }
            ByteBuffer buf = ByteBuffer.allocate(keyLength + sep.length + valLength);
            buf.put(keyBytes, 0, keyLength);
            buf.put(sep);
            buf.put(valBytes, 0, valLength);
            buf.rewind();
            return buf;
        }
    }
}

