/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.mapred;

import java.io.IOException;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.FileReader;
import org.apache.avro.mapred.AvroJob;
import org.apache.avro.mapred.AvroWrapper;
import org.apache.avro.mapred.FsInput;
import org.apache.avro.reflect.ReflectDatumReader;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;

public class AvroRecordReader<T>
implements RecordReader<AvroWrapper<T>, NullWritable> {
    private FileReader<T> reader;
    private long start;
    private long end;

    public AvroRecordReader(JobConf job, FileSplit split2) throws IOException {
        this(DataFileReader.openReader(new FsInput(split2.getPath(), (Configuration)job), job.getBoolean("avro.input.is.reflect", false) ? new ReflectDatumReader(AvroJob.getInputSchema((Configuration)job)) : new SpecificDatumReader(AvroJob.getInputSchema((Configuration)job))), split2);
    }

    protected AvroRecordReader(FileReader<T> reader, FileSplit split2) throws IOException {
        this.reader = reader;
        reader.sync(split2.getStart());
        this.start = reader.tell();
        this.end = split2.getStart() + split2.getLength();
    }

    public AvroWrapper<T> createKey() {
        return new AvroWrapper<Object>(null);
    }

    public NullWritable createValue() {
        return NullWritable.get();
    }

    public boolean next(AvroWrapper<T> wrapper2, NullWritable ignore) throws IOException {
        if (!this.reader.hasNext() || this.reader.pastSync(this.end)) {
            return false;
        }
        wrapper2.datum(this.reader.next(wrapper2.datum()));
        return true;
    }

    public float getProgress() throws IOException {
        if (this.end == this.start) {
            return 0.0f;
        }
        return Math.min(1.0f, (float)(this.getPos() - this.start) / (float)(this.end - this.start));
    }

    public long getPos() throws IOException {
        return this.reader.tell();
    }

    public void close() throws IOException {
        this.reader.close();
    }
}

