/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.mapred;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.FileReader;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.mapred.FsInput;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;

class AvroAsTextRecordReader<T>
implements RecordReader<Text, Text> {
    private FileReader<T> reader;
    private T datum;
    private long start;
    private long end;

    public AvroAsTextRecordReader(JobConf job, FileSplit split2) throws IOException {
        this(DataFileReader.openReader(new FsInput(split2.getPath(), (Configuration)job), new GenericDatumReader()), split2);
    }

    protected AvroAsTextRecordReader(FileReader<T> reader, FileSplit split2) throws IOException {
        this.reader = reader;
        reader.sync(split2.getStart());
        this.start = reader.tell();
        this.end = split2.getStart() + split2.getLength();
    }

    public Text createKey() {
        return new Text();
    }

    public Text createValue() {
        return new Text();
    }

    public boolean next(Text key, Text ignore) throws IOException {
        if (!this.reader.hasNext() || this.reader.pastSync(this.end)) {
            return false;
        }
        this.datum = this.reader.next(this.datum);
        if (this.datum instanceof ByteBuffer) {
            ByteBuffer b = (ByteBuffer)this.datum;
            if (b.hasArray()) {
                int offset = b.arrayOffset();
                int start = b.position();
                int length = b.remaining();
                key.set(b.array(), offset + start, offset + start + length);
            } else {
                byte[] bytes2 = new byte[b.remaining()];
                b.duplicate().get(bytes2);
                key.set(bytes2);
            }
        } else {
            key.set(this.datum.toString());
        }
        return true;
    }

    public float getProgress() throws IOException {
        if (this.end == this.start) {
            return 0.0f;
        }
        return Math.min(1.0f, (float)(this.getPos() - this.start) / (float)(this.end - this.start));
    }

    public long getPos() throws IOException {
        return this.reader.tell();
    }

    public void close() throws IOException {
        this.reader.close();
    }
}

