/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.ipc.trace;

import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.ipc.trace.ID;
import org.apache.avro.ipc.trace.Span;
import org.apache.avro.ipc.trace.SpanEvent;
import org.apache.avro.ipc.trace.TimestampedEvent;

class Util {
    private static final Random RANDOM = new Random();
    private static final int NANOS_PER_MILI = 1000000;

    Util() {
    }

    public static EnumSet<SpanEvent> getAllEvents(Span s2) {
        EnumSet<SpanEvent> foundEvents = EnumSet.noneOf(SpanEvent.class);
        for (TimestampedEvent event : s2.events) {
            if (!(event.event instanceof SpanEvent)) continue;
            foundEvents.add((SpanEvent)((Object)event.event));
        }
        return foundEvents;
    }

    public static int getPayloadSize(List<ByteBuffer> payload) {
        if (payload == null) {
            return 0;
        }
        int size2 = 0;
        for (ByteBuffer bb : payload) {
            size2 += bb.limit();
        }
        return size2;
    }

    public static Span createEventlessSpan(ID traceID, ID spanID, ID parentSpanID) {
        Span span2 = new Span();
        span2.complete = false;
        if (traceID == null) {
            byte[] traceIDBytes = new byte[8];
            RANDOM.nextBytes(traceIDBytes);
            span2.traceID = new ID();
            span2.traceID.bytes(traceIDBytes);
        } else {
            span2.traceID = new ID();
            span2.traceID.bytes((byte[])traceID.bytes().clone());
        }
        if (spanID == null) {
            byte[] spanIDBytes = new byte[8];
            RANDOM.nextBytes(spanIDBytes);
            span2.spanID = new ID();
            span2.spanID.bytes(spanIDBytes);
        } else {
            span2.spanID = new ID();
            span2.spanID.bytes((byte[])spanID.bytes().clone());
        }
        if (parentSpanID != null) {
            span2.parentSpanID = new ID();
            span2.parentSpanID.bytes((byte[])parentSpanID.bytes().clone());
        }
        span2.events = new GenericData.Array<TimestampedEvent>(10, Schema.createArray(TimestampedEvent.SCHEMA$));
        return span2;
    }

    public static void addEvent(Span span2, SpanEvent eventType) {
        TimestampedEvent ev = new TimestampedEvent();
        ev.event = eventType;
        ev.timeStamp = System.currentTimeMillis() * 1000000L;
        span2.events.add(ev);
    }

    public static long longValue(ID in) {
        if (in == null) {
            throw new IllegalArgumentException("ID cannot be null");
        }
        if (in.bytes() == null) {
            throw new IllegalArgumentException("ID cannot be empty");
        }
        if (in.bytes().length != 8) {
            throw new IllegalArgumentException("ID must be 8 bytes");
        }
        ByteBuffer buff = ByteBuffer.wrap(in.bytes());
        return buff.getLong();
    }

    public static ID idValue(long in) {
        byte[] bArray = new byte[8];
        ByteBuffer bBuffer = ByteBuffer.wrap(bArray);
        LongBuffer lBuffer = bBuffer.asLongBuffer();
        lBuffer.put(0, in);
        ID out = new ID();
        out.bytes(bArray);
        return out;
    }

    public static boolean idsEqual(ID a, ID b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return Arrays.equals(a.bytes(), b.bytes());
    }

    public static String printableTime(long stamp) {
        String out = "";
        double milliseconds = (double)stamp / 1000000.0;
        return String.format("%.2fms", milliseconds);
    }

    public static String printableBytes(long bytes2) {
        if (bytes2 < 1024L) {
            return Long.toString(bytes2) + "b";
        }
        if (bytes2 < 0x100000L) {
            double kb = (double)bytes2 / 1024.0;
            return String.format("%.2fkb", kb);
        }
        double mb = (double)bytes2 / 1048576.0;
        return String.format("%.2fmb", mb);
    }

    public static boolean spanInRange(Span s2, long start, long end) {
        long startTime = 0L;
        long endTime = 0L;
        for (TimestampedEvent e : s2.events) {
            if (!(e.event instanceof SpanEvent)) continue;
            SpanEvent ev = (SpanEvent)((Object)e.event);
            switch (ev) {
                case CLIENT_SEND: {
                    startTime = e.timeStamp;
                }
                case SERVER_RECV: {
                    startTime = e.timeStamp;
                }
                case CLIENT_RECV: {
                    endTime = e.timeStamp;
                }
                case SERVER_SEND: {
                    endTime = e.timeStamp;
                }
            }
        }
        return startTime > start && endTime < end;
    }

    public static <T> List<T> sampledList(List<T> input2, int maxEntries) {
        int timesTooLarge = (int)Math.ceil((double)input2.size() / (double)maxEntries);
        if (timesTooLarge <= 1) {
            return new ArrayList<T>(input2);
        }
        ArrayList<T> out = new ArrayList<T>();
        for (int i = 0; i < input2.size(); ++i) {
            if (i % timesTooLarge != 0) continue;
            out.add(input2.get(i));
        }
        return out;
    }
}

